#ifndef _KPICONLOADER_H_
#define _KPICONLOADER_H_

#include <qpixmap.h>
#include <qdict.h>
#include <qstring.h>
#include <qlist.h>

class KPIconLoader
{
public:
	KPIconLoader(const QString& pathname, bool useKDE = FALSE);
	QPixmap* loadIcon(const QString& name, const QString& def = 0);
	QPixmap* loadMiniIcon(const QString& name, const QString& def = 0);
	QPixmap* loadToolBarIcon(const QString& name);
	QPixmap* loadKDEIcon(const QString& name);
	void reloadIcons(bool useKDE, const QString& str);
	QPixmap changeIcon(QListIterator<QString> *it, const char *name);

private:
	QDict<QPixmap>	Icons;
	QList<QString>	Path, KDEPath;
	bool		UseKDE;
};

#endif

