#include "ksiconlist.h"
#include <iostream.h>

#ifndef ICON_HEIGHT
#define ICON_HEIGHT	18
#endif

#include <qbitmap.h>
#define mask_width 16
#define mask_height 16
static unsigned char mask_bits[] = {
   0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55,
   0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55,
   0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55};

KSmallIconList::KSmallIconList(QWidget *parent, const char *name, WFlags f)
	: KFileListBase(parent,name,f)
{
	setTableFlags(Tbl_hScrollBar | Tbl_smoothScrolling);
	setLineWidth(1);
	setFrameStyle(QFrame::Panel | QFrame::Sunken);
	setCellHeight(ICON_HEIGHT);
	setCellWidth(10*ICON_HEIGHT);
	Mask.resize(16,16);
	Mask.fill(backgroundColor());
	QBitmap	bm(mask_width,mask_height,mask_bits);
	Mask.setMask(bm);
}

void KSmallIconList::paintCell(QPainter *p, int row, int col)
{
	int		index = col*numRows()+row;
	FileInfo	*item = index < (int)(FileList->count()) ? FileList->at(index) : 0;
	if (item) {
		if (Selected->findRef(item) != -1) {
			p->setBrush(darkBlue);
			p->drawRect(0,0,cellWidth(),cellHeight());
			p->setBrush(NoBrush);
			p->drawWinFocusRect(0,0,cellWidth(),cellHeight());
			p->setRasterOp(NotROP);
			p->drawText(cellHeight(),0,cellWidth()-cellHeight(),cellHeight(),AlignVCenter,item->fileName().data());
			p->setRasterOp(CopyROP);
		}
		else p->drawText(cellHeight(),0,cellWidth()-cellHeight(),cellHeight(),AlignVCenter,item->fileName().data());
		p->drawPixmap(1,1,*(item->miniIcon()));
		if (item->isSymLink() && LinkArrow) {
			p->drawPixmap(1,1,*LinkArrow);
		}
		if (item->isCutted()) p->drawPixmap(1,1,Mask);
		p->setPen(colorGroup().text());
	}
}

void KSmallIconList::resizeEvent(QResizeEvent *)
{
	setNumRows(QMAX(viewHeight()/cellHeight(),1));
	if (FileList) setNumCols(FileList->count()/numRows()+1);
	else setNumCols(0);
	QTableView::resizeEvent(0);
}

void KSmallIconList::getTablePosition(int index, int& row, int& col)
{
	col = index / numRows();
	row = index - col*numRows();
}

bool KSmallIconList::getItemCell(int row, int col, FileInfo **item, QPoint p)
{
	bool	selected = FALSE;
	*item = 0;
	int	index = QMAX(col,0)*numRows()+row;
	QFontMetrics	fm(font());
	if (FileList == 0 || index >= (int)(FileList->count())) return selected;
	*item = FileList->at(index);
	if (p.x()+xOffset()+lineWidth() < col*cellWidth()+cellHeight()+fm.width((*item)->fileName().data()))
		selected = TRUE;
	return selected;
}

QRect KSmallIconList::getItemTextRect(FileInfo *item)
{
	int	row,col;
	getTablePosition(item->index(),row,col);
	return QRect(col*cellWidth()+lineWidth()+cellHeight()-xOffset(),row*cellHeight()+lineWidth()-yOffset(),
		     cellWidth()-cellHeight(),cellHeight());
}

void KSmallIconList::updateListSize()
{
	updateColumnWidth();
	if (FileList && FileList->count() > 0)
		setNumCols(FileList->count()/numRows()+1);
	else setNumCols(0);
}

void KSmallIconList::updateColumnWidth()
{
	if (!FileList) setCellWidth(10*ICON_HEIGHT);
	else {
		FileInfoListIterator	it(*FileList);
		QFontMetrics	fm(fontMetrics());
		int	w(0), w2;
		for (;it.current();++it) if ((w2=fm.width(it.current()->fileName().data())) > w) w = w2;
		w += (ICON_HEIGHT + 10);
		setCellWidth(w);
	}
}
