
#ifndef _KBMAIN_H_
#define _KBMAIN_H_

#include "sound.h"
#include <fstream.h>
#include "defs.h"
#include "kbPosition.h"

#ifdef HAVE_ARTS
#include "arts.h"
#include "structbuilder.h"
#endif

#define MAXDEVNUM 16
#define CMDLENCTOP 400

class IfFactory;
class IfMain;
class KbTrack;
class KbScoreTrack;
class KbDrumTrack;
class KbPart;
class KbNote;
class KbWaveEvent;
class KbExtensionManager;
class KbPosition;

/**
 * This is the main Brahms class. main() will create exactly one object
 * of this class and a factory for the presentation as a parameter. If you want
 * to change the presentation, change the factory in the file main.C.
 * @short   The Brahms main class
 * @author  Jan Wuerthner
 * @version 0.95
 * @see     IfMain
 * @see     QtMain
 * @see     TxMain
 */
class KbMain
{
 private:
  IfFactory * ifFactory;
  IfMain * ifMain;
  KbTrack * track;
  // bool devOpen;
  DeviceManager * midi;
#ifdef HAVE_ARTS
 public:
  static Arts::Synthesizer_var synthesizer;
  static CORBA::ORB_var orb;
  static CORBA::BOA_var boa;
 private:
#endif
  KbExtensionManager * extMan;
  int snap;
  int tempo;
  int meter0;
  int meter1;
  char * devices[MAXDEVNUM];
  KbPosition position;
  int bars;
  int beats;
  int ticks;
  
  KbPosition selX1;
  KbPosition selX2;

  // play:
  
  int oldTimePos;
  bool needSync;
  int midiOff;
  bool playWait;
  int playTicks;
  int playTicksPB;
  int playBeats;
  int stop;
  int stopTK;
  int stopTk;
  int tNum;
  int left;
  int right;
  // KbPosition rightPosition;
  int revSTable[128];
  int revDTable[128];
  int revTable[128];
  KbScoreTrack * st[128];
  KbDrumTrack * dt[128];
  KbPart * csPart[128];
  KbPart * cdPart[128];
#ifdef HAVE_ARTS
  StructureBuilder * wBuilder[128];
#endif
  KbPosition wPosition[128];
  unsigned long stOff[128];
  unsigned long dtOff[128];
  int sstop[128];
  int dstop[128];
  int sRelVol[128];
  int dRelVol[128];
  int totVol;
  bool mute[128];
  KbNote * sus[256];
  int susCh[256];
  int susOut[256];
  KbPosition susPos[256];
  int susTr[256];
  int susFreq[256];
  KbPosition pp;
  KbPosition pp1;
  int kk;
  int susp;
  int fout;
  int pid;
  int fdToChild[2];
  int fdToParent[2];
  int partShow;
  // char bufCtoP[CMDLENCTOP + 1];
  // ssize_t ctop_read;
  int fback;
  int led[128]; // attention: QtMain has also got a led array of the same dimension!
  int count;
  int shift;
  char help[120];
  bool beepFlag;
  bool beepMidi;
  int beepCount;
  int preBeats;
  int clickInst;
  int clickVol;
  int clickVol1;
  int i;
  int answer;
  bool cycle;
  midifileinfo * fileInfo;
  // bool note[16][128];
  //  bool beepFlag;

  //  bool beepMidi;

  //  int clickInst;

  //  int clickVol;

  //  int preBeats;

  //  bool playWait;

 public:

  /**
   * Constructor. fac refers to the factory interface. The kb... classes do not own presentations
   * of their contents, especially no graphical presentations! The presentations will be
   * attached via this interface. E.g. QtFactory is derived from IfFactory
   * and creates the QtMain-object, QtTrack-objects , QtPart-objects, etc.
   * @param fac the factory that creates the presentation specific objects.
   * @param argc command line arguments.
   * @param argv command line arguments.
   */
  KbMain( IfFactory * fac, int argc, char ** argv );

  /**
   * adjust right border
   */
  // void adjustRightBorder();

  /**
   * returns the number of devices
   */
  int gNumberOfDevices();

  /**
   * @return the factory interface.
   */
  IfFactory * gFactory();

  /**
   * @return the main interface.
   */
  IfMain * gInterface();

  /**
   * returns the (n+1)th track. This might be zero! Further tracks are connected to the first track via next-chain.
   */
  KbTrack * gTrack(int n=0);

  /**
   * sets the first track. This is for internal use, e.g. when the first track gets deleted!
   */
  void sTrack(KbTrack * t);

  /**
   * This adds a track to the track-chain.
   * @return a pointer to the new track.
   */
  KbTrack * addTrack( int i=-1 );

  void convertTrack(KbTrack*,int);

  KbTrack * createTrack(int);

  /**
   * @return the name of the device descibed by the device number i.
   * @param i the device number.
   * @see #findDevices
   */
  char * gDevice(int i);

  /**
   * @return the current snap-value, which holds the midi-ticks used for quantization and other truncation.
   * @see #sSnap
   */
  int gSnap();

   /**
   * @return the current tempo value, midi data is played and recorded.
   * @see #sTempo
   */
  int gTempo();

  /**
   * This returns the current meter.
   * @param i call with i=0 to obtain the numerator, and with i=1 to obtain the nominator
   * @return the numerator, nominator resp.
   * @see #sMeter
   */
  int gMeter(int i);

  /**
   * This sets the snap value, which holds the midi-ticks used for quantization and other truncation.
   * @param s the snap value.
   * @see #gSnap
   */
  void sSnap(int s);

  /**
   * This sets the tempo value.
   * @param t the tempo
   * @see #gTempo
   */
  void sTempo(int t);

  /**
   * This sets the meter.
   * @param i call with i=0 to set the nominator to m, call with i=1 to set the numerator to m.
   * @param m the nominator, numerator resp.
   */
  void sMeter(int i,int m);

  /**
   * returns the time position (in ticks)
   */
  KbPosition gPos();

  /**
   * returns the left locator (in ticks)
   */
  KbPosition gLeftSel();

  /**
   * returns the right locator (in ticks)
   */
  KbPosition gRightSel();

  /**
   * returns the left locator (in bars)
   */
  int gLeftBar();

  /**
   * returns the right locator (in bars)
   */
  int gRightBar();

  /**
   * sets the left locator
   */
  void sLeftSel(long p=-1);
  void sLeftSel(KbPosition);
  void sLeftSel(int,int,int);

  /**
   * sets the right locator
   */
  void sRightSel(long p=-1);
  void sRightSel(KbPosition);
  void sRightSel(int,int,int);

  /**
   * returns either the first mastertrack's part or NULL
   */
  KbPart * Master();

  /**
   * toggles the cycle flag
   */
  void togCycle();

  /**
   * sets the position
   * either call with one parameter describing the position in ticks
   * or call with bar, beat and ticks
   */
  void sPos(unsigned long);
  void sPos(KbPosition);
  void sPos(int p, int b, int t);

  /**
   * same as sPos(int p, int b=-1, int t=-1), but returns and does not set the position!
   */
  // unsigned long gPosOf(int p, int b, int t);

  /**
   * returns the playWait variable, which is TRUE, if the playroutine shall wait for an acoustic signal before playing
   */
  bool gPlayWait();

  /**
   * does not set the position, and meter.
   * calculates (updates) bar, beat and tick values from position.
   * @param pos the position
   * @param t0 meter numerator
   * @param t1 meter nominator
   */
  //  void BBT(unsigned long pos, int t0=0, int t0=0);

  /**
   * returns the bar value.
   * @param pos if not -1: runs BBT(pos) first
   */
  // int gBar(long pos=-1, int t0=0, int t1=0);
  
  /**
   * returns the beat valuee.
   * @param pos if not -1: runs BBT(pos) first
   */
  // int gBeat(long pos=-1, int t0=0, int t1=0);

  /**
   * returns the beat valuee.
   * @param pos if not -1: runs BBT(pos) first
   */
  // int gTick(long pos=-1, int t0=0, int t1=0);

  /**
   * plays a song
   * @param tracki the track number to be played
   * @param off the offset (in midi ticks)
   * @param delt the number of midi ticks that are to be played
   */
  void play(int tracki=-1, unsigned long posleft=-1, unsigned long posright=-1);
  void playIt(int,int tracki=-1, unsigned long posleft=-1, unsigned long posright=-1);
#ifdef HAVE_ARTS
  void wavePlay(StructureBuilder*);
  StructureBuilder * waveInit(KbWaveEvent*);
#endif
  /**
   * stops playing
   */
  void stopAll(bool zero=false);

  void myWait(int);

  bool Playing();

  void hit(int out, int ch, int freq, int vol);

  void closeDev();

  void muteTrack(int);

  void updateInst(int,int);

  void updateVol(int);

  void updateTra(int);

  void waitForClap();

  void myBeep();

  // void playEvent(int);

  void answerParent();

  // void playListen(); -> class QtMain

  int gFback();

  // DeviceManager * gMidi();

  // KbPosition gRightPosition();

  // void sRightPosition(int p);

  void getMidi(char *);
  
  void getKooBase(ifstream *);

  void saveMidi(ofstream *);

  void saveKooBase(ofstream *);

  void clear();


  bool gBeepFlag();

  bool gBeepMidi();

  int gClickInst();

  int gClickVol();
  
  int gPreBeats();

  //bool gPlayWait();

  void sBeepFlag(bool b);

  void sBeepMidi(bool b);

  void sClickInst(int i);

  void sClickVol(int i);

  void sPreBeats(int i);
  
  void sPlayWait(bool b);
 
  KbExtensionManager * extManager();

};




#endif
