#ifndef _KBNOTE_C_
#define _KBNOTE_C_

#include "kbNote.h"
#include "kbNoteExt.h"
#include "kbLyrics.h"
#include "kbStem.h"
#include "kbExp.h"
#include "kbBow.h"

KbNote::KbNote( ) { }

KbNote::KbNote(int f, int v, int l, KbPosition p, int e, int c) : freq(f), vel(v), len(l), pos(p), enh(e), chan(c), ext(0) { }


int KbNote::gFreq() { return freq; }

int KbNote::gVel() { return vel; }

int KbNote::gLen() { return len; }

KbPosition KbNote::gPos() { return pos; }

int KbNote::gEnh() { return enh; }

int KbNote::gChan() { return chan; }

KbNoteExt * KbNote::gExt() { return ext; }


void KbNote::sFreq(int f) { freq=f; }

void KbNote::sVel(int v) { vel=v; if (vel>127) vel = 127; if (vel<1) vel = 1; }

void KbNote::sLen(int l) { len=l; if (len<0) len = 1; }

void KbNote::sPos(KbPosition p) { pos=p; if (pos<0) pos = 0; }

void KbNote::sEnh(int e) { enh=e; }

void KbNote::sChan(int c) { chan=c; }

void KbNote::sExt(KbNoteExt * e) { ext = e; }

void KbNote::appendExt(KbNoteExt * e) {
  KbNoteExt * last = 0;
  for (KbNoteExt * c = ext; c!=0; c=c->gNext()) last = c;
  if (last==0) ext = e;
  else last->sNext(e);
}

KbExp * KbNote::giveExp(int i) {
  KbExp * ne = 0;
  KbNoteExt * last = 0;
  for (KbNoteExt * c = ext; c!=0; c=c->gNext()) {
    if (c->isExp()) if  (((KbExp*)c)->gExpression()==i) ne = (KbExp*)c;
    last = c;
  }
  if (ne==0) {
    ne = new KbExp(this,i);
    if (last==0) ext = ne;
    else last->sNext(ne);
  }
  return ne;
}

KbBow * KbNote::giveBow(int len, int dir, int delta) {
  KbBow * nb = 0;
  KbNoteExt * last = 0;
  for (KbNoteExt * c = ext; c!=0; c=c->gNext()) {
    if (c->isBow()) nb = (KbBow*)c;
    last = c;
  }
  if (nb==0) {
    nb = new KbBow(this,len,dir,delta);
    if (last==0) ext = nb;
    else last->sNext(nb);
  }
  return nb;
}

KbLyrics * KbNote::lyrics() {
  KbLyrics * rv = 0;
  for (KbNoteExt * e = ext; e!=0; e = e->gNext())
    if (e->isLyrics()) rv =(KbLyrics*)e;
  return rv;
}

int KbNote::stemDir() {
  int rv = -1;
  for (KbNoteExt * e = ext; e!=0; e = e->gNext())
    if (e->isStem()) rv =((KbStem*)e)->gDir();
  return rv;
}

int KbNote::expression() {
  int rv = -1;
  for (KbNoteExt * e = ext; e!=0; e = e->gNext())
    if (e->isExp()) rv =((KbExp*)e)->gExpression();
  return rv;
}

int KbNote::bowLength() {
  int rv = -1;
  for (KbNoteExt * e = ext; e!=0; e = e->gNext())
    if (e->isBow()) rv =((KbBow*)e)->gLength();
  return rv;
}

KbExp * KbNote::gExp(KbNoteExt * start) {
  KbExp * rv = 0;
  if (start==0) start = ext;
  else start = start->gNext();
  for (KbNoteExt * e = start; (e!=0)&&(rv==0); e = e->gNext())
    if (e->isExp()) rv =(KbExp*)e;
  return rv;
}

KbBow * KbNote::gBow() {
  KbBow * rv = 0;
  for (KbNoteExt * e = ext; e!=0; e = e->gNext())
    if (e->isBow()) rv =(KbBow*)e;
  return rv;
}


void KbNote::flipStem() {
  KbStem * st = 0;
  for (KbNoteExt * e = ext; e!=0; e = e->gNext())
    if (e->isStem()) st =(KbStem*)e;
  if (st==0) {
    st = new KbStem(this,StemUp);
    appendExt(st);
  } else st->flip();
}

void KbNote::flipBow() {
  KbBow * bw = 0;
  for (KbNoteExt * e = ext; e!=0; e = e->gNext())
    if (e->isBow()) bw =(KbBow*)e;
  if (bw!=0) bw->flip();
}

void KbNote::removeExp() {
  KbNoteExt * old = 0;
  KbNoteExt * rm = 0;
  for (KbNoteExt * e = ext; e!=0; ) {
    if (e->isExp()) {
      if (old==0) ext = e->gNext();
      else old->sNext(e->gNext());
      rm = e;
      e = e->gNext();
      delete rm;
    } else e = e->gNext();
  }
}

void KbNote::removeBow() {
  KbNoteExt * old = 0;
  KbNoteExt * rm = 0;
  for (KbNoteExt * e = ext; e!=0; ) {
    if (e->isBow()) {
      if (old==0) ext = e->gNext();
      else old->sNext(e->gNext());
      rm = e;
      e = e->gNext();
      delete rm;
    } else e = e->gNext();
  }
}

bool KbNote::isNote() { return true; }

bool KbNote::isAuxElement() { return false; }

bool KbNote::isMidiEvent() { return false; }

bool KbNote::isMasterEvent() { return false; }

ostream & KbNote::print(ostream & s) {
  s << "<NOTE pitch=\"" << freq << "\" vel=\"" << vel << "\" len=\"" << len << "\" pos=\"" << pos << "\" enh=\"" << enh << "\" chan=\"" << chan << "\" >" << endl;
  for (KbNoteExt * e = gExt(); e != 0; e = e->gNext())
    s << *e;
  s << "</NOTE>" << endl;
  return s;
}

KbAtom * KbNote::copy() {
  KbNote * retv = new KbNote(freq,vel,len,pos,enh,chan);
  for (KbNoteExt * e = ext; e != 0; e = e->gNext())
    retv->appendExt(e->copy());
  return retv;
}

#endif
