#ifndef _KBSCORETRACK_C_
#define _KBSCORETRACK_C_

#include "kbScoreTrack.h"
class KbMain;

KbScoreTrack::KbScoreTrack( KbMain * kbMain )
  : KbTrack(kbMain,0), channel(0), program(0), output(0), volume(0), delay(0), transpose(0)
{
  output = kbMain->gNumberOfDevices()-1;
  ifTrack = kbMain->gFactory()->createScoreTrack(this);
}

int KbScoreTrack::gChannel() { return channel; }

void KbScoreTrack::sChannel(int n) { channel = n; }

int KbScoreTrack::gProgram() { return program; }

void KbScoreTrack::sProgram(int n) { program = n; }

int KbScoreTrack::gOutput() { return output; }

void KbScoreTrack::sOutput(int n) { output = n; main->closeDev(); }

int KbScoreTrack::gVolume() { return volume; }

void KbScoreTrack::sVolume(int n) { volume = n; }

int KbScoreTrack::gDelay() { return delay; }

void KbScoreTrack::sDelay(int n) { delay = n; }

int KbScoreTrack::gTranspose() { return transpose; }

void KbScoreTrack::sTranspose(int n) { transpose = n; }

bool KbScoreTrack::gToggle(int i) { return toggle[i]; }

void KbScoreTrack::sToggle(int i, bool n) { toggle[i] = n; }


#endif
