#ifndef _KBPARTEXTENSION_C_
#define _KBPARTEXTENSION_C_

#include "kbPartExtension.h"
#include "../kbTrack.h"
#include "../kbPart.h"
#include "../kbNote.h"
#include <string.h>



// *********************************************************************************
// *********************************************************************************
//
// Insert your headers below:
//

#include "stretch.h"


KbExtensionManager::KbExtensionManager()
: ext(0), cur(0)
{

  addExtension(new Stretch());

}


// Do not touch anything below this line!
//
// *********************************************************************************
// *********************************************************************************




void KbExtensionManager::addExtension(KbPartExtension * e) {
  KbPartExtension * pe=0;
  for (pe=ext; pe!=0 && pe->gNext()!=0; pe=pe->gNext()) {}
  if (pe==0) { ext=e; }
  else { pe->sNext(e); }
}

void KbExtensionManager::init() { cur = ext; }

KbPartExtension * KbExtensionManager::getExtension(int i) {
  if (i==-1) return cur;
  else {
    cur = ext;
    for (int j=0;j<i;j++) incr();
    return cur;
  }
}

void KbExtensionManager::incr() { if (cur!=0) cur = cur->gNext(); }




// -------------------------
//
// KbPartExtension
//


KbPartExtension::KbPartExtension(char * n)
  : next(0)
{
  myName = strdup(n);
}

char * KbPartExtension::name() {
  return myName;
}

void KbPartExtension::sNext(KbPartExtension * e) {
  next = e;
}

KbPartExtension * KbPartExtension::gNext() {
  return next;
}


void KbPartExtension::act(KbPart * p) {}

#endif
