#include <stdio.h>
#include "dattypes.h"
#include "midimapper.h"
#include "../version.h"

#define N_CHANNELS 16
#define N_CTL    256

class midiBusOut
{
protected:
friend class DeviceManager; 
public:
    midiBusOut(int d=0);
virtual   ~midiBusOut();


virtual    void openDev		(int sqfd);
virtual    void closeDev	(void);
virtual    void initDev		(void);
	int 	devType		(void) {return devicetype;};
	char *	devName		(void);
#ifdef HANDLETIMEINDEVICES
    int Rate		(void) { return rate; };
#endif

    void useMapper		( MidiMapper *map);

virtual    void noteOn		( uchar chn, uchar note, uchar vel );
virtual    void noteOff		( uchar chn, uchar note, uchar vel );
virtual    void keyPressure	( uchar chn, uchar note, uchar vel );
virtual    void chnPatchChange	( uchar chn, uchar patch );
virtual    void chnPressure	( uchar chn, uchar vel );
virtual    void chnPitchBender	( uchar chn, uchar lsb,  uchar msb );
virtual    void chnController	( uchar chn, uchar ctl , uchar v ); 

virtual    void sysex		( uchar *data,ulong size);
    void channelSilence		( uchar chn );
    void channelMute    	( uchar chn, int a );
virtual    void setVolumePercentage    ( int i ) {volumepercentage=i;};

    
    int OK (void) 
    {
        if (seqfd<0) return 0;
        return (ok>0);
    };

#ifdef HANDLETIMEINDEVICES
    void wait (double ticks);
    void tmrSetTempo(int v);
    void tmrStart(void);
    void tmrStop(void);
    void tmrContinue(void);
    void sync(int i=0);  // if i==1 syncronizes by cleaning the buffer
			// instead of sending it (in fact, this is what
			// you syncronizing really means :-)
#endif

    char *getMidiMapFilename(void);

};

#endif
