#ifndef _QTDRUM_C_
#define _QTDRUM_C_

#include "qtDrum.h"
#include "kbTrack.h"
#include "kbPart.h"
#include "kbNote.h"
#include "kbDrumTrack.h"

// Drums 35-81

const char * gmDrums[] = {"Acoustic Bass Drum", "Bass Drum 1", "Side Stick", "Acoustic Snare", "Hand Clap", "Electric Snare",
"Low Floor Tom", "Closed Hi-Hat", "High Floor Tom", "Pedal Hi-Hat", "Low Tom", "Open Hi-Hat", "Low-Mid Tom", "Hi-Mid Tom",
"Crash Cymbal 1", "High Tom", "Ride Cymbal 1", "Chinese Cymbal", "Ride Bell", "Tambourine", "Splash Cymbal", "Cowbell",
"Crash Cymbal 2", "Vibraslap", "Ride Cymbal 2", "Hi Bngo", "Low Bongo", "Mute Hi Conga", "Open Hi Conga", "Low Conga",
"Hi Timbale", "Low Timbale", "High Agogo", "Low Agogo", "Cabasa", "Maracas", "Short Whistle", "Long Whistle", "Short Guiro",
"Long Guiro", "Claves", "Hi Wood Block", "Low Wood Block", "Mute Cuica", "Open Cuica", "Mute Triangle", "Open Triangle"};

enum { ID_OPTIONS_VOLUMES };

// ******************************************************************
//
// Constructor
// ===========
//


QtDrum::QtDrum(KbPart * kbpart)
  : QtEditor("Drum",kbpart,"Jan Wrthner"), ybottom(height()-12-64)
{
  QtEditor::init();
  xoffset=112;
  yoffset=98;
  setBackgroundMode( PaletteMid );

  QBitmap maske;
  KIconLoader * loader = kapp->getIconLoader();
  img[0] = loader->loadIcon( "drum1.xbm" ); maske = img[0]; img[0].setMask( maske );
  img[1] = loader->loadIcon( "drum2.xbm" ); maske = img[1]; img[1].setMask( maske );
  img[2] = loader->loadIcon( "drum3.xbm" ); maske = img[2]; img[2].setMask( maske );
  img[3] = loader->loadIcon( "drum4.xbm" ); maske = img[3]; img[3].setMask( maske );
  img[4] = loader->loadIcon( "drum5.xbm" ); maske = img[4]; img[4].setMask( maske );
  img[5] = loader->loadIcon( "drum6.xbm" ); maske = img[5]; img[5].setMask( maske );
  img[6] = loader->loadIcon( "drum7.xbm" ); maske = img[6]; img[6].setMask( maske );
  img[7] = loader->loadIcon( "drum8.xbm" ); maske = img[7]; img[7].setMask( maske );

}


void QtDrum::resizeEvent( QResizeEvent * re ) {
  QtEditor::resizeEvent(re);
  ybottom = height()-12-64;
}


void QtDrum::addOptions() {
  // options->insertItem( klocale->translate("Show Volumes"), ID_OPTIONS_VOLUMES );
  // options->setCheckable(true);
}


int QtDrum::Pitch(int y) {
  return 81-int((y-yoffset-9)/9);
}

void QtDrum::paintEvent( QPaintEvent * pe ) {

  // wid = width()-xoffset-16;
  //  QPainter sreal; // smooth animation

  QPixmap pix( width(), height() );
  pix.fill( this, 10,10 );
  QPainter p;
  p.begin( &pix );

  int xxx = width();
  // p.drawLine(16,yoffset,xxx,yoffset);
  // p.drawLine(16,6+47*9+yoffset,xxx,6+47*9+yoffset);
  p.drawLine(16,yoffset,16,ybottom);
  // p.drawLine(xxx-16,2+yoffset,xxx-16,6+47*9+yoffset);
  p.drawLine(xoffset,2+yoffset,xoffset,ybottom);
  p.setFont(QFont("clean", 8));
  for (int i=0;i<=46;i++) if (13+i*9+yoffset < ybottom) p.drawText(20,13+i*9+yoffset,gmDrums[46-i]);

  /* DOIT: barlen = wid/barnum;
  for (int i=0;i<barnum;i++) {
    p.drawLine(xoffset+i*barlen,yoffset-10,xoffset+i*barlen,yoffset+47*9);
    help.setNum(i+xmOffset+leftBar+1);
    p.drawText(xoffset+i*barlen+2,yoffset,help);
    }*/

  p.setPen(colorGroup().foreground());
  /* beats = part->gTime2();
   DOIT: for (int i=1;i<barnum*beats;i++) {
    if (i%4!=0) p.drawLine(xoffset+i*barlen/beats,yoffset+1,xoffset+i*barlen/beats,yoffset+47*9);
    }* /

    p.setPen(colorGroup().foreground());
  //xLeft  = xmOffset*1536*part->gTime1()/part->gTime2();
  //xRight = xLeft+barnum*1536*part->gTime1()/beats;
  */






  // pixPerTick is defined in QtEditor
  unsigned long xx;
  int beat;
  int bar;
  int tick;
  KbPosition pos = 0;
  KbPosition add = KbPosition(1,2,0,master,met0,met1); // one beat!
  char * txt = new char[12];
  bool draw = true;
  bool showNum;
  while (draw) {
    xx = pos.gPosTicks();
    xx = xx*pixPerTick + xoffset;
    pos.gBBT(bar,beat,tick,master,met0,met1);
    
    if (beat==1) {
      sprintf(txt,"%d \0",bar+posLeft.gBar(master,met0,met1)-1);
      showNum = false;
      if (pixPerTick>0.015625) showNum = true;
      else if ((pixPerTick>0.0039) && ( (bar&3)==1 )) showNum = true;
      else if ((pixPerTick>0.0008) &&( (bar&15)==1 )) showNum = true;
      else if ((bar&127)==1) showNum = true;
      if (showNum) p.drawText(xx+1,yoffset-2,txt);
      if ((bar&7)==1) { p.setPen(SolidLine); p.drawLine(xx,yoffset,xx,ybottom); }
      else if (pixPerTick>0.0008) { p.setPen(DashDotLine); p.drawLine(xx,yoffset,xx,ybottom); }
    } else {
      if (pixPerTick>0.015625) { p.setPen(DotLine); p.drawLine(xx,yoffset,xx,ybottom); }
    }

    pos = pos + add;
    if (xx>xxx) draw=false;
  }
  p.setPen(SolidLine);
  p.drawLine(16,yoffset,xxx,yoffset); // draw horizontal borders
  p.drawLine(16,ybottom,xxx,ybottom);

  part = partList[selSystem];

  note = (KbNote*) part->gFirstNote();
  while (note!=0 && note->gPos()+part->gOffset() < posLeft) note = (KbNote*) note->gNextNote();
  while (note!=0 && note->gPos()+part->gOffset() < posRight) {

    pos = note->gPos();

    if (selNote==note || (selX1!=-1 && selX1 <= pos+part->gOffset() && pos+part->gOffset() <= selX2)) p.setPen(red); // selected Note red !


    KbPosition myLeftBar = KbPosition(xmOffset+1,1,0,master,met0,met1);
    xx = (pos-myLeftBar)*pixPerTick +  xoffset;
    yy = yoffset+7+9*(81-note->gFreq());

    p.drawPixmap(xx-6,yy,img[int(note->gVel()/18)]);

    p.drawRect(xx+1,ybottom+60,3,-note->gVel()/3);


    if (selNote==note || (selX1!=-1 && selX1 <= pos+part->gOffset() && pos+part->gOffset() <= selX2)) p.setPen(black);
    note = (KbNote*) note->gNextNote();
  }
  if (showY!=0) {
    p.setPen(red);
    p.drawLine(8,showY+yoffset,12,showY+yoffset);
  }



  // VOLUME RANGE:
  // -------------

  if (volGrabX1!=0)
    p.drawLine(volGrabX1,volGrabY1,volGrabX2,volGrabY2);



  // SELECTIONS:
  // -----------

  if (grabX1!=0 && abs(grabX1-grabX2)>5) { // draw grab rect
    p.setPen(gray);
    p.drawRect(grabX1,yoffset-12,grabX2-grabX1,6);
  }


  
  p.end();

  bitBlt( this, 0, 0, &pix );

}


void QtDrum::mousePressEvent ( QMouseEvent * m ) {
  QtEditor::mousePressEvent(m);

  int freq = Pitch(mouseDownY);
  pos = mouseDownPos.gPosTicks() - (mouseDownPos.gPosTicks()%snapValue) - part->gOffset();
  if (grabNote) repaint(FALSE);
  if (mouseDownX < xoffset) {
    if (showY!=0)
      if (speaker) main->hit(((KbDrumTrack*)part->gTrack())->gOutput(),((KbDrumTrack*)part->gTrack())->gChannel(),freq,velocValue);
  } else {
    if (mouseDownY > ybottom) {
      volGrabX1 = mouseX; volGrabY1 = mouseY;
      volGrabX2 = volGrabX1; volGrabY2 = volGrabY1;
      yGrab = mouseDownY;
    }
  }


}



void QtDrum::mouseMoveEvent ( QMouseEvent * m ) {
  QtEditor::mouseMoveEvent(m);

  if (mouseY > yoffset && mouseY < ybottom-4) {
    if (mouseX >= xoffset) {
      pos = mousePos.gPosTicks() - (mousePos.gPosTicks()%snapValue);
      int bar; int beat; int tick;
      pos.gBBT(bar,beat,tick,master,met0,met1);
      // buttonbar->setPos(bar,beat,tick);
      if (!grabNote) setCursor(QCursor(1));
      else repaint(FALSE);
    } else {
      setCursor(QCursor(1));
    }
    
    int freq = Pitch(mouseY);
  
    showY_old = showY;
    if (freq<=81 && freq>=35) { showY = (81-freq)*9+9; } else { showY = 0; }

    QPainter p;
    p.begin(this);
    p.setPen(QColor(colorGroup().mid()));
    p.drawLine(8,showY_old+yoffset,12,showY_old+yoffset);
    p.setPen(red);
    p.drawLine(8,showY+yoffset,12,showY+yoffset);
    p.end();
  }
  if (mouseY>ybottom) { setCursor(QCursor(2)); if (volGrabX1!=0) { volGrabX2 = mouseX; volGrabY2 = mouseY;} }

  // cout << mouseToPos(x) << endl;
  // repaint( FALSE );
}

void QtDrum::mouseReleaseEvent ( QMouseEvent * m ) {
  QtEditor::mouseReleaseEvent(m);

  int freq = Pitch(mouseRelY);

  if (mouseRelX >= xoffset) {
    pos = (mouseRelPos.gPosTicks()+4) - ((mouseRelPos.gPosTicks()+4)%snapValue) - part->gOffset();
    if (grabNote) {

      } else {
	if (createNote) {
	  int llen = ticksOfLen(lenValue);
	  if (m->button()==LeftButton) {
	    if (freq!=0) {
	      part->addNote(new KbNote(freq,velocValue,llen,pos,0));
	      grabX1=0; // if a note is created, no selection-frame should be displayed
	      if (speaker) main->hit(((KbDrumTrack*)part->gTrack())->gOutput(),((KbDrumTrack*)part->gTrack())->gChannel(),freq,velocValue);
	    }
	    
	  }
	} else { // SELECTION

	}

	if (mouseRelY > ybottom) { // VOLUME
	  int yAux = 60;
	  KbNote * n = 0;
	  KbNote * m = 0;
	  KbPosition p = KbPosition((volGrabX1-xoffset)*1.0/pixPerTick) + posLeft;
	  for (n = part->gFirstNote(); n!=0 && (n->gPos()+part->gOffset()<p); n = (KbNote*)n->gNextNote()) {}
	  if (n!=0) {
	    p = KbPosition((volGrabX2-xoffset)*1.0/pixPerTick) + posLeft;
	    for (m = n; m!=0 && (m->gPos()+part->gOffset()<p); m = (KbNote*)m->gNextNote()) {}
	    if (m!=0) { // range is now: [n,m]
	      //cout << *n << endl << *m << endl;
	      int ry1 = ybottom+yAux-yGrab;
	      int ry2 = ybottom+yAux-mouseRelY;
	      int deltax = (m->gPos().gPosTicks()-n->gPos().gPosTicks());
	      int deltay = (ry2-ry1)*3.0;
	      // cout << "yGrab: " << yGrab << " : " << ry1 << ", " << ry2 << endl;
	      double slope = deltay*1.0/deltax;
	      //cout << "slope: " << slope << endl;
	      for (KbNote * note = n; note!=m; note = note->gNextNote())
		note->sVel(3*ry1+int(slope*(note->gPos().gPosTicks()-n->gPos().gPosTicks())));
	    }
	  }
	  volGrabX1 = 0;
	  
	}
	
      }
      
  }
  volGrabX1 = 0;
  repaint(FALSE);

  /*
  x = m->x(); y = m->y()-yoffset;
  yy = int((y-9)/9);
  int pos = timeOfMouse(x+2); // +2 to have some space
  int freq = 81-yy;

  if (createNote==TRUE) {
    if (m->button()==LeftButton) {
      if (x>xoffset) {
	//soundHit(part->gTrack()->gOutput(),part->gTrack()->gChannel(),freq,velocValue);
	if (speaker) main->hit(((KbDrumTrack*)part->gTrack())->gOutput(),((KbDrumTrack*)part->gTrack())->gChannel(),freq,velocValue);
	part->addNote(new KbNote(freq,velocValue,ticksOfLen(lenValue),pos-part->gOffset(),0));
	repaint( FALSE );
      }
    }
    if (m->button()==MidButton) {
      KbNote * n;
      for (n=(KbNote*)part->gFirstAtom(); n!=0 && (n->gPos()+deltaOff[selSystem]+leftPos<pos || n->gFreq()!=freq); n=(KbNote*)n->gNext()) {}
      selNote = n;
      if (selNote!=0) showNoteInfo();
      else showNoteInfoOff();
      repaint( FALSE );
      //if (n!=0) soundHit(part->gTrack()->gOutput(),part->gTrack()->gChannel(),n->gFreq(),velocValue); // plays the note
      if (speaker) if (n!=0) main->hit(((KbDrumTrack*)part->gTrack())->gOutput(),((KbDrumTrack*)part->gTrack())->gChannel(),n->gFreq(),velocValue);
    }
    if (m->button()==RightButton) {
      if (x>xoffset) {
	KbNote * n;
	for (n=(KbNote*)part->gFirstAtom(); n!=0 && (n->gPos()+deltaOff[selSystem]+leftPos<pos || n->gFreq()!=freq); n=(KbNote*)n->gNext()) {}
	if (n!=0) {
	  part->deleteNote(n);
	  selNote = 0;
	  showNoteInfoOff();
	  repaint( FALSE );
	}
      }
    }
  }
  */  
}

void QtDrum::optionsMenu(int n) {
  QtEditor::optionsMenu(n);
  /*
  switch(n) {
  case ID_OPTIONS_VOLUMES:
  if (showVOL==true) { showVOL=false; yAux = 0; volGrabX1 = 0; }
    else { showVOL = true; showLYR = false; yAux = 64; volGrabX1 = 0; }
    options->setItemChecked(ID_OPTIONS_LYRICS,showLYR);
    options->setItemChecked(ID_OPTIONS_VOLUMES,showVOL);
    setFixedHeight(parts*(100+yAux)+YTOP);
    break;
  }
  */
}


#endif
