#ifndef _QTDRUMTRACK_C_
#define _QTDRUMTRACK_C_

#include "kbTrack.h"
#include "kbDrumTrack.h"
#include "qtDrumTrack.h"
#include <iostream.h>

extern const char * gmNames[];



QtDrumTrack::QtDrumTrack(KbTrack * kbtrack)
  : QtTrack(kbtrack)
{
  /*
  int n = track->trackNum()+1; // the underlying kbTrack of this qtTrack is not registered yet, that's why +1 !
  int hh = height();
  setGeometry(0,n*(1+hh),width(),hh);
  */
  
  KIconLoader * loader = kapp->getIconLoader();
  
  QPixmap * pmMute = new QPixmap(loader->loadIcon( "mute.xpm" ));

  int hh = height();

  mute = new TogBut( 0, track, pmMute, 0, this, "mute" );
  mute->setFrameStyle( QFrame::Panel | QFrame::Raised );
  mute->setGeometry(0,0,24,hh+1);

  instbox = new QComboBox(FALSE,this,"instrument");
  instbox->insertStrList( gmNames );
  instbox->setCurrentItem(((KbDrumTrack*)track)->gProgram());
  instbox->setGeometry(168,0,160,hh+1);
  connect(instbox,SIGNAL(highlighted(int)),SLOT(updateInst(int)));

  output = new QComboBox(FALSE,this,"output");
  output->insertStrList( ((QtMain*)kbtrack->gMain()->gInterface())->gDevList() );
  output->setCurrentItem(((KbDrumTrack*)track)->gOutput());
  output->setGeometry(328,0,96,hh+1);
  connect(output,SIGNAL(highlighted(int)),SLOT(updateOut(int)));

  chanbox = new QSpinBox(0,15,1,this);
  chanbox->setFrameStyle( QFrame::Panel | QFrame::Raised );
  chanbox->setGeometry(424,0,44,hh+1);
  chanbox->setValue(((KbDrumTrack*)track)->gChannel());
  chanbox->setBackgroundMode( PaletteMid );
  connect(chanbox,SIGNAL(valueChanged(int)),SLOT(updateChan(int)));

  vol = new QSpinBox(-99,99,1,this);
  vol->setFrameStyle( QFrame::Panel | QFrame::Raised );
  vol->setGeometry(468,0,54,hh+1);
  vol->setValue(((KbDrumTrack*)track)->gVolume());
  vol->setBackgroundMode( PaletteMid );
  connect(vol,SIGNAL(valueChanged(int)),SLOT(updateVol(int)));

  tra = new QSpinBox(-99,99,1,this);
  tra->setFrameStyle( QFrame::Panel | QFrame::Raised );
  tra->setGeometry(522,0,54,hh+1);
  tra->setValue(((KbDrumTrack*)track)->gTranspose());
  tra->setBackgroundMode( PaletteMid );
  connect(tra,SIGNAL(valueChanged(int)),SLOT(updateTra(int)));

  del = new QSpinBox(-99,99,1,this);
  del->setFrameStyle( QFrame::Panel | QFrame::Raised );
  del->setGeometry(576,0,54,hh+1);
  del->setValue(((KbDrumTrack*)track)->gDelay());
  del->setBackgroundMode( PaletteMid );
  connect(del,SIGNAL(valueChanged(int)),SLOT(updateDel(int)));

  type->chooseDrum();
}

/*QtDrumTrack::~QtDrumTrack() {

  }*/


void QtDrumTrack::erase() {
  delete this;
}


void QtDrumTrack::update() {
  QtTrack::update();
  mute->update(); track->gMain()->muteTrack(track->trackNum());
  instbox->setCurrentItem(((KbDrumTrack*)track)->gProgram());
  output->setCurrentItem(((KbDrumTrack*)track)->gOutput());
  chanbox->setValue(((KbDrumTrack*)track)->gChannel());
  vol->setValue(((KbDrumTrack*)track)->gVolume());
  tra->setValue(((KbDrumTrack*)track)->gTranspose());
  del->setValue(((KbDrumTrack*)track)->gDelay());
  /*  
  if (track->gToggle(1)==FALSE && track->gToggle(2)==FALSE) { // type & lock are false!
    chanbox->setEnabled(TRUE);
    instbox->setEnabled(TRUE);
    output->setEnabled(TRUE);
  } else {
    chanbox->setEnabled(FALSE);
    instbox->setEnabled(FALSE);
    output->setEnabled(FALSE);
  }
  if (track->gToggle(2)==FALSE) { // lock is false
    vol->setEnabled(TRUE);
    del->setEnabled(TRUE);
  } else {
    vol->setEnabled(FALSE);
    del->setEnabled(FALSE);
  }
  */
  show();
}

int QtDrumTrack::gProgram() {
  // return instbox->getCurrentItem();
}

void QtDrumTrack::sProgram(int n) {
  ((KbDrumTrack*)track)->sProgram(n);
  instbox->setCurrentItem(n);
}

void QtDrumTrack::updateChan(int n) {
  ((KbDrumTrack*)track)->sChannel(n);
}

void QtDrumTrack::updateInst(int n) {
  ((KbDrumTrack*)track)->sProgram(n);
  track->gMain()->updateInst(track->trackNum(),n);
}

void QtDrumTrack::updateOut(int n) {
  ((KbDrumTrack*)track)->sOutput(n);
}

void QtDrumTrack::updateVol(int n) {
  ((KbDrumTrack*)track)->sVolume(n);
}

void QtDrumTrack::updateTra(int n) {
  ((KbDrumTrack*)track)->sTranspose(n);
}

void QtDrumTrack::updateDel(int n) {
  ((KbDrumTrack*)track)->sDelay(n);
}









#endif
