#ifndef _QTDRUMTRACK_H_
#define _QTDRUMTRACK_H_

#include "qtTrack.h"


/**
 * This is the qt implementation of a drumTrack
 * @author Jan Wuerthner
 * @versoin 0.97
 */
class QtDrumTrack : public QtTrack
{
  Q_OBJECT

 private:
  TogBut * mute;
  QSpinBox * chanbox;
  QComboBox * instbox;
  QComboBox * output;
  QSpinBox * vol;
  QSpinBox * tra;
  QSpinBox * del;
 public:

  /// Constructor
  QtDrumTrack(KbTrack*);

  /// Destructor
  //~QtDrumTrack();
  
  virtual void erase();

  /// updates the presentation on the screen
  virtual void update();

  /// returns current instrument
  int gProgram();

  /// sets an instrument
  void sProgram(int n);

 public slots:
  void updateChan(int);
  void updateInst(int);
  void updateOut(int);
  void updateVol(int);
  void updateTra(int);
  void updateDel(int);
};






#endif
