#ifndef _QTEDITOR_C_
#define _QTEDITOR_C_

#include "qtPart.h"
#include "qtEditor.h"
#include "qtSelFrame.h"
#include "kbNote.h"
#include "kbPart.h"
#include "kbTrack.h"
#include "kbMain.h"
#include "qtTrans.h"

#include <qmessagebox.h> 
#include <qaccel.h>
#include <qfont.h>
#include <iostream.h>
#include <math.h>

enum { ID_CLOSE, ID_SET, ID_TRANS, ID_Q, ID_LQ, ID_FL, ID_EDIT_CUT, ID_EDIT_COPY, ID_EDIT_PASTE, ID_EDIT_LEFT, ID_EDIT_RIGHT,
       ID_EDIT_UNMARK, ID_EDIT_TRANS, ID_EDIT_Q, ID_EDIT_LQ, ID_EDIT_FL, ID_EDIT_CLEAR, ID_BACK, ID_REWIND, ID_FORWARD,
       ID_PLAY, ID_STOP, ID_PLUS, ID_MINUS, ID_INSPTR, ID_SPEAKER, ID_COLOR };

enum { ID_OPTIONS_AUTHOR };

QtEditor::QtEditor(char * name, KbPart * kbpart, char * a, bool all)
  : KTopLevelWidget(name), part(kbpart), main(kbpart->gTrack()->gMain()), author(a), pixPerTick(1.0/36), xmOffset(0),
    velocValue(86), snapValue(192), lenValue(4), triValue(false), dotValue(false), xoffset(0), selNote(0), grabNote(0),
    selX1(-1), selX2(0), grabX1(0), grabX2(0), grabY1(0), grabY2(0), mouseDownX(0), mouseDownY(0),
    shftFlag(FALSE), ctrlFlag(FALSE), noteSelection(0), selSystem(0), insPtr(0), allParts(all), speaker(true), colorchan(false), volGrabX1(0)
{
  for (int i=0;i<16;i++)
    chancolor[i] = QColor((i*50)%360,150,180,QColor::Hsv);

  master = main->Master();
  met0 = main->gMeter(0);
  met1 = main->gMeter(1);

  setCaption(name);
  setMouseTracking(TRUE);
  setMinimumWidth(720);

  if (all==false) { // one part is edited
    parts = 1;
    partList[0] = part;
    xmOffset = part->gOffset().gBar(master,met0,met1)-1;
  } else { // all parts are edited
    parts = 0;
    for (KbTrack * tr=main->gTrack(); tr!=0; tr=tr->gNext()) {
      if ((tr->gPart()!=0) && (tr->gToggle(0)==FALSE) && (tr->isA()==0)) {
	partList[parts] = tr->gPart();
	// DOIT: partList[parts]->openScore = this;
	parts++;
      }
    }
    if (parts<2)  {
      part = partList[0];
      xmOffset = part->gOffset().gBar(master,met0,met1)-1;
    } else {
      part = partList[0];
      KbPosition leftMost = part->gOffset();
      for (int i=1;i<parts;i++) if (partList[i]->gOffset() < leftMost) leftMost = partList[i]->gOffset();
      xmOffset = part->gOffset().gBar(master,met0,met1)-1;
    }
    
    
  }

  posLeft = KbPosition(1+xmOffset,1,0,master,met0,met1);
  posRight = posLeft + KbPosition((width()-xoffset)*1.0/pixPerTick);

}


QtEditor::~QtEditor() {
  main->closeDev();
}

void QtEditor::resizeEvent( QResizeEvent * re ) {
  KTopLevelWidget::resizeEvent(re);
  posRight = posLeft + KbPosition((width()-xoffset)*1.0/pixPerTick);

}

void QtEditor::init() {
  
  KIconLoader * loader = kapp->getIconLoader();
  
  QPopupMenu * file = new QPopupMenu;
  file->insertItem( klocale->translate("Close"), ID_CLOSE);
  file->setAccel(ALT+Key_W,ID_CLOSE);

  QPopupMenu * system = new QPopupMenu;
  system->insertItem( klocale->translate("Settings"), ID_SET);
  system->insertItem( klocale->translate("Transpose"), ID_TRANS);
  system->insertSeparator();
  system->insertItem( klocale->translate("Quantize"), ID_Q);
  system->insertItem( klocale->translate("Length Quantize"), ID_LQ);
  system->insertItem( klocale->translate("Fixed Length"), ID_FL);

  selection = new QPopupMenu;
  selection->insertItem( klocale->translate("Cut"), ID_EDIT_CUT);
  selection->insertItem( klocale->translate("Copy"), ID_EDIT_COPY);
  selection->insertItem( klocale->translate("Paste"), ID_EDIT_PASTE);
  selection->insertSeparator();
  selection->insertItem( klocale->translate("Mark Left"), ID_EDIT_LEFT);
  selection->insertItem( klocale->translate("Mark Right"), ID_EDIT_RIGHT);
  selection->insertItem( klocale->translate("Unmark"), ID_EDIT_UNMARK);
  selection->insertItem( klocale->translate("Transpose"), ID_EDIT_TRANS);
  selection->insertSeparator();
  selection->insertItem( klocale->translate("Quantize"), ID_EDIT_Q);
  selection->insertItem( klocale->translate("Length Quantize"), ID_EDIT_LQ);
  selection->insertItem( klocale->translate("Fixed Length"), ID_EDIT_FL);
  selection->insertSeparator();
  selection->insertItem( klocale->translate("Erase"), ID_EDIT_CLEAR);

  selection->setAccel(ALT+Key_X,ID_EDIT_CUT);
  selection->setAccel(ALT+Key_C,ID_EDIT_COPY);
  selection->setAccel(ALT+Key_V,ID_EDIT_PASTE);
  selection->setAccel(Key_Escape,ID_EDIT_UNMARK);
  selection->setAccel(ALT+Key_Exclam,ID_EDIT_TRANS);
  selection->setAccel(ALT+Key_Q,ID_EDIT_Q);
  selection->setAccel(ALT+Key_L,ID_EDIT_LEFT);
  selection->setAccel(ALT+Key_R,ID_EDIT_RIGHT);
  selection->setAccel(ALT+Key_Backspace,ID_EDIT_CLEAR);

  selection->setItemEnabled(ID_EDIT_CUT,FALSE);
  selection->setItemEnabled(ID_EDIT_COPY,FALSE);
  selection->setItemEnabled(ID_EDIT_PASTE,FALSE);
  selection->setItemEnabled(ID_EDIT_UNMARK,FALSE);
  selection->setItemEnabled(ID_EDIT_TRANS,FALSE);
  selection->setItemEnabled(ID_EDIT_Q,FALSE);
  selection->setItemEnabled(ID_EDIT_LQ,FALSE);
  selection->setItemEnabled(ID_EDIT_FL,FALSE);

  /*  QPopupMenu * tools = new QPopupMenu;
      tools->insertItem( loader->loadIcon( "n8.xpm" ), ID_TOOLS_NOTE);
      tools->insertItem( loader->loadIcon( "n8.xpm" ), ID_TOOLS_NOTE);
      tools->insertItem( loader->loadIcon( "eraser.xpm" ), ID_TOOLS_NOTE);
  */

  snap = new QPopupMenu;
  snap->insertItem( loader->loadIcon( "n1.xpm" ), 1536 );
  snap->insertItem( loader->loadIcon( "n2.xpm" ), 768 );
  snap->insertItem( loader->loadIcon( "n4.xpm" ), 384 );
  snap->insertItem( loader->loadIcon( "n8.xpm" ), 192 );
  snap->insertItem( loader->loadIcon( "n16.xpm" ), 96 );
  snap->insertItem( loader->loadIcon( "n32.xpm" ), 48 );
  snap->insertItem( loader->loadIcon( "n64.xpm" ), 24 );
  snap->insertItem( klocale->translate("off   "), 1 );
  snap->setCheckable(TRUE);
  snap->setItemChecked(192,TRUE);

  veloc = new QPopupMenu;
  veloc->insertItem( klocale->translate("Off "), 0);
  veloc->insertItem( klocale->translate("ppp "), 14);
  veloc->insertItem( klocale->translate("pp "), 28);
  veloc->insertItem( klocale->translate("p "), 42);
  veloc->insertItem( klocale->translate("mp "), 56);
  veloc->insertItem( klocale->translate("mf "), 70);
  veloc->insertItem( klocale->translate("f "), 86);
  veloc->insertItem( klocale->translate("ff "), 102);
  veloc->insertItem( klocale->translate("fff "), 127);
  veloc->setCheckable(true);
  veloc->setItemChecked(86,TRUE);

  options = new QPopupMenu;
  addOptions();
  options->insertSeparator();
  options->insertItem( klocale->translate("author"), ID_OPTIONS_AUTHOR );

  connect(file,SIGNAL(activated(int)),SLOT(fileMenu(int)));
  connect(system,SIGNAL(activated(int)),SLOT(systemMenu(int)));
  connect(selection,SIGNAL(activated(int)),SLOT(selectionMenu(int)));
  connect(snap,SIGNAL(activated(int)),SLOT(snapMenu(int)));
  connect(veloc,SIGNAL(activated(int)),SLOT(velocMenu(int)));
  connect(options,SIGNAL(activated(int)),SLOT(optionsMenu(int)));

  menu = new KMenuBar( this );
  CHECK_PTR( menu );
  menu->insertItem(klocale->translate("File"),file);
  menu->insertItem(klocale->translate("System"),system);
  menu->insertItem(klocale->translate("Selection"),selection);
  menu->insertItem(klocale->translate("Grid"),snap);
  menu->insertItem(klocale->translate("Dynamics"),veloc);
  menu->insertItem(klocale->translate("Options"),options);
  menu->show();

  setMenu( menu );
  menu->setCursor(0);

  panel = new KToolBar( this );

  panel->insertButton( loader->loadIcon( "start.xpm"), ID_BACK, TRUE, klocale->translate("Back to Start"));
  panel->insertButton( loader->loadIcon( "back.xpm"), ID_REWIND, TRUE, klocale->translate("Rewind"));
  panel->insertButton( loader->loadIcon( "forward.xpm"), ID_FORWARD, TRUE, klocale->translate("Forward"));
  panel->insertSeparator();
  panel->insertButton( loader->loadIcon( "editcut.xpm"), ID_EDIT_CUT, TRUE, klocale->translate("Cut"));
  panel->insertButton( loader->loadIcon( "editcopy.xpm"), ID_EDIT_COPY, TRUE, klocale->translate("Copy"));
  panel->insertButton( loader->loadIcon( "editpaste.xpm"), ID_EDIT_PASTE, TRUE, klocale->translate("Paste"));
  panel->insertButton( loader->loadIcon( "edittrans.xpm"), ID_EDIT_TRANS, TRUE, klocale->translate("Transpose"));
  panel->insertSeparator();
  // panel->insertButton( loader->loadIcon( "play.xpm"), ID_PLAY, TRUE, klocale->translate("Play"));
  // panel->insertButton( loader->loadIcon( "stop.xpm"), ID_STOP, TRUE, klocale->translate("Stop"));
  panel->insertButton( loader->loadIcon( "hPlus.xpm"), ID_PLUS, TRUE, klocale->translate("Enlarge View"));
  panel->insertButton( loader->loadIcon( "hMinus.xpm"), ID_MINUS, TRUE, klocale->translate("Shrink View"));
  panel->insertSeparator();
  panel->insertButton( loader->loadIcon( "exit.xpm"), ID_CLOSE, TRUE, klocale->translate("close"));
  panel->insertSeparator();

  panel->insertWidget(-2,38,new QLabel("range:",panel));
  selFrame = new QtSelFrame(panel,"-",main);
  selFrame->show();
  panel->insertWidget(-2,72,selFrame);

  connect(panel,SIGNAL(clicked(int)), SLOT(panelMenu(int)));
  addToolBar( panel );
  panel->show();
  panel->setCursor(0);

  panel->setItemEnabled(ID_EDIT_CUT,FALSE);
  panel->setItemEnabled(ID_EDIT_COPY,FALSE);
  panel->setItemEnabled(ID_EDIT_PASTE,FALSE);
  panel->setItemEnabled(ID_EDIT_TRANS,FALSE);


  panel->insertWidget(-2,32,new QLabel("insert:",panel));
  insLine = new QLineEdit( panel,"-" );
  insLine->setText("1 .1 .0");
  insLine->show();
  insLine->setEnabled(TRUE);
  panel->insertWidget(ID_INSPTR,78,insLine);
  connect(insLine,SIGNAL(returnPressed()),SLOT(setIns()));

  panel->insertButton( loader->loadIcon( "speaker.xpm"), ID_SPEAKER, TRUE, klocale->translate("speaker on/off"));
  panel->setToggle(ID_SPEAKER, TRUE);
  panel->setButton(ID_SPEAKER, TRUE);

  panel->insertButton( loader->loadIcon( "colorchan.xpm"), ID_COLOR, TRUE, klocale->translate("colorize channels on/off"));
  panel->setToggle(ID_COLOR, TRUE);
  panel->setButton(ID_COLOR, colorchan);

  notebar = new Notebar(this);
  addToolBar(notebar);
  notebar->show();

  showNoteInfoOff();


  // menu for the right mousebutton
  
  rbmenu = new QPopupMenu;
  // rbmenu->setFont(QFont("clean",10));
  // rbmenu->setMouseTracking( TRUE );
  addMenuEntries();
  rbmenu->insertSeparator();
  rbmenu->connectItem( rbmenu->insertItem(klocale->translate("glue to next note")), this, SLOT(glueNote()) );
  rbmenu->insertSeparator();
  rbmenu->connectItem( rbmenu->insertItem(klocale->translate("delete note")), this, SLOT(deleteNote()) );

}

void QtEditor::deleteNote() {
  part = partList[selSystem];
  if (selNote) part->deleteNote(selNote);
  selNote = 0;
}

void QtEditor::glueNote() {
  part = partList[selSystem];
  if (selNote&&selNote->gNextNote()) {
    ((KbNote*)selNote)->sLen(((KbNote*)selNote)->gLen()+selNote->gNextNote()->gLen());
    part->deleteNote(selNote->gNextNote());
  }
  selNote = 0;
}

void QtEditor::addMenuEntries() {}

void QtEditor::getPartInfo() {
  if (parts>1) part = partList[selSystem];
}


int QtEditor::gLenValue() {
  return lenValue;
}

void QtEditor::sLenValue(int l) {
  lenValue = l;
}

bool QtEditor::gDotValue() {
  return dotValue;
}

void QtEditor::sDotValue(bool d) {
  dotValue = d;
}

bool QtEditor::gTriValue() {
  return triValue;
}

void QtEditor::sTriValue(bool t) {
  triValue = t;
}


void QtEditor::addOptions() { }

void QtEditor::fileMenu(int n) {
  switch(n) {
  case ID_CLOSE:
    for (int i=0;i<parts;i++) {
      ((QtPart *) partList[i]->gInterface())->closeEditor();
    }
    delete this;
  }
}

void QtEditor::systemMenu(int n) {
  part = partList[selSystem];
  switch(n) {
  case ID_SET:
    settings();
    break;
  case ID_TRANS:
    transposeSystem();
    break;
  case ID_Q:
    part->quantize(snapValue);
    break;
  case ID_LQ:
    part->quantizeLength(snapValue);
    break;
  case ID_FL:
    part->fixedLength(snapValue);
    break;
  }
  repaint(FALSE);
}

void QtEditor::selectionMenu(int n) {
  part = partList[selSystem];
  switch(n) {
  case ID_EDIT_CUT:
    cutSelection();
    break;
  case ID_EDIT_COPY:
    copySelection();
    break;
  case ID_EDIT_PASTE:
    pasteSelection();
    break;
  case ID_EDIT_LEFT:
    enableSelItems(TRUE);
    selX1 = insPtr;
    selFrame->setTop(selX1.gTicks(master,met0,met1),selX1.gBeat(master,met0,met1),selX1.gBar(master,met0,met1));
    if (selX2<=selX1) { selX2 = selX1; selFrame->setBottom(selX1.gTicks(master,met0,met1),selX1.gBeat(master,met0,met1),selX1.gBar(master,met0,met1)); }
    break;
  case ID_EDIT_RIGHT:
    enableSelItems(TRUE);
    selX2 = insPtr;
    if (selX1<0 || selX1>selX2) { selX1 = 0; selFrame->setTop(0,1,1); }
    selFrame->setBottom(selX2.gTicks(master,met0,met1),selX2.gBeat(master,met0,met1),selX2.gBar(master,met0,met1));
    break;
  case ID_EDIT_UNMARK:
    unmarkSelection();
    break;
  case ID_EDIT_TRANS:
    transposeSelection();
    break;
  case ID_EDIT_Q:
    part->quantize(snapValue,selX1,selX2);
    break;
  case ID_EDIT_LQ:
    part->quantizeLength(snapValue,selX1,selX2);
    break;
  case ID_EDIT_FL:
    part->fixedLength(snapValue,selX1,selX2);
    break;
  case ID_EDIT_CLEAR:
    if (selNote==0) {
      clearSelection();
    } else {
      part->deleteNote(selNote);
      selNote=0;
    }
    break;
  }
  repaint(FALSE);
}

void QtEditor::optionsMenu(int n) {
  switch(n) {
  case ID_OPTIONS_AUTHOR:
    QMessageBox::information( this, "Brahms Editor", "This editor is written by", author );
    break;
  }
}

void QtEditor::snapMenu(int n) {
  snap->setItemChecked(snapValue,FALSE);
  snapValue = n;
  snap->setItemChecked(n,TRUE);
}

void QtEditor::velocMenu(int n) {
  veloc->setItemChecked(velocValue,FALSE);
  velocValue = n;
  veloc->setItemChecked(n,TRUE);
}

void QtEditor::panelMenu(int n) {
  part = partList[selSystem];
  switch(n) {
  case ID_BACK:
    xmOffset = 0;
    posLeft = KbPosition(1+xmOffset,1,0,master,met0,met1);
    posRight = posLeft + KbPosition((width()-xoffset)*1.0/pixPerTick);
    break;
  case ID_REWIND:
    if (xmOffset>0) xmOffset--;
    posLeft = KbPosition(1+xmOffset,1,0,master,met0,met1);
    posRight = posLeft + KbPosition((width()-xoffset)*1.0/pixPerTick);
    break;
  case ID_FORWARD:
    xmOffset++;
    posLeft = KbPosition(1+xmOffset,1,0,master,met0,met1);
    posRight = posLeft + KbPosition((width()-xoffset)*1.0/pixPerTick);
    break;

  case ID_EDIT_CUT:
    cutSelection();
    break;
  case ID_EDIT_COPY:
    copySelection();
    break;
  case ID_EDIT_PASTE:
    pasteSelection();
    break;
  case ID_EDIT_TRANS:
    transposeSelection();
    break;

  case ID_PLAY:
    if (part!=0) {
      main->play(part->gTrack()->trackNum(),posLeft.gPosTicks(),posRight.gPosTicks());
    }
    break;
  case ID_STOP:
    main->stopAll();
    break;
  case ID_PLUS:
    pixPerTick *= 1.2;
    posRight = posLeft + KbPosition((width()-xoffset)*1.0/pixPerTick);
    break;
  case ID_MINUS:
    pixPerTick /= 1.2;
    posRight = posLeft + KbPosition((width()-xoffset)*1.0/pixPerTick);
    break;
  case ID_CLOSE:
    for (int i=0;i<parts;i++)
      ((QtPart *) partList[i]->gInterface())->closeEditor();
    delete this;
    break;
  case ID_SPEAKER:
    if (speaker) speaker = false;
    else speaker = true;
    break;
  case ID_COLOR:
    if (colorchan) colorchan = false;
    else colorchan = true;
    break;
  }
  if (n!=ID_CLOSE) repaint(FALSE);
}


void QtEditor::settings() { }


KbAtom * QtEditor::selectedNote() {
  return selNote;
}

void QtEditor::selectNote(KbAtom * n) {
  selNote = n;
}

KbPart * QtEditor::gPart() {
  return part;
}


int QtEditor::ticksOfLen( int cl ) {

  int tt = 3*int(pow(2,10-cl));
  if (dotValue==TRUE) tt = int( tt * 1.5 );
  if (triValue==TRUE) tt = int( tt * (2.000001/3.0) );
  return tt;
}

void QtEditor::showNoteInfo() {
  part = partList[selSystem];
  if (selNote) {
    KbPosition pos = selNote->gPos()+part->gOffset();
    
    int bar; int beat; int tick;
    pos.gBBT(bar,beat,tick,master,met0,met1);
    
    KbNote * selN = (KbNote*) selNote;
    notebar->setStart(bar,beat,tick);                   // start
    notebar->setLength(selN->gLen());              // length
    notebar->setPitch(selN->gFreq());               // pitch
    notebar->setVelocity(selN->gVel());            // velocity
    notebar->setEnh(selN->gEnh()+2);              // Enharmonic shift
    notebar->setChan(selN->gChan());             // Channel
    selection->setItemEnabled(ID_EDIT_UNMARK,TRUE);
  }
}

void QtEditor::showNoteInfoOff() {
  notebar->clear();
  if (selX1==-1) selection->setItemEnabled(ID_EDIT_UNMARK,FALSE);
}


void QtEditor::unmarkSelection() {
  enableSelItems(FALSE);
  selNote = 0;
  selX1 = -1;
  selX2 = 0;
  showNoteInfoOff();
}

void QtEditor::transposeSelection() {
  if (part->gFirstNote()) {
    QtTranspose * t = new QtTranspose(selX1,selX2,part,this);
    t->show();
  }
}

void QtEditor::transposeSystem() {
  if (part->gFirstNote()) {
    QtTranspose * t = new QtTranspose(0,0,part,this);
    t->show();
  }
}

void QtEditor::deleteBuffer() {
  KbAtom * n; KbAtom * n1;
  if (noteSelection != 0) {
    n = noteSelection->gNext();
    n1 = noteSelection;
    while (n!=0) { delete n1; n1 = n; n = n->gNext(); }
  }
  noteSelection = 0;
}

void QtEditor::clearSelection() {
  if (selX1!=-1) {
    part = partList[selSystem];
    
    KbNote * n; KbNote * n1; KbNote * n2; KbNote * nDel; KbAtom * nPre;
    n = part->gFirstNote(nPre); // nPre is the event right before the selection (=0 if selection starts left most)
    while (n!=0 && n->gPos() < selX1-part->gOffset()) { nPre = n; n = n->gNextNote(nPre); }
    unsigned long offx = n->gPos().gPosTicks();
    
    while (n!=0 && n->gPos() <= selX2-part->gOffset()) {
      nDel = n;
      n = n->gNextNote();
      delete nDel;
    }
    if (nPre==0) part->sFirst(n);
    else nPre->sNext(n);
    if (n==0) { part->sLast(nPre); part->reset(); }
  }
}

void QtEditor::cutSelection() {
  if (selX1!=-1) {
    part = partList[selSystem];
    deleteBuffer();

    KbNote * n; KbNote * n1; KbNote * n2; KbNote * nDel; KbAtom * nPre;
    n = part->gFirstNote(nPre); // nPre is the event right before the selection (=0 if selection starts left most)
    while (n!=0 && n->gPos() < selX1-part->gOffset()) { nPre = n; n = n->gNextNote(nPre); }
    unsigned long offx = n->gPos().gPosTicks();
    
    while (n!=0 && n->gPos() <= selX2-part->gOffset()) {
      n2 = n1;
      n1 = (KbNote*) n->copy(); n1->sPos(n1->gPos()-offx);
      if (noteSelection==0) noteSelection = n1;
      else n2->sNext(n1);
      nDel = n;
      n = n->gNextNote();
      delete nDel;
    }
    if (nPre==0) part->sFirst(n);
    else nPre->sNext(n);
    if (n==0) { part->sLast(nPre); part->reset(); }
  }

  if (noteSelection!=0) {
    panel->setItemEnabled(ID_EDIT_PASTE,TRUE);
    panel->setItemEnabled(ID_EDIT_CUT,FALSE);
    panel->setItemEnabled(ID_EDIT_COPY,FALSE);
    panel->setItemEnabled(ID_EDIT_TRANS,FALSE);
    selection->setItemEnabled(ID_EDIT_PASTE,TRUE);
    selection->setItemEnabled(ID_EDIT_CUT,FALSE);
    selection->setItemEnabled(ID_EDIT_COPY,FALSE);
    selection->setItemEnabled(ID_EDIT_TRANS,FALSE);
    selection->setItemEnabled(ID_EDIT_Q,FALSE);
    selection->setItemEnabled(ID_EDIT_LQ,FALSE);
    selection->setItemEnabled(ID_EDIT_FL,FALSE);
  } else {
    panel->setItemEnabled(ID_EDIT_PASTE,FALSE);
    selection->setItemEnabled(ID_EDIT_PASTE,FALSE);
  }
}


void QtEditor::copySelection() {
  //
  // nicht noteSelection, sondern mainWindow->noteSelection, oder so...
  //
  if (selX1!=-1) {
    part = partList[selSystem];
    deleteBuffer();

    KbNote * n; KbNote * n1; KbNote * n2; KbAtom * nPre;
    n = part->gFirstNote(nPre); // nPre is the event right before the selection (=0 if selection starts left most)
    while (n!=0 && n->gPos() < selX1-part->gOffset()) { nPre = n; n = n->gNextNote(nPre); }
    unsigned long offx = n->gPos().gPosTicks();
    
    while (n!=0 && n->gPos() <= selX2-part->gOffset()) {
      n2 = n1;
      n1 = (KbNote*) n->copy(); n1->sPos(n1->gPos()-offx);
      if (noteSelection==0) noteSelection = n1;
      else n2->sNext(n1);
      n = n->gNextNote();
    }
  }
  if (noteSelection!=0) {
    panel->setItemEnabled(ID_EDIT_PASTE,TRUE);
    selection->setItemEnabled(ID_EDIT_PASTE,TRUE);
  } else {
    panel->setItemEnabled(ID_EDIT_PASTE,FALSE);
    selection->setItemEnabled(ID_EDIT_PASTE,FALSE);
  }
}

void QtEditor::pasteSelection() {
  if (noteSelection!=0) {
    part = partList[selSystem];
    KbNote * n = (KbNote*) noteSelection;
    while (n!=0) {
      KbNote * newNote = (KbNote*) n->copy(); newNote->sPos(newNote->gPos()+insPtr-part->gOffset());
      part->addNote(newNote);
      n = n->gNextNote();  
    }
    repaint( FALSE );
  }
}


void QtEditor::enableSelItems(bool b) {
  panel->setItemEnabled(ID_EDIT_CUT,b);
  panel->setItemEnabled(ID_EDIT_COPY,b);
  panel->setItemEnabled(ID_EDIT_TRANS,b);
  selection->setItemEnabled(ID_EDIT_CUT,b);
  selection->setItemEnabled(ID_EDIT_COPY,b);
  selection->setItemEnabled(ID_EDIT_TRANS,b);
  if (b==TRUE || selNote==0) selection->setItemEnabled(ID_EDIT_UNMARK,b);
  selection->setItemEnabled(ID_EDIT_Q,b);
  selection->setItemEnabled(ID_EDIT_LQ,b);
  selection->setItemEnabled(ID_EDIT_FL,b);
}

void QtEditor::getGrabNote(KbPosition pos,int freq) {
  KbNote * n = 0;
  // for (n=part->gFirstNote(); n!=0 && (n->gPos()!=pos || n->gFreq()!=freq); n=(KbNote*)n->gNextNote()) { }
  for (KbNote * nn = part->gFirstNote(); nn!=0;) {
    if ((nn->gPos() <= pos) && (pos < nn->gPos()+nn->gLen()) && (nn->gFreq()==freq)) { n = nn; nn = 0; }
    else {
      nn=(KbNote*)nn->gNextNote();
    }
  }
  if (n!=0) {
    grabNote = n;
    grabPos = n->gPos();
  }
}

KbPosition QtEditor::mousePosition() {
  return mousePos;
}

KbPosition QtEditor::mouseDownPosition() {
  return mouseDownPos;
}

KbPosition QtEditor::position(int i) {
  return KbPosition((i-xoffset)*1.0/pixPerTick);
}



// *****************************************************************************
//
// PAINT EVENT
// ===========
//

void QtEditor::paintEvent( QPaintEvent * pe ) {

  
}

// *****************************************************************************
//
// SLOTS
// =====
//


void QtEditor::mousePressEvent ( QMouseEvent * mouse ) {
  part = partList[selSystem];
  mouseDownX = mouse->x();
  mouseDownY = mouse->y();
  mouseDownPos = KbPosition((mouseDownX-xoffset)*1.0/pixPerTick) + posLeft;
  KbPosition pos = mouseDownPos.gPosTicks() - (mouseDownPos.gPosTicks()%snapValue) - part->gOffset();
  getGrabNote(pos,Pitch(mouseDownY));
  if (mouse->button()==RightButton) {
    selNote = grabNote;
    grabNote = 0;
    if (selNote) rbmenu->popup( mapToGlobal(mouse->pos()), 0 );
    grabX1 = 0;
    mouseDownX = 0;
  }
  
}


void QtEditor::mouseMoveEvent  ( QMouseEvent * mouse ) {
  part = partList[selSystem];
  mouseX = mouse->x();
  mouseY = mouse->y();
  mousePos = KbPosition(posLeft + (mouseX-xoffset)*1.0/pixPerTick);

  if (grabNote) {

  } else {
    if (mouseDownX != 0) { // draw Rect
      grabX1 = mouseDownX;
      grabX2 = mouseX;
      // repaint( FALSE ); // this shall be done by the derivd editors !!!
    }
  }
}


void QtEditor::mouseReleaseEvent ( QMouseEvent * mouse ) {
  part = partList[selSystem];
  mouseRelX = mouse->x();
  mouseRelY = mouse->y();
  mouseRelPos = KbPosition((mouseRelX-xoffset)*1.0/pixPerTick) + posLeft;

  createNote = false;

  if (mouse->button()==LeftButton) {

    if (grabNote) { // Note moved!
      
      KbNote * newNote = (KbNote*) grabNote->copy();
      part->addNote(newNote);
      part->deleteNote(grabNote);
      grabNote = 0;
      selNote = newNote;
      showNoteInfo();
      
    } else {
      
      if (abs(mouseRelX-mouseDownX)<3) { // Note erzeugen
	createNote=true;
	selX1 = -1;
	if (selNote==0) selection->setItemEnabled(ID_EDIT_UNMARK,FALSE);
      } else { // Selection markieren !!
	selX1 = mouseDownPos; selX1.snap(snapValue);
	selX2 = mouseRelPos; selX2.snap(snapValue);
	if (selX1>=selX2) {
	  enableSelItems(FALSE);
	  selX1 = -1;
	} else {
	  enableSelItems(TRUE);
	  selFrame->setTop(selX1.gTicks(master,met0,met1),selX1.gBeat(master,met0,met1),selX1.gBar(master,met0,met1));
	  selFrame->setBottom(selX2.gTicks(master,met0,met1),selX2.gBeat(master,met0,met1),selX2.gBar(master,met0,met1));
	}
	grabX1 = 0;
	repaint(FALSE);
      }

    }
  }
  
  mouseDownX = 0;
  mouseDownY = 0;
  grabX1 = 0;
  grabX2 = 0;

  repaint( FALSE );
}

void QtEditor::setIns() {
  // this is called when a new position is entered in the text field
  QString qs = insLine->text();
  qs = qs.simplifyWhiteSpace();
  int c1 = qs.find('.');
  if (c1 != -1) {
    int c2 = qs.find('.',c1+1);
    if (c2 != -1) insPtr = KbPosition(atoi(qs.left(c1)), atoi(qs.mid(c1+1,c2-c1-1)), atoi(qs.right(qs.length()-c2-1)),master,met0,met1);
  }
  if (insPtr<0) insPtr = 0;
  qs.sprintf( " %d. %d. %d",insPtr.gBar(master,met0,met1),insPtr.gBeat(master,met0,met1),insPtr.gTicks(master,met0,met1));
  insLine->setText(qs);
  insLine->clearFocus();
}

void QtEditor::setIns(KbPosition pos) {

  insPtr = pos;
  insPtr.snap(snapValue);
  // DOIT: KbPart * p = pcanvas->selPart[scanvas->selSystem];

  QString qs;

  if (insPtr<0) insPtr = 0;
  qs.sprintf( " %d. %d. %d",insPtr.gBar(master,met0,met1),insPtr.gBeat(master,met0,met1),insPtr.gTicks(master,met0,met1));

  insLine->setText(qs);
  insLine->clearFocus();
}


void QtEditor::showFreq() {

}

void QtEditor::keyPressEvent ( QKeyEvent * key ) {
  part = partList[selSystem];
  switch( key->key() ) {
  case Key_Space:
    if (key->state()==AltButton) {
      QApplication::setOverrideCursor( arrowCursor );
      setIns(mousePos);
    }
    break;
  case Key_Shift:
    shftFlag = TRUE;
    // ctrlFlag = FALSE;
    showFreq();
    break;
  case Key_Control:
    ctrlFlag = TRUE;
    // shftFlag = FALSE;
    showFreq();
    break;
  case Key_Left:
    if (selNote==0) {
      if (part->gFirstAtom()) part->sCur(part->gLastAtom()); selNote = part->gCurAtom(); showNoteInfo();
    } else {
      part->sCur(selNote);
      if (part->left()==true) { selNote = 0; showNoteInfoOff(); }
      else { selNote = part->gCurAtom(); showNoteInfo(); }
    }
    break;
  case Key_Right:
    getPartInfo();
    if (selNote==0) {
      if (part->gFirstAtom()) part->sCur(part->gFirstAtom()); selNote = part->gCurAtom(); showNoteInfo();
    }
    else {
      part->sCur(selNote);
      if (part->right()==true) { selNote = 0; showNoteInfoOff(); }
      else { selNote = part->gCurAtom(); showNoteInfo(); }
    }
  break;
    
  case Key_PageUp:
    if (selSystem>0) selSystem--;
    part = partList[selSystem];
    selNote=0;
    break;
  case Key_PageDown:
    if (selSystem<parts-1) selSystem++;
    part = partList[selSystem];
    selNote = 0;
    break;
  case Key_Up:
    if (selNote!=0) {
      part->sCur(selNote);
      ((KbNote*)selNote)->sFreq(((KbNote*)selNote)->gFreq()+1);
      showNoteInfo();
    } else {
      if (selX1!=-1) {
	KbNote * n = part->gFirstNote();
	while (n!=0 && n->gPos()<selX1) n = n->gNextNote();
	while (n!=0 && n->gPos()<=selX2) { n->sFreq(n->gFreq()+1); n = n->gNextNote(); }
      }
    }
    break;
  case Key_Down:
    if (selNote!=0) {
      part->sCur(selNote);
      ((KbNote*)selNote)->sFreq(((KbNote*)selNote)->gFreq()-1);
      showNoteInfo();
    } else {
      if (selX1!=-1) {
	KbNote * n = part->gFirstNote();
	while (n!=0 && n->gPos()<selX1) n = n->gNextNote();
	while (n!=0 && n->gPos()<=selX2) { n->sFreq(n->gFreq()-1); n = n->gNextNote(); }
      }
    }
    break;
  default:
    key->ignore();
  }
  repaint( FALSE );
}


void QtEditor::keyReleaseEvent ( QKeyEvent * key ) {
  switch( key->key() ) {
  case Key_Space:
    if (key->state()==AltButton) {
      QApplication::restoreOverrideCursor();
    }
    break;
  case Key_Shift:
    shftFlag = FALSE;
    ctrlFlag = FALSE;
    showFreq();
    break;
  case Key_Control:
    shftFlag = FALSE;
    ctrlFlag = FALSE;
    showFreq();
      break;
  default:
    key->ignore();
  }
}



#endif
