#ifndef _QTEVENT_H_
#define _QTEVENT_H_

#include "qtEditor.h"
#include "qsplitter.h"
#include "qlistbox.h"

class KbPart;
class EventWidget;
class LeftWidget;

/**
 * This qt class presents the contents of a part in a event presentation
 * @short Qt Event Class
 * @author NN
 * @version 0.95
 */
class QtEvent : public KTopLevelWidget// : public QtEditor
{
  Q_OBJECT
 private:
  QSplitter * splitter;
  LeftWidget * lw;
  EventWidget * ew;
  KbPart * part;
  int top;
  int itemh;

 public:
  QtEvent(KbPart * kbpart);
  void setTop(int);
  int getTop();
  void updateEW();
  void setItemHeight(int);
  int itemHeight();

 public slots:
  void exit();
};


class EventWidget : public QFrame
{
  Q_OBJECT
 private:
  QtEvent * qtevent;
  KbPart * part;

 public:
  EventWidget( QtEvent * qte, KbPart * pt, QWidget * parent = 0 );
 public slots:
  void paintEvent( QPaintEvent * );
};


class LeftWidget : public QListBox
{
  Q_OBJECT
 private:
  QtEvent * qtevent;
  KbPart * part;

 public:
  LeftWidget( QtEvent * qte, KbPart * pt, QWidget * parent = 0 );
  void getEntries();

 public slots:
   void paintEvent( QPaintEvent * );
};


#endif
