#ifndef _QTMAIN_C_
#define _QTMAIN_C_

#include "qtMain.h"
#include "qtTrack.h"
#include "qtPart.h"
#include "qtPartCanvas.h"
#include "qtSelFrame.h"
#include "qtScore.h"
#include "qtAuthors.h"
#include "kbTrack.h"
#include "kbAtom.h"

#include <iostream.h>
#include <unistd.h>

#include "kbMain.h"
#include "../config.h"
#include <qaccel.h>


enum { ID_FILE_NEW, ID_FILE_OPEN, ID_FILE_OPEN_OLD, ID_FILE_SAVE, ID_FILE_SA, ID_FILE_IM, ID_FILE_EM, ID_FILE_APPEND, ID_FILE_MAPPEND, ID_FILE_AUTHORS, ID_FILE_QUIT };
enum { ID_EDIT_ADDT, ID_EDIT_ADDT1, ID_EDIT_ADDT2, ID_EDIT_ADDT3, ID_EDIT_ADDT4 , ID_EDIT_SCORE , ID_EDIT_MIXDOWN, ID_EDIT_LEFT, ID_EDIT_RIGHT, ID_EDIT_Q , ID_EDIT_QL , ID_EDIT_FL , ID_EDIT_TRANSPOSE , ID_EDIT_PREFS };
enum { ID_TOOL_NEW , ID_TOOL_OPEN , ID_TOOL_SAVE , ID_TOOL_ADDT , ID_TOOL_PLUSV , ID_TOOL_MINUSV, ID_TOOL_PLUSH, ID_TOOL_MINUSH,
       ID_TOOL_TEMPOL, ID_TOOL_TEMPO, ID_TOOL_ML1, ID_TOOL_M1, ID_TOOL_ML2, ID_TOOL_M2, ID_TOOL_QUIT };
enum { ID_PANEL_BACK , ID_PANEL_REWIND , ID_PANEL_POS, ID_PANEL_FORWARD , ID_PANEL_CYCL, ID_PANEL_REC , ID_PANEL_PLAY , ID_PANEL_STOP, ID_PANEL_PAUSE, ID_PANEL_SLIDE };
enum { ID_STATUS_TEXT, ID_STATUS_PROGRESS };



MySpinBox::MySpinBox ( QWidget * parent = 0, const char * name = 0 )
  : QSpinBox(parent,name)
{
  
}

MySpinBox::MySpinBox ( int minValue, int maxValue, int step = 1, QWidget * parent = 0, const char * name = 0 )
  : QSpinBox(minValue, maxValue, step, parent, name)
{
  // setBackgroundMode( PaletteDark );
  // setBackgroundColor(black);
  // setPalette( QPalette(palette().disabled(),palette().disabled(),palette().disabled()) );
  QColorGroup old = palette().normal();
  QColorGroup cg = QColorGroup ( old.foreground(), old.background(), old.light(), old.dark(), old.mid(), old.text(),
				 parent->backgroundColor() );
  setPalette( QPalette(cg, palette().disabled(), palette().active()) );
  setLineWidth(0);
}


void MySpinBox::focusInEvent ( QFocusEvent * e ) {
  setLineWidth(2);
  QSpinBox::focusInEvent(e);
}

void MySpinBox::focusOutEvent ( QFocusEvent * e ) {
  setLineWidth(2);
  QSpinBox::focusOutEvent(e);
}


QtMain::QtMain( const char * name, KApplication * app, KbMain * kbmain, int argc, char ** argv )
  : KTopLevelWidget( name ), kooBase(app), main(kbmain), trackWidth(632), trackHeight(24), devList(new QStrList()),
    pixPerTick(1.0/24), pcBarOff(0), partShow(0)
{
  setMinimumWidth(640);
  if (argc>1) setCaption(argv[1]);

  for (int i=0;i<MAXDEVNUM;i++) devList->append(main->gDevice(i));
  
  KIconLoader * loader = kapp->getIconLoader();
  QPixmap qp = loader->loadIcon( "backWood.xpm" );
  // QPixmap leftBG = loader->loadIcon( "backLeft.xpm" );

  QPopupMenu * file = new QPopupMenu;
  file->insertItem( klocale->translate("New Piece of Music"), ID_FILE_NEW);
  file->insertItem( klocale->translate("Open File"), ID_FILE_OPEN);
  file->insertItem( klocale->translate("Save File"), ID_FILE_SAVE);
  file->insertItem( klocale->translate("Save File As"), ID_FILE_SA);
  file->insertSeparator();
  // file->insertItem( klocale->translate("[Open old]"), ID_FILE_OPEN_OLD);
  file->insertItem( klocale->translate("Import Midi File"), ID_FILE_IM);
  file->insertItem( klocale->translate("Export Midi File"), ID_FILE_EM);
  file->insertSeparator();
  file->insertItem( klocale->translate("Append File"), ID_FILE_APPEND);
  file->insertItem( klocale->translate("Append Midi File"), ID_FILE_MAPPEND);
  file->insertSeparator();
  file->insertItem( klocale->translate("Special Effects"), ID_FILE_AUTHORS);
  file->insertSeparator();
  file->setAccel(ALT+Key_O,ID_FILE_OPEN);
  file->setAccel(ALT+Key_S,ID_FILE_SAVE);
  file->setAccel(ALT+Key_I,ID_FILE_IM);

  file->insertItem( klocale->translate("Quit"), ID_FILE_QUIT);
  connect(file,SIGNAL(activated(int)),SLOT(fileMenu(int)));

  QPopupMenu * edit = new QPopupMenu;
  edit->insertItem( klocale->translate("Add Score Track"), ID_EDIT_ADDT);
  edit->insertItem( klocale->translate("Add Drum Track"), ID_EDIT_ADDT1);
  edit->insertItem( klocale->translate("Add Mastertrack"), ID_EDIT_ADDT2);
  edit->insertItem( klocale->translate("Add Wave Track"), ID_EDIT_ADDT3);
  edit->insertItem( klocale->translate("Add Comment"), ID_EDIT_ADDT4);
  edit->insertSeparator();
  edit->insertItem( klocale->translate("Edit Score"), ID_EDIT_SCORE);
  edit->insertSeparator();
  edit->insertItem( klocale->translate("Mix Down"), ID_EDIT_MIXDOWN);
  edit->insertSeparator();
  edit->insertItem( klocale->translate("Mark Left"), ID_EDIT_LEFT);
  edit->insertItem( klocale->translate("Mark Right"), ID_EDIT_RIGHT);
  edit->insertSeparator();
  edit->insertItem( klocale->translate("Quantize All"), ID_EDIT_Q);
  edit->insertItem( klocale->translate("Quantize Length"), ID_EDIT_QL);
  edit->insertItem( klocale->translate("Fixed Length"), ID_EDIT_FL);
  //edit->insertItem( klocale->translate("Transpose"), ID_EDIT_TRANSPOSE);
  edit->insertSeparator();
  edit->insertItem( klocale->translate("Preferences"), ID_EDIT_PREFS);
  connect(edit,SIGNAL(activated(int)),SLOT(editMenu(int)));
  edit->setAccel(ALT+Key_L,ID_EDIT_LEFT);
  edit->setAccel(ALT+Key_R,ID_EDIT_RIGHT);
  edit->setAccel(ALT+Key_E,ID_EDIT_SCORE);

  snapm = new QPopupMenu;
  snapm->insertItem( loader->loadIcon( "n1.xpm" ), 1536 );
  snapm->insertItem( loader->loadIcon( "n2.xpm" ), 768 );
  snapm->insertItem( loader->loadIcon( "n4.xpm" ), 384 );
  snapm->insertItem( loader->loadIcon( "n8.xpm" ), 192 );
  snapm->insertItem( loader->loadIcon( "n16.xpm" ), 96 );
  snapm->insertItem( loader->loadIcon( "n32.xpm" ), 48 );
  snapm->insertItem( loader->loadIcon( "n64.xpm" ), 24 );
  snapm->insertItem( klocale->translate("off   "), 1 );
  snapm->setCheckable(TRUE);
  snapm->setItemChecked(192,TRUE);
  connect(snapm,SIGNAL(activated(int)),SLOT(snapMenu(int)));

  QPopupMenu * help = kapp->getHelpMenu( FALSE, "Brahms, version "
					 VERSION
					 "\n(former kooBase)\n\n1999 written by\n\nFabian 'Fab' Wenzel and\nJan 'Jan' Wuerthner" );

  menu = new KMenuBar( this );
  CHECK_PTR( menu );
  menu->insertItem(klocale->translate("File"),file);
  menu->insertItem(klocale->translate("Edit"),edit);
  menu->insertItem(klocale->translate("Grid"),snapm);
  menu->insertItem(klocale->translate("Help"),help);
  menu->show();

  setMenu( menu );


  // Toolbar:
  // ========
  
  toolbar = new KToolBar( this );
  toolbar->insertButton( loader->loadIcon( "filenew.xpm"), ID_TOOL_NEW, TRUE, klocale->translate("New File"));
  toolbar->insertButton( loader->loadIcon( "fileopen.xpm" ), ID_TOOL_OPEN, TRUE, klocale->translate("Open a File"));
  toolbar->insertButton( loader->loadIcon( "filefloppy.xpm" ), ID_TOOL_SAVE, TRUE, klocale->translate("Save the File"));
  toolbar->insertSeparator();
  toolbar->insertSeparator();
  toolbar->insertButton( loader->loadIcon( "addt.xpm"), ID_TOOL_ADDT, TRUE, klocale->translate("Add Score Track"));
  toolbar->insertButton( loader->loadIcon( "vPlus.xpm"), ID_TOOL_PLUSV, TRUE, klocale->translate("Enlarge View Vertically"));
  toolbar->insertButton( loader->loadIcon( "vMinus.xpm"), ID_TOOL_MINUSV, TRUE, klocale->translate("Shrink View Vertically"));
  toolbar->insertButton( loader->loadIcon( "hPlus.xpm"), ID_TOOL_PLUSH, TRUE, klocale->translate("Enlarge View Horizontally"));
  toolbar->insertButton( loader->loadIcon( "hMinus.xpm"), ID_TOOL_MINUSH, TRUE, klocale->translate("Shrink View Horizontally"));
  toolbar->insertSeparator();
  toolbar->insertSeparator();
  tempolab  = new QLabel("tempo:",toolbar); toolbar->insertWidget(ID_TOOL_TEMPOL,48,tempolab);
  tempobox  = new MySpinBox(1,260000,1,toolbar); tempobox->setValue(main->gTempo()); toolbar->insertWidget(ID_TOOL_TEMPO,52,tempobox);
  meterlab1 = new QLabel("  meter:",toolbar); toolbar->insertWidget(ID_TOOL_ML1,48,meterlab1);
  meterbox1 = new MySpinBox(1,32,1,toolbar); meterbox1->setValue(main->gMeter(0)); toolbar->insertWidget(ID_TOOL_M1,44,meterbox1);
  meterlab2 = new QLabel("/",toolbar); toolbar->insertWidget(ID_TOOL_ML2,8,meterlab2);
  meterbox2 = new MySpinBox(1,32,1,toolbar); meterbox2->setValue(main->gMeter(1)); toolbar->insertWidget(ID_TOOL_M2,44,meterbox2);
  toolbar->insertSeparator();
  toolbar->insertSeparator();
  toolbar->insertButton( loader->loadIcon( "exit.xpm"), ID_TOOL_QUIT, TRUE, klocale->translate("Exit"));
  connect(tempobox,SIGNAL(valueChanged(int)),SLOT(updateTempo(int)));
  connect(meterbox1,SIGNAL(valueChanged(int)),SLOT(updateMeter1(int)));
  connect(meterbox2,SIGNAL(valueChanged(int)),SLOT(updateMeter2(int)));
  connect(toolbar,SIGNAL(clicked(int)), SLOT(tbMenu(int)));


  // Panel:
  // ======

  panel = new KToolBar( this );
  panel->insertButton( loader->loadIcon( "start.xpm"), ID_PANEL_BACK, TRUE, klocale->translate("Back to Start"));
  panel->insertButton( loader->loadIcon( "back.xpm"), ID_PANEL_REWIND, TRUE, klocale->translate("Rewind"));
  panel->insertLined( "", ID_PANEL_POS, SIGNAL(returnPressed()), this, SLOT(updatePos()), klocale->translate("Song Position"));
  panel->insertButton( loader->loadIcon( "forward.xpm"), ID_PANEL_FORWARD, TRUE, klocale->translate("Forward"));
  panel->insertSeparator();
  panel->insertSeparator();
  panel->insertButton( loader->loadIcon( "cycl.xpm"), ID_PANEL_CYCL, TRUE, klocale->translate("cycle"));
  panel->insertButton( loader->loadIcon( "record.xpm"), ID_PANEL_REC, TRUE, klocale->translate("Record"));
  panel->insertButton( loader->loadIcon( "play.xpm"), ID_PANEL_PLAY, TRUE, klocale->translate("Play"));
  panel->insertButton( loader->loadIcon( "pause.xpm"), ID_PANEL_PAUSE, TRUE, klocale->translate("Pause"));
  panel->insertButton( loader->loadIcon( "stop.xpm"), ID_PANEL_STOP, TRUE, klocale->translate("Stop"));
  panel->insertSeparator();
  panel->insertSeparator();
  panel->insertWidget(-2,38,new QLabel("range:",panel));
  selFrame = new QtSelFrame(panel,"-",main);
  panel->insertWidget(-2,72,selFrame);
  posSlider = new QSlider(0,1536*8,1536,0,QSlider::Horizontal,panel); panel->insertWidget(ID_PANEL_SLIDE,24,posSlider);
  // posSlider = new KSlider(0,1536*8,1536,0,KSlider::Horizontal,panel); panel->insertWidget(ID_PANEL_SLIDE,24,posSlider);
  panel->getWidget(ID_PANEL_POS)->setFont(QFont("courier"));
  panel->getWidget(ID_PANEL_POS)->setFixedWidth(112);
  panel->setToggle(ID_PANEL_CYCL,TRUE);
  panel->setItemEnabled(ID_PANEL_CYCL,FALSE);
  panel->setItemAutoSized(ID_PANEL_SLIDE);
  panel->setItemEnabled(ID_PANEL_STOP,FALSE);
  panel->setItemEnabled(ID_PANEL_PAUSE,FALSE);
  connect(posSlider,SIGNAL(valueChanged(int)),SLOT(updatePos(int)));
  connect(panel,SIGNAL(clicked(int)), SLOT(panelMenu(int)));

  KbPart * master = main->Master();
  int m0 = main->gMeter(0);
  int m1 = main->gMeter(1);
  KbPosition leftpos;
  selFrame->setTop(leftpos.gTicks(master,m0,m1),leftpos.gBeat(master,m0,m1),leftpos.gBar(master,m0,m1));
  KbPosition rightpos = KbPosition(5,1,0,master,m0,m1);
  selFrame->setBottom(rightpos.gTicks(master,m0,m1),rightpos.gBeat(master,m0,m1),rightpos.gBar(master,m0,m1));

  addToolBar( toolbar );
  addToolBar( panel );
  toolbar->show();
  panel->show();
  

  // Status Bar:
  // ===========
  
  stat = new KStatusBar( this );
  stat->insertItem("Brahms, 1999 by F.Wenzel & J.Wrthner ", ID_STATUS_TEXT);
  progressbar = new QProgressBar(16,stat);
  progressbar->hide();
  progressbar->setFrameStyle( QFrame::Panel | QFrame::Sunken );
  stat->insertWidget(progressbar,80,ID_STATUS_PROGRESS);

  setStatusBar( stat );


  // Contents:
  // =========

  scroller = new QScrollView( this, "Scroller", QFrame::Raised );
  scroller->setHScrollBarMode(QScrollView::AlwaysOff);
  scroller->setVScrollBarMode(QScrollView::AlwaysOn);
  scroller->setMaximumWidth(2000);

  splitter = new QSplitter();
  splitter->setResizeMode(splitter,QSplitter::Stretch);
  splitter->setFixedWidth(640);
  splitter->setFixedHeight(1024);
  splitter->setOpaqueResize(TRUE);
  
  left = new QWidget( splitter );
  left->setFixedHeight(1024);
  left->setMaximumWidth(trackWidth);
  // left->setBackgroundPixmap( leftBG );
  left->setBackgroundMode( PaletteDark );

  headline = new QtHeadLine(trackHeight,left);
  headline->setFrameStyle( QFrame::Panel | QFrame::Raised );
  headline->setGeometry(0,0,trackWidth+1,trackHeight);
  headline->show();

  pcanvas = new QtPartCanvas( this, splitter );
  pcanvas->setBackgroundPixmap(qp);
  // pcanvas->setMaximumWidth(1600);
  pcanvas->setFrameStyle( QFrame::Panel | QFrame::Sunken );
  pcanvas->setLineWidth(2);

  // ***********
  //
  // Drop Zones
  // ==========
  //
  
  // Left canvas shall be a DropZone (that clears the track field!)
  
  dropZone1 = new KDNDDropZone( left , DndURL );
  connect( dropZone1, SIGNAL( dropAction( KDNDDropZone *) ), 
	   this, SLOT( dropActionSlot1( KDNDDropZone *) ) );

  // PartCanvas shall be an APPEND DropZone !!

  dropZone2 = new KDNDDropZone( pcanvas , DndURL );
  connect( dropZone2, SIGNAL( dropAction( KDNDDropZone *) ), 
	   this, SLOT( dropActionSlot2( KDNDDropZone *) ) );


  scroller->addChild(splitter,0,0);
  setView( scroller );
  showPos();
  show();

}


void QtMain::createPrefs() {
  PREFS = new QtPrefs(this,"prefs");
}

void QtMain::createAuthors() {
  new QtAuthors("authors");
}

void QtMain::dropActionSlot1(KDNDDropZone * z) {
  QStrList urls = z->getURLList();
  char* url = urls.first(); // take only the first
  QString qs = url;
    
  QString ext = qs.right(3);
  qs = qs.right(qs.length()-5);
  if (ext=="mid" || ext=="MID" || ext=="idi" || ext=="IDI") {
    main->clear();
    main->getMidi(midiLoadDialog(&qs));
  }
  else if (ext==".bms" || ext==".BMS") {
    main->clear();
    main->getKooBase(kbLoadDialog(&qs));
  }
  setCaption(qs);
  repaint();
}

void QtMain::dropActionSlot2(KDNDDropZone * z) {
  QStrList urls = z->getURLList();
  char* url = urls.first(); // take only the first
  QString qs = url;
    
  QString ext = qs.right(3);
  qs = qs.right(qs.length()-5);
  if (ext=="mid" || ext=="MID" || ext=="idi" || ext=="IDI")
    main->getMidi(midiLoadDialog(&qs));
  else if (ext==".bms" || ext==".BMS")
    main->getKooBase(kbLoadDialog(&qs));
  
  setCaption(qs);
  repaint();
}


char * QtMain::midiLoadDialog(QString * fn) {
  QString fname;
  if (fn->length()==0) {
    fname = QFileDialog::getOpenFileName(0,"*.mid*");
  } else {
    fname = *fn;
  }
  
  // DOIT: deleteAll();
  int c = fname.length()-fname.findRev('/')-1;
  // DOIT: stat->changeItem("Loading MIDI file: "+fname.right(c), ID_MAIN_STATUS );
  msg("Loading MIDI file"); //: "+fname.right(c));
  // progressbar->show();
  // progressbar->setProgress(0);

  //ifstream * in = new ifstream(fname);
  return ((char*)qstrdup(fname));
}

ifstream * QtMain::kbLoadDialog(QString * fn) {
  QString fname;
  if (fn->length()==0) {
    fname = QFileDialog::getOpenFileName(0,"*.bms");
  } else {
    fname = *fn;
  }
  
  // DOIT: deleteAll();
  int c = fname.length()-fname.findRev('/')-1;
  // DOIT: stat->changeItem("Loading MIDI file: "+fname.right(c), ID_MAIN_STATUS );
  msg("Loading brahms file"); //: "+fname.right(c));
  // progressbar->show();
  // progressbar->setProgress(0);

  ifstream * in = new ifstream(fname);
  return in;
}

ofstream * QtMain::midiSaveDialog(QString * fn) {
  QString fname = QFileDialog::getSaveFileName(0,"*.mid*");
  int c = fname.length()-fname.findRev('/')-1;
  msg("Writing MIDI file"); //: "+fname.right(c));

  ofstream * out = new ofstream(fname);
  return out;
}

ofstream * QtMain::kbSaveDialog(QString * fn) {
  QString fname = QFileDialog::getSaveFileName(0,"*.bms");
  int c = fname.length()-fname.findRev('/')-1;
  msg("Writing brahms file"); //: "+fname.right(c));

  ofstream * out = new ofstream(fname);
  return out;
}

void QtMain::resizeEvent( QResizeEvent * re ) {
  KTopLevelWidget::resizeEvent(re);
  // cout << width() << endl;
  // int canvasMarginLeft = 546;
  // int canvasMarginRight = width()-18;
  
  // scroller->setFixedSize(width(),height());
  // splitter->setFixedSize(scroller->width(),scroller->height());
  splitter->setFixedWidth(scroller->width());
  // pcanvas->setMaximumSize(canvasMarginRight,1024);
  // pcanvas->setGeometry(0,0,canvasMarginRight-canvasMarginLeft+320,mainSplitter->height());
  // pcanvas->move(72,0);
  // mainSplitter->resizeEvent(re);
  // headline->setGeometry(0,0,canvasMarginLeft+1,heightOfTrack-1);
}


void QtMain::exec() {
  kooBase->exec();
}

void QtMain::update() {
  tempobox->setValue(main->gTempo());
  meterbox1->setValue(main->gMeter(0));
  meterbox2->setValue(main->gMeter(1));
  for (KbTrack * tr=main->gTrack(); tr!=0; tr=tr->gNext())
    ((QtTrack*) tr->gInterface())->update();
}

KbMain * QtMain::gMain() {
  return main;
}

KbPosition QtMain::gPos() {
  return main->gPos();
}

void QtMain::fileMenu(int n) {
  switch (n) {
  case ID_FILE_NEW:
    main->clear();
    break;
  case ID_FILE_OPEN:
    main->clear();
    main->getKooBase(kbLoadDialog(new QString()));
    break;
  case ID_FILE_OPEN_OLD:
    // DOIT: ...
    break;
  case ID_FILE_SAVE:
    main->saveKooBase(kbSaveDialog(new QString()));
    break;
  case ID_FILE_SA:
    main->saveKooBase(kbSaveDialog(new QString()));
    break;
  case ID_FILE_IM:
    main->clear();
    main->getMidi(midiLoadDialog(new QString()));
    break;
  case ID_FILE_EM:
    main->saveMidi(midiSaveDialog(new QString()));
    break;
  case ID_FILE_APPEND:
    main->getKooBase(kbLoadDialog(new QString()));
    break;
  case ID_FILE_MAPPEND:
    main->getMidi(midiLoadDialog(new QString()));
    break;
  case ID_FILE_AUTHORS:
    createAuthors();
    break;
  case ID_FILE_QUIT:
    main->stopAll();
    kapp->quit();
    break;
  }
}

void QtMain::editMenu(int n) {
  switch (n) {
  case ID_EDIT_ADDT:
    main->addTrack(0);
    break;
  case ID_EDIT_ADDT1:
    main->addTrack(1);
    break;
  case ID_EDIT_ADDT2:
    main->addTrack(2);
    break;
  case ID_EDIT_ADDT3:
    main->addTrack(3);
    break;
  case ID_EDIT_ADDT4:
    main->addTrack(4);
    break;
  case ID_EDIT_SCORE:
    newScore();
    break;
  case ID_EDIT_MIXDOWN:
    mixdown();
    break;
  case ID_EDIT_LEFT:
    main->sLeftSel();
    //KbPosition left = main->gLeftSel();
    //selFrame->setTop(left.gTicks(),left.gBeat(),left.gBar());
    // // if (main->gRightSel()<=main->gLeftSel()) { selX2 = selX1; selFrame->setBottom(main->gTick(),main->gBeat(),main->gBar()); }
    selFrame->setTop(main->gLeftSel());
    pcanvas->repaint();
    break;
  case ID_EDIT_RIGHT:
    main->sRightSel();
    // // if (selX1<0 || selX1>selX2) { selX1 = 0; selFrame->setTop(0,1,1); }
    //KbPosition right = main->gRightSel();
    //selFrame->setBottom(right.gTicks(),right.gBeat(),right.gBar());
    selFrame->setBottom(main->gRightSel());
    pcanvas->repaint();
    break;
  case ID_EDIT_Q:
    for (KbTrack * tr=main->gTrack();tr!=0;tr=tr->gNext())
      for (KbPart * pt=tr->gPart();pt!=0;pt=pt->gNext())
	pt->quantize(main->gSnap());
    break;
  case ID_EDIT_QL:
        for (KbTrack * tr=main->gTrack();tr!=0;tr=tr->gNext())
      for (KbPart * pt=tr->gPart();pt!=0;pt=pt->gNext())
	pt->quantizeLength(main->gSnap());
    break;
  case ID_EDIT_FL:
        for (KbTrack * tr=main->gTrack();tr!=0;tr=tr->gNext())
      for (KbPart * pt=tr->gPart();pt!=0;pt=pt->gNext())
	pt->fixedLength(main->gSnap());
    break;
  case ID_EDIT_TRANSPOSE:
    
    break;
  case ID_EDIT_PREFS:
    createPrefs();
    break;     
  }
}

void QtMain::snapMenu(int n) {
  snapm->setItemChecked(main->gSnap(),FALSE);
  main->sSnap(n);
  snapm->setItemChecked(n,TRUE);
}

void QtMain::tbMenu(int n) {
  switch (n) {
  case ID_TOOL_NEW:
    main->clear();
    break;
  case ID_TOOL_OPEN:
    main->clear();
    main->getKooBase(kbLoadDialog(new QString()));
    break;
  case ID_TOOL_SAVE:
    main->saveKooBase(kbSaveDialog(new QString()));
    break;
  case ID_TOOL_ADDT:
    main->addTrack(0);
    break;
  case ID_TOOL_PLUSV:
    trackHeight += 2;
    adjustHeight();
    pcanvas->repaint();
    break;
  case ID_TOOL_MINUSV:
    trackHeight -= 2;
    adjustHeight();
    pcanvas->repaint();
    break;
  case ID_TOOL_MINUSH:
    // if (pcBarSize>4) pcBarSize /= 2; 
    pixPerTick /= 2;
    pcanvas->repaint();
    break;
  case ID_TOOL_PLUSH:
    pixPerTick *= 2;
    pcanvas->repaint();
    break;
  case ID_TOOL_QUIT:
    main->stopAll();
    kapp->quit();
    break;
  }
}

void QtMain::panelMenu(int n) {
  switch (n) {
  case ID_PANEL_BACK:
    main->sPos(0);
    //main->BBT(0);
    showPos();
    pcanvas->drawLine();
    break;
  case ID_PANEL_REWIND:
    main->sPos(main->gPos()-int(1536.0*main->gMeter(0)/main->gMeter(1)));
    //main->BBT(main->gPos());
    showPos();
    pcanvas->drawLine();
    break;
  case ID_PANEL_POS:
    // cout << "hi" << endl;
    break;
  case ID_PANEL_FORWARD:
    main->sPos(main->gPos()+int(1536.0*main->gMeter(0)/main->gMeter(1)));
    //main->BBT(main->gPos());
    showPos();
    pcanvas->drawLine();
    break;
  case ID_PANEL_CYCL:
    main->togCycle();
    break;
  case ID_PANEL_REC:
    break;
  case ID_PANEL_PLAY:
    main->play();
   break;
  case ID_PANEL_STOP:
    main->stopAll(true); // true: zero position!
    break;
  case ID_PANEL_PAUSE:
    main->stopAll();
    break;
  case ID_PANEL_SLIDE:
    break;
  }
}

void QtMain::newScore() {
  KbPart * pt = 0;
  for (KbTrack * tr=main->gTrack(); tr!=0;) {
    if (tr->gPart()!=0) { pt=tr->gPart(); tr=0; }
    if (tr!=0) tr=tr->gNext();
  }
  if (pt!=0) {
    QtScore * sc = new QtScore(pt,true);
    sc->show();
    msg("Editing Part");
  } else {
    msg("No Parts Available");
  }
}

void QtMain::mixdown() {
  KbTrack * tr = main->addTrack(0);
  KbPart * newPart = tr->addPart(0);
  for (KbTrack * tr = main->gTrack(); tr != 0; tr = tr->gNext()) {
    if (tr->gNext()!=0) {
      for (KbPart * pt = tr->gPart(); pt != 0; pt = pt->gNext())
	for (pt->reset(); pt->gCurAtom()!=0; pt->iterate()) {
	  if (pt->gCurAtom()->isNote()) newPart->addNote((KbNote*)pt->copyAtom(true));
	  else newPart->addAtom(pt->copyAtom(true));
	}
      
    }
  }
}

void QtMain::adjustHeight() {
  headline->setGeometry(0,0,trackWidth+1,trackHeight);
  KbTrack * tr =  main->gTrack();
  while (tr!=0) {
    ((QtTrack*) tr->gInterface())->adjustHeight();
    tr = tr->gNext();
  }
}

void QtMain::updatePos() {
  // this is called when a new position is entered in the text field
  QString qs = ((QLineEdit*) panel->getWidget(ID_PANEL_POS))->text();
  qs = qs.simplifyWhiteSpace();
  int c1 = qs.find('.');
  if (c1 != -1) {
    int c2 = qs.find('.',c1+1);
    if (c2 != -1) main->sPos(atoi(qs.left(c1)), atoi(qs.mid(c1+1,c2-c1-1)), atoi(qs.right(qs.length()-c2-1)));
  }
  panel->getWidget(ID_PANEL_POS)->clearFocus();
  showPos();
  pcanvas->drawLine();
}

void QtMain::updatePos(int n) {
  // this is called when the position-slider is moved
  main->sPos(n);
  //main->BBT(main->gPos());
  showPos();
  pcanvas->drawLine();
}

void QtMain::updateTempo(int n) {
  main->sTempo(n);

  tempobox->clearFocus();
  
}

void QtMain::updateMeter1(int n) {
  main->sMeter(0,n);
  pcanvas->repaint();
}

void QtMain::updateMeter2(int n) {
  int q = main->gMeter(1);
  if (n==q+1) main->sMeter(1,q*2);
  if (n==q-1) main->sMeter(1,int(q/2));
  if (n==q+1 || n==q-1) meterbox2->setValue(main->gMeter(1));
  pcanvas->repaint();
}

int QtMain::gTrackHeight() {
  return trackHeight;
}

int QtMain::gTrackWidth() {
  return trackWidth;
}

QStrList * QtMain::gDevList() {
  return devList;
}

double QtMain::gPixPerTick() {
  return pixPerTick;
}

int QtMain::gBarOff() {
  return pcBarOff;
}


QWidget * QtMain::gLeft() {
  return left;
}

QtPartCanvas * QtMain::gPartCanvas() {
  return pcanvas;
}

// -------------------------------------------------------------
//
// QtHeadLine
// ==========
//


QtHeadLine::QtHeadLine( int hot, QWidget *parent=0, const char *name=0)
  : QLabel( parent, name ), trackHeight(hot)
{
  
  //setBackgroundMode( PaletteLight );
  
  mute = new QLabel( "M",this );
  mute->setGeometry(1,1,23,hot-3);
  mute->setAlignment(AlignCenter);
  
  type = new QLabel( "T",this );
  type->setGeometry(24,1,23,hot-3);
  type->setAlignment(AlignCenter);
  
  lock = new QLabel( "L",this );
  lock->setGeometry(48,1,23,hot-3);
  lock->setAlignment(AlignCenter);
  
  trname = new QLabel("Name",this);
  trname->setGeometry(72,1,95,hot-3);
  trname->setAlignment(AlignCenter);
  
  instname = new QLabel("Instrument",this);
  instname->setGeometry(168,1,159,hot-3);
  instname->setAlignment(AlignCenter);
  
  output = new QLabel( "Output",this );
  output->setGeometry(328,1,95,hot-3);
  output->setAlignment(AlignCenter);

  chnumber = new QLabel("Chan",this);
  chnumber->setGeometry(424,1,43,hot-3);
  chnumber->setAlignment(AlignCenter);
  
  vol = new QLabel("Volume",this);
  vol->setGeometry(468,1,53,hot-3);
  vol->setAlignment(AlignCenter);

  tra = new QLabel("Transp",this);
  tra->setGeometry(522,1,53,hot-3);
  tra->setAlignment(AlignCenter);

  del = new QLabel("Delay",this);
  del->setGeometry(576,1,53,hot-3);
  del->setAlignment(AlignCenter);
}


void QtMain::msg(char * txt) {
  stat->changeItem(txt, ID_STATUS_TEXT);
}


int QtMain::gPartShow() {
  return partShow;
}

void QtMain::sPartShow(int i) { partShow = i; pcanvas->repaint(); }

void QtMain::playInit() {

  panel->setItemEnabled(ID_PANEL_PLAY,FALSE);
  panel->setItemEnabled(ID_PANEL_REC,FALSE);
  panel->setItemEnabled(ID_PANEL_STOP,TRUE);
  panel->setItemEnabled(ID_PANEL_PAUSE,TRUE);
  
  if (main->gPlayWait()==TRUE) msg("Playing after acoustic signal");
  else msg("...playing song");
  //posSlider->setRange(0,main->gRightPosition().gPosTicks());
  
  numScr=0;
  for (KbTrack * tr = main->gTrack(); tr!=0; tr=tr->gNext()) numScr++;
  for (int i=0;i<numScr;i++) led[i] = 0;
  
  startTimer(50);
}

void QtMain::timerEvent( QTimerEvent * e ) {
  char * ptr;
  QPainter p;
  p.begin(pcanvas);

  int pp=0;
  int ledd=0;
  if ((ctop_read = read(main->gFback(), bufCtoP, (size_t) CMDLENCTOP)) > 0) { // message from Child process (playing sequencer)
    bufCtoP[ctop_read] = 0;
    ptr = bufCtoP;
    // cout << bufCtoP << ", numScr: " << numScr << endl;
    answer = atoi(ptr);
    count = 1;
    for (int i=0;i<numScr;i++) {
      ledd = answer & count;
      if (ledd==0) { if (led[i]>0) led[i]--; }
      else led[i]=15;
      // if (led[i]>15) led[i]=15;
      count *= 2;
    }
    for (;ptr[0]!=' ';ptr++) {} ptr++;
    if (answer==-1) { // Parent Process gets STOP signaled from Child !!!
      // cout << "OK, received stop signal" << endl;
      killTimers();
      int stop =atoi(ptr);
      for (int i=0;i<numScr;i++) {
	if (led[i]!=-1)
	  p.fillRect(2,(i+1)*(1+trackHeight)+5,8,trackHeight-11, QColor(40,0,20));
      }
      panel->setItemEnabled(ID_PANEL_PLAY,TRUE);
      panel->setItemEnabled(ID_PANEL_REC,TRUE);
      panel->setItemEnabled(ID_PANEL_STOP,FALSE);
      panel->setItemEnabled(ID_PANEL_PAUSE,FALSE);
      msg("stopped playing!");
      // gMain()->closeDev();
      // cout << ":" << stop << endl;
      // stop=2:End, stop=5:Pause, stop=6:Stop
      if ((stop==6)||(stop==2)) { pp = 0; main->sPos(0); showPos(); pcanvas->drawLine(); }
      
    } else {
      pp = atoi(ptr);
      posSlider->setValue(pp);
      for (int i=0;i<numScr;i++) {
	if (led[i]!=-1)
	  p.fillRect(2,(i+1)*(1+trackHeight)+5,8,trackHeight-11, QColor(80,17*led[i],20));
      }
      main->sPos(pp);
      //main->BBT(pp);
      showPos();
      pcanvas->drawLine();
    }
    //main->sPos(pp);
    //main->BBT(pp);
    showPos();
    pcanvas->drawLine();
  }
  
  p.end();
    
}

void QtMain::showPos() {
  KbPart * master = main->Master();
  int m0 = main->gMeter(0);
  int m1 = main->gMeter(1);
  posString.sprintf( " %d. %d. %d",main->gPos().gBar(master,m0,m1),main->gPos().gBeat(master,m0,m1),main->gPos().gTicks(master,m0,m1));
  ((QLineEdit*) panel->getWidget(ID_PANEL_POS))->setText(posString);
  ((QLineEdit*) panel->getWidget(ID_PANEL_POS))->clearFocus();
  posSlider->setValue(gPos().gPosTicks());
}

void QtMain::playExit() {
  killTimers();
}



#endif
