#ifndef _QTPARTCANVAS_C_
#define _QTPARTCANVAS_C_

#include "qtPartCanvas.h"
#include "qtPart.h"
#include "qtScore.h"
#include "kbMain.h"
#include "kbTrack.h"
#include "kbPosition.h"
#include "kbAtom.h"
#include "kbNote.h"
#include <iostream.h>

// ************************************************
//
// QtPartCanvas
// ============
//


QtPartCanvas::QtPartCanvas( QtMain * qtm, QWidget * parent )
  : QFrame( parent ), qtmain(qtm), xoffset(18)
{
  timebar = new QtTimeBar( qtmain, this );
  timebar->setGeometry(0,0,1600,24);
  timebar->setFrameStyle( QFrame::Panel | QFrame::Raised );
  timebar->setLineWidth(2);
  timebar->show();
  
  rbmenu = new QPopupMenu;
  rbmenu->setMouseTracking( TRUE );
  rbmenu->connectItem( rbmenu->insertItem(klocale->translate("Edit Entire Score")), this, SLOT(scoreEdit()) );
  rbmenu->connectItem( rbmenu->insertItem(klocale->translate("Preferences")), this, SLOT(preferences()) );
  rbmenu->insertSeparator();
  rbmenu->connectItem( rbmenu->insertItem(klocale->translate("Erase Entire Song")), this, SLOT(deleteSong()) );
  
  //  rbmenu->connectItem( rbmenu->insertItem(klocale->translate("")), this, SLOT() );
  line = new QWidget(this);
  line->setBackgroundColor(white);
  line->setBackgroundMode( PaletteMid );
  // line->hide();
  // line->setGeometry(0,0,1,1);
  drawLine();
}

void QtPartCanvas::preferences() {
  qtmain->createPrefs();
}


void QtPartCanvas::scoreEdit() {
  KbPart * pt = 0;
  for (KbTrack * tr=qtmain->gMain()->gTrack(); tr!=0;) {
    if (tr->gPart()!=0) { pt=tr->gPart(); tr=0; }
    if (tr!=0) tr=tr->gNext();
  }
  if (pt!=0) {
    QtScore * sc = new QtScore(pt,true);
    sc->show();
    qtmain->msg("Editing Part");
  } else {
    qtmain->msg("No Parts Available");
  }
}

void QtPartCanvas::deleteSong()
{
  qtmain->gMain()->clear();
}

void QtPartCanvas::paintEvent( QPaintEvent * pe )
{
  timebar->repaint();
  KbTrack * tr = qtmain->gMain()->gTrack();
  int n=0;
  while (tr!=0) {
    n++;
    if (tr->gPart()!=0) {
      for (QtPart * p=(QtPart*) tr->gPart()->gInterface();p!=0;) {
	p->repaint();
	if (p->gNext()!=0) p=(QtPart*) p->gNext()->gInterface();
	else p = 0;
      }
    }
    tr = tr->gNext();
  }
}

int QtPartCanvas::gOffset() {
  return xoffset;
}

int QtPartCanvas::gPos() {
  return qtmain->gPos().gPosTicks();
}

void QtPartCanvas::mousePressEvent ( QMouseEvent * mouse ) {
  mouseX = mouse->x();
  mouseY = mouse->y();
  if (mouse->button()==RightButton) {
    rbmenu->popup( mapToGlobal(mouse->pos()), 0 );
  }
}


void QtPartCanvas::mouseDoubleClickEvent( QMouseEvent * mouse ) {
  int yy = mouse->y()/(1+qtmain->gTrackHeight())-1;
  KbTrack * tr = qtmain->gMain()->gTrack(yy);
  if (tr==0) tr = qtmain->gMain()->addTrack(0);
  tr->addPart();
}


void QtPartCanvas::mouseMoveEvent  ( QMouseEvent * mouse ) {
  // int yy = mouse->y()/(1+qtmain->gTrackHeight())-1;
  // cout << yy << endl;
}


void QtPartCanvas::mouseReleaseEvent ( QMouseEvent * mouse ) {

}

void QtPartCanvas::drawLine() {

  line->setGeometry(gOffset()+int(gPos()*qtmain->gPixPerTick()),1,1,1023);
 
}

double QtPartCanvas::gBarLength() {
  return timebar->gBarLength();
}



// ************************************************
//
// QtTimeBar
// =========
//


QtTimeBar::QtTimeBar( QtMain * qtm, QWidget *parent, const char *name )
  : QLabel( parent, name ), qtmain(qtm), pcanvas((QtPartCanvas*)parent)
{
  setBackgroundMode( PaletteMidlight );
  //  int xoffset = pcanvas->gOffset();
  //barSize = qtmain->gBarSize();
  //xbeat = barSize*1.0/qtmain->gMain()->gMeter(0);
  // barlen = 1.0*(1600-18-xoffset)/(1.0*numOfBars);
}

QtPartCanvas * QtTimeBar::gPartCanvas() {
  return pcanvas;
}

void QtTimeBar::paintEvent( QPaintEvent * pe ) {

  master = qtmain->gMain()->Master();
  met0 = qtmain->gMain()->gMeter(0);
  met1 = qtmain->gMain()->gMeter(1);


  QPainter painter;
  painter.begin(this);

  painter.setPen(black);
  double pixPerTick = qtmain->gPixPerTick();
  unsigned long xx;
  int beat;
  int bar;
  int tick;
  int xoffset = pcanvas->gOffset();
  KbPosition pos = 0;
  int xxx = width();
  KbPosition add = KbPosition(1,2,0,master,met0,met1); // one beat!
  char * txt = new char[12];
  bool draw = true;
  bool showNum;
  while (draw) {
    xx = pos.gPosTicks();
    // cout << xx << "-" << met0 << ", " << met1 << ", " << pos.gBeat(master,met0,met1) << endl;
    xx = xx*pixPerTick + xoffset;
    pos.gBBT(bar,beat,tick,master,met0,met1);
    
    if (beat==1) {
      if (pixPerTick>0.0008) painter.drawLine(xx,16,xx,22);
      sprintf(txt,"%d \0",bar);
      showNum = false;
      if (pixPerTick>0.015625) showNum = true;
      else if ((pixPerTick>0.0039) && ( (bar&3)==1 )) showNum = true;
      else if ((pixPerTick>0.0008) &&( (bar&15)==1 )) showNum = true;
      else if ((bar&127)==1) showNum = true;
      if (showNum) painter.drawText(xx+1,12,txt);
      if ((bar&7)==1) painter.drawLine(xx,12,xx,23);
    } else {
      if (pixPerTick>0.015625) painter.drawLine(xx,20,xx,22);
    }

    pos = pos + add;
    if (xx>xxx) draw=false;
  }

  KbPosition leftSel = qtmain->gMain()->gLeftSel();
  KbPosition rightSel = qtmain->gMain()->gRightSel();
  painter.setPen(red);
  xx = leftSel*pixPerTick+xoffset;
  painter.drawLine(xx,1,xx,22);
  painter.fillRect(xx,1,3,3,red);
  xx = rightSel*pixPerTick+xoffset;
  painter.drawLine(xx,1,xx,22);
  painter.fillRect(xx-3,1,3,3,red);

  // if (i*1.0/beats==int(i*1.0/beats)) { sprintf(help,"%d",offBar+1+i); painter.drawText(canvasMarginLeft+xoffset+int(i*barlen)+2,16,help); yy = 8; }
  //painter.drawLine(canvasMarginLeft+int(i*barlen)+xoffset, yy, canvasMarginLeft+int(i*barlen)+xoffset, 22);
  // }
  // painter.drawLine(canvasMarginRight, 8, canvasMarginRight, 22);
  
  painter.end();
  delete[] txt;
  /*
  int xoffset = pcanvas->gOffset();
  int numOfBars = qtmain->gBarNum();
  int offBar = qtmain->gBarOff();
  int leftMargin;
  int leftBar = qtmain->gMain()->gLeftBar();
  int rightMargin;
  int rightBar = qtmain->gMain()->gRightBar();
  int beats = qtmain->gMain()->gMeter(0);
  barlen = 1.0*(width()-18-xoffset)/(1.0*numOfBars);

  QPainter painter;
  painter.begin(this);
  // draw bars and numbers
  int yy;
  char help[12];
  painter.setPen(QPen(QColor("black"),1));
  for (int i=0; i<numOfBars; i++) {
    yy = 18;
    if (i*1.0/beats==int(i*1.0/beats)) { sprintf(help,"%d",offBar+1+i); painter.drawText(canvasMarginLeft+xoffset+int(i*barlen)+2,16,help); yy = 8; }
    painter.drawLine(canvasMarginLeft+int(i*barlen)+xoffset, yy, canvasMarginLeft+int(i*barlen)+xoffset, 22);
  }
  painter.drawLine(canvasMarginRight, 8, canvasMarginRight, 22);

  // draw left and right margin
  leftMargin = int((leftBar-1)*barlen+xoffset);
  rightMargin = int((rightBar-1)*barlen+xoffset);
  painter.setPen(QPen(QColor("red")));
  painter.drawLine(leftMargin+canvasMarginLeft, 2, leftMargin+canvasMarginLeft, 22);
  painter.drawLine(leftMargin+canvasMarginLeft-5, 2, leftMargin+canvasMarginLeft, 2);
  painter.drawLine(rightMargin+canvasMarginLeft, 2, rightMargin+canvasMarginLeft, 22);
  painter.drawLine(rightMargin+canvasMarginLeft, 2, rightMargin+canvasMarginLeft+5, 2);
  
  painter.end();
  */

}

double QtTimeBar::gBarLength() {
  // return barlen;
  return 20;
}



#endif
