#ifndef _QTPARTCANVAS_H_
#define _QTPARTCANVAS_H_

#include "qtMain.h"

class QtTimeBar;
class QtPart;

/**
 * This class covers the part functionality within the main canvas, like moving, editing, deleting parts.
 * @short qt PartCanvas class
 * @author Jan Wuerthner
 * @version 0.95
*/
class QtPartCanvas : public QFrame
{
  Q_OBJECT
private:
  QtMain * qtmain;
  QtTimeBar * timebar;
  int xoffset;
  int mouseX;
  int mouseY;
  QPopupMenu * rbmenu;
  QWidget * line;
  //KbPart * master;
  //int met0;
  //int met1;

public:
  /**
   * Constructor
   * @param qtm remembers the qtMain object
   * @param parent remembers the widget, the part appears within.
   */
  QtPartCanvas( QtMain * qtm, QWidget *parent=0 );

  /**
   * returns the horizontal offset.
   */
  int gOffset();

  /**
   * draws the time position mark in the part canvas
   */
  void drawLine();

  /**
   * returns the position of the time cursor
   */
  int gPos();

  /**
   * returns the length of a bar (refers to timebar)
   */
  double gBarLength();

public slots:

  void mousePressEvent ( QMouseEvent * );


  void mouseDoubleClickEvent( QMouseEvent * );


  void mouseMoveEvent  ( QMouseEvent * );


  void mouseReleaseEvent ( QMouseEvent * );


  void paintEvent ( QPaintEvent * );

  void preferences();

  void deleteSong();

  void scoreEdit();
};

/**
 * This class draws the timebar at the top of the QtPartCanvas
 * @short PartCanvas TimeBar
 * @author Jan Wuerthner
 * @version 0.95
 */
class QtTimeBar : public QLabel
{
  Q_OBJECT
private:
  QtMain * qtmain;
  QtPartCanvas * pcanvas;
  // double barlen;
  //int barSize;
  //int xbeat;
  KbPart * master;
  int met0;
  int met1;

public:
  /// Constructor
  QtTimeBar( QtMain * qtm, QWidget *parent=0, const char *name=0);

  /// returns the part canvas
  QtPartCanvas * gPartCanvas();

  
  double gBarLength();
  int canvasMarginLeft;
  int canvasMarginRight;
public slots:
  void paintEvent( QPaintEvent * pe );
};





#endif
