#ifndef _QTSCORE_C_
#define _QTSCORE_C_

#include "qtScore.h"
#include "qtKeyChooser.h"
#include <qbitmap.h>
#include <qcursor.h>
#include "kbPart.h"
#include "kbNote.h"
#include "kbLyrics.h"
#include "kbTrack.h"
#include "kbScoreTrack.h"
#include "kbExp.h"
#include "kbBow.h"
#include "kbStem.h"
#include "kbAuxElement.h"
#include <math.h>
#include <iostream.h>

#define YTOP 108

enum { ID_OPTIONS_NOTEBAR, ID_OPTIONS_AUTHOR, ID_OPTIONS_AUX, ID_OPTIONS_NEXT, ID_OPTIONS_STN, ID_OPTIONS_SIN, ID_OPTIONS_LYRICS, ID_OPTIONS_VOLUMES };

enum { ID_TOOL_IN, ID_TOOL_ANS, ID_TOOL_AOS };


extern const char * gmNames[];

int sharpTab[] = { 0, 9, -3, 6, 15, 3, 12 }; 
int flatTab[] = { 12, 3, 15, 6, 18, 9, 0 };

int signShift[] = { 0, 6, 0, 0, 0, 6, 6, 12, 0, -6,9,3,-3,0 };

int invFreq[] = { 58, 58, 57, 57, 56, 55, 55, 54, 54, 53, 53, 52, 51, 51, 50, 50, 49, 48, 48, 47, 47, 46, 46, 45, 44, 44, 43, 43, 42, 41, 41, 40, 40, 39, 39, 38, 37, 37, 36, 36, 35, 34, 34, 33, 33, 32, 32, 31, 30, 30, 29, 29, 28, 27, 27, 26, 26, 25, 25, 24, 23, 23, 22, 22, 21, 20, 20, 19, 19, 18, 18, 17, 16, 16, 15, 15, 14, 13, 13, 12, 12, 11, 11, 10, 9, 9, 8, 8, 7, 6, 6, 5, 5, 4, 4, 3, 2, 2, 1 ,1, 0 };
int sign[] = {  0,  1,  0,  1,  0,  0,  1,  0,  1,  0,  1,  0,  0,  1,  0,  1,  0,  0,  1,  0 , 1,  0,  1,  0,  0,  1,  0,  1,  0,  0,  1 , 0,  1,  0,  1,  0,  0,  1,  0,  1,  0,  0,  1,  0 , 1,  0,  1,  0,  0,  1,  0,  1,  0,  0,  1,  0 , 1,  0,  1,  0,  0,  1,  0,  1,  0,  0,  1,  0,  1,  0,  1,  0, 0, 1, 0 ,1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 0, 1 ,0, 1, 0, 0, 1, 0, 1, 0, 1, 0};



int enhF[5][12] = {
  { -1, -1, -1, -2, -1, -1, -1, -1, -1, -1, -2, -1 },
  {  0, -1,  0, -1, -1,  0, -1,  0, -1,  0, -1, -1 },
  {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  {  1,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0 },
  {  1,  1,  1,  0,  1,  1,  1,  1,  0,  1,  0,  1 }
};

int enhS[5][12] = {
  { -2, -1, -2, -2, -1, -2, -1, -2, -1, -2, -2, -1 },
  {  0, -1,  0, -1, -1,  0, -1,  0, -1,  0, -1, -1 },
  {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  {  1,  1,  0,  1,  0,  1,  1,  0,  1,  0,  1,  0 },
  {  1,  2,  2,  1,  2,  1,  2,  2,  1,  2,  1,  2 }
};

int yClef[] = { 0,-12,7,14,-7,-19,-26,-10,-14,-2,-4,-6,-8 };


int noteTab[] = { 'e', 'd', 'c', 'h', 'a', 'g', 'f', 'e', 'd', 'c', 'h', 'a', 'g', 'f', 'e', 'd', 'c', 'h', 'a', 'g', 'f', 'e', 'd', 'c', 'h', 'a', 'g', 'f', 'e', 'd', 'c', 'h', 'a', 'g', 'f', 'e', 'd', 'c' };
int freqTab[] = {100, 98, 96, 95, 93, 91, 89, 88, 86, 84, 83, 81, 79, 77, 76, 74, 72, 71, 69, 67, 65, 64, 62, 60, 59, 57, 55, 53, 52, 50, 48, 47, 45, 43, 41, 40, 38, 36, 35, 33, 31, 29, 28, 26, 24};


int allSigns[15][7] = {
 {-1, -1, -1, -1, -1, -1, -1 },
 {-1, -1, -1, -1, -1, -1,  0 },
 {-1, -1,  0, -1, -1, -1,  0 },
 {-1, -1,  0, -1, -1,  0,  0 },
 {-1,  0,  0, -1, -1,  0,  0 },
 {-1,  0,  0, -1,  0,  0,  0 },
 {0,   0,  0, -1,  0,  0,  0 },
 {0, 0, 0, 0, 0, 0, 0 },
 {0, 0, 0, 0, 0, 0, 1 },
 {0, 0, 1, 0, 0, 0, 1 },
 {0, 0, 1, 0, 0, 1, 1 },
 {0, 1, 1, 0, 0, 1, 1 },
 {0, 1, 1, 0, 1, 1, 1 },
 {1, 1, 1, 0, 1, 1, 1 },
 {1, 1, 1, 1, 1, 1, 1 }
};

enum {
  NS_STACCATO, NS_LEGATO, NS_ACCDOWN, NS_ACCUP, NS_ACCENT1, NS_ACCENT2, NS_ACCENT3, NS_ACCENT4,
  NS_ACCENT5, NS_ACCENT6, NS_ACCENT7, NS_ACCENT8, NS_ACCENT9, NS_ACCENT10, NS_ACCENT11, NS_TRILLER,
  NS_TRILL1, NS_TRILL2, NS_INF, NS_BOWUP, NS_BOWDOWN };

enum {
  AS_LABEL1, AS_LABEL2, AS_LABEL3, AS_CASE1, AS_CASE2, AS_PEDAL1, AS_PEDAL2, AS_NOTEDOT,
  AS_NOTE3, AS_NOTE6, AS_NOTEXX, AS_8VA, AS_15VA, AS_TRILLX, AS_TRILLX2, AS_DECRESCENDO,
  AS_CRESCENDO, AS_BRACKETUP, AS_BRACKETDOWN, AS_ARPEGGIO, AS_TEXT,
  DYN_PPP, DYN_PP, DYN_P, DYN_MP, DYN_MF, DYN_F,
  DYN_FF, DYN_FFF, DYN_SFZ, DYN_SF, DYN_SFF, DYN_FP };


// ******************************************************************
//
// Constructor
// ===========
//


QtScore::QtScore(KbPart * kbpart, bool all)
  : QtEditor("Score",kbpart,"Jan Wrthner", all),
    showIN(TRUE), showTN(FALSE), showLYR(false), showVOL(false), showAUX(false), showNEXT(false), maxNnFlags(4), akkordmin(80), akkordmax(0), akkordmaxOld(0), akkordlen(0), yAux(0), volGrabX1(0), lyrLine(0), extNoteElement(0), auxScoreElement(0), tool(ID_TOOL_IN)
{
  QtEditor::init();
  pixPerTick = 1.0/6;

  if (parts==1) partList[0]=part;

  setBackgroundMode( PaletteLight );

  KIconLoader * loader = kapp->getIconLoader();
  
  QBitmap maske;
  cursorPM = loader->loadIcon( "cnote0.xbm" ); cursorBM[0] = cursorPM; cursor[0] = new QCursor( cursorBM[0], cursorBM[0],5,18);
  cursorPM = loader->loadIcon( "cnote1.xbm" ); cursorBM[1] = cursorPM; cursor[1] = new QCursor( cursorBM[1], cursorBM[1],5,18);
  cursorPM = loader->loadIcon( "cnote2.xbm" ); cursorBM[2] = cursorPM; cursor[2] = new QCursor( cursorBM[2], cursorBM[2],5,18);
  cursorPM = loader->loadIcon( "cnote3.xbm" ); cursorBM[3] = cursorPM; cursor[3] = new QCursor( cursorBM[3], cursorBM[3],5,18);
  cursorPM = loader->loadIcon( "cnote4.xbm" ); cursorBM[4] = cursorPM; cursor[4] = new QCursor( cursorBM[4], cursorBM[4],5,18);
  cursorPM = loader->loadIcon( "cnote5.xbm" ); cursorBM[5] = cursorPM; cursor[5] = new QCursor( cursorBM[5], cursorBM[5],5,18);
  cursorPM = loader->loadIcon( "cnote6.xbm" ); cursorBM[6] = cursorPM; cursor[6] = new QCursor( cursorBM[6], cursorBM[6],5,18);
  cursorPM = loader->loadIcon( "caddns.xbm" ); cursorBM[7] = cursorPM; 
  cursorPM = loader->loadIcon( "caddns1.xbm" ); maske = cursorPM; cursor[7] = new QCursor( cursorBM[7], maske,7,10);
  cursorPM = loader->loadIcon( "caddos.xbm" ); cursorBM[8] = cursorPM;
  cursorPM = loader->loadIcon( "caddos1.xbm" ); maske = cursorPM; cursor[8] = new QCursor( cursorBM[8], maske,7,10);
  
  updateCursor();

  imgNote[0] = loader->loadIcon( "note0.xbm" ); maske = imgNote[0]; imgNote[0].setMask( maske );
  imgNote[1] = loader->loadIcon( "note1.xbm" ); maske = imgNote[1]; imgNote[1].setMask( maske );

  imgSign[0] = loader->loadIcon( "sgnFlat2.xbm" ); maske = imgSign[0]; imgSign[0].setMask( maske );
  imgSign[1] = loader->loadIcon( "sgnFlat.xbm" ); maske = imgSign[1]; imgSign[1].setMask( maske );
  imgSign[2] = loader->loadIcon( "note1.xbm" );
  imgSign[3] = loader->loadIcon( "sgnSharp.xbm" );  maske = imgSign[3]; imgSign[3].setMask( maske );
  imgSign[4] = loader->loadIcon( "sgnSharp2.xbm" );  maske = imgSign[4]; imgSign[4].setMask( maske );
  imgSign[5] = loader->loadIcon( "sgnNat.xbm" );  maske = imgSign[5]; imgSign[5].setMask( maske );

  imgClef[0] = loader->loadIcon( "key0.xbm" ); maske = imgClef[0]; imgClef[0].setMask( maske );
  imgClef[1] = loader->loadIcon( "key1.xbm" ); maske = imgClef[1]; imgClef[1].setMask( maske );
  imgClef[2] = loader->loadIcon( "key2.xbm" ); maske = imgClef[2]; imgClef[2].setMask( maske );
  imgClef[3] = loader->loadIcon( "key3.xbm" ); maske = imgClef[3]; imgClef[3].setMask( maske );
  imgClef[4] = loader->loadIcon( "key4.xbm" ); maske = imgClef[4]; imgClef[4].setMask( maske );
  imgClef[5] = loader->loadIcon( "key5.xbm" ); maske = imgClef[5]; imgClef[5].setMask( maske );
  imgClef[6] = loader->loadIcon( "key6.xbm" ); maske = imgClef[6]; imgClef[6].setMask( maske );
  imgClef[7] = loader->loadIcon( "key7.xbm" ); maske = imgClef[7]; imgClef[7].setMask( maske );
  imgClef[8] = loader->loadIcon( "key8.xbm" ); maske = imgClef[8]; imgClef[8].setMask( maske );
  imgClef[9] = loader->loadIcon( "key9.xbm" ); maske = imgClef[9]; imgClef[9].setMask( maske );
  imgClef[10] = loader->loadIcon( "key10.xbm" ); maske = imgClef[10]; imgClef[10].setMask( maske );
  imgClef[11] = loader->loadIcon( "key11.xbm" ); maske = imgClef[11]; imgClef[11].setMask( maske );
  imgClef[12] = loader->loadIcon( "key12.xbm" ); maske = imgClef[12]; imgClef[12].setMask( maske );
  imgClef[13] = loader->loadIcon( "key13.xbm" ); maske = imgClef[13]; imgClef[13].setMask( maske );
 
  imgFlat  = loader->loadIcon( "sgnFlat.xbm" );  maske = imgFlat; imgFlat.setMask( maske );
  imgSharp = loader->loadIcon( "sgnSharp.xbm" ); maske = imgSharp; imgSharp.setMask( maske );
  
  imgFlag  = loader->loadIcon( "flag.xbm" ); QBitmap BMflag; BMflag = imgFlag; imgFlag.setMask( BMflag );
  imgFlag1 = loader->loadIcon( "flagI.xbm" ); QBitmap BMflag1; BMflag1 = imgFlag1; imgFlag1.setMask( BMflag1 );

  arrBreak[9] = loader->loadIcon( "b1.xbm" ); maske = arrBreak[9]; arrBreak[9].setMask( maske );
  arrBreak[8] = loader->loadIcon( "b2.xbm" ); maske = arrBreak[8]; arrBreak[8].setMask( maske );
  arrBreak[7] = loader->loadIcon( "b4.xbm" ); maske = arrBreak[7]; arrBreak[7].setMask( maske );
  arrBreak[6] = loader->loadIcon( "b8.xbm" ); maske = arrBreak[6]; arrBreak[6].setMask( maske );
  arrBreak[5] = loader->loadIcon( "b16.xbm" ); maske = arrBreak[5]; arrBreak[5].setMask( maske );
  arrBreak[4] = loader->loadIcon( "b32.xbm" ); maske = arrBreak[4]; arrBreak[4].setMask( maske );

  toolBar = new QPopupMenu;
  toolBar->insertItem( klocale->translate("Insert Notes"), ID_TOOL_IN );
  toolBar->insertItem( klocale->translate("Add Note Symbols"), ID_TOOL_ANS );
  toolBar->insertItem( klocale->translate("Add Other Symbols"), ID_TOOL_AOS );
  toolBar->setAccel(ALT+Key_N,ID_TOOL_IN);
  toolBar->setAccel(ALT+Key_A,ID_TOOL_ANS);
  toolBar->setAccel(ALT+Key_S,ID_TOOL_AOS);

  toolBar->setCheckable(true);
  toolBar->setItemChecked(tool, true);
  connect(toolBar,SIGNAL(activated(int)),SLOT(toolMenu(int)));
  menu->insertItem(klocale->translate("Tools"),toolBar);


  buttonbar = new Buttonbar(this);
  // buttonbar->setFrameStyle( QFrame::Panel | QFrame::Raised );
  // buttonbar->setGeometry(0,78,640,22);
  addToolBar(buttonbar);
  buttonbar->show();


  const char * extNoteNames[] = {
    "nsStaccato.xpm", "nsLegato.xpm", "nsAccDown.xpm", "nsAccUp.xpm", "nsAccent1.xpm", "nsAccent2.xpm", "nsAccent3.xpm", "nsAccent4.xpm",
    "nsAccent5.xpm", "nsAccent6.xpm", "nsAccent7.xpm", "nsAccent8.xpm", "nsAccent9.xpm", "nsAccent10.xpm", "nsAccent11.xpm", "nsTriller.xpm",
    "nsTrill1.xpm", "nsTrill2.xpm", "nsInf.xpm", "nsBowUp.xpm", "nsBowDown.xpm" };

  const char * auxScoreNames[] = {
    "asLabel1.xpm", "asLabel2.xpm", "asLabel3.xpm", "asCase1.xpm", "asCase2.xpm", "asPedal1.xpm", "asPedal2.xpm", "asNotedot.xpm",
    "asNote3.xpm", "asNote6.xpm", "asNotexx.xpm", "as8va.xpm", "as15va.xpm", "asTrillX.xpm", "asTrillX2.xpm", "asDecrescendo.xpm",
    "asCrescendo.xpm", "asBracketUp.xpm", "asBracketDown.xpm", "asArpeggio.xpm", "asText.xpm",
    "dynPPP.xpm", "dynPP.xpm", "dynP.xpm", "dynMP.xpm", "dynMF.xpm", "dynF.xpm",
    "dynFF.xpm", "dynFFF.xpm", "dynSFZ.xpm", "dynSF.xpm", "dynSFF.xpm", "dynFP.xpm" };

  noteExt = new KToolBar(this);
  noteExt->setBarPos(KToolBar::Floating);
  noteExt->setFixedSize(8*31,80); // 8x3
  for (int i=0;i<21;i++) {
    noteAccent[i] = loader->loadIcon( extNoteNames[i] );
    noteExt->insertButton(  noteAccent[i], i, TRUE, klocale->translate("-") );
    noteExt->setToggle(i,true);
  }
  noteExt->setButton(extNoteElement,true);
  connect(noteExt,SIGNAL(clicked(int)),SLOT(menuNoteExt(int)));
  addToolBar(noteExt);

  scoreAux = new KToolBar(this);
  scoreAux->setBarPos(KToolBar::Floating);
  scoreAux->setFixedSize(154,210); // 5x7
  for (int i=0;i<33;i++) {
    scoreSymbol[i] = loader->loadIcon( auxScoreNames[i] );
    scoreAux->insertButton( scoreSymbol[i], i, TRUE, klocale->translate("-") );
    scoreAux->setToggle(i,true);
  }
  scoreAux->setButton(auxScoreElement,true);
  connect(scoreAux,SIGNAL(clicked(int)),SLOT(menuScoreAux(int)));
  addToolBar(scoreAux);
}

void QtScore::toolMenu(int i) {
  toolBar->setItemChecked(tool,false);
  tool = i;
  toolBar->setItemChecked(tool,true);
  if (tool==ID_TOOL_ANS)
    if (!showNEXT) optionsMenu(ID_OPTIONS_NEXT);
  if (tool==ID_TOOL_AOS)
    if (!showAUX) optionsMenu(ID_OPTIONS_AUX);
}

void QtScore::menuNoteExt(int i) {
  noteExt->setButton(extNoteElement,false);
  extNoteElement = i;
  noteExt->setButton(extNoteElement,true);
}

void QtScore::menuScoreAux(int i) {
  scoreAux->setButton(auxScoreElement,false);
  auxScoreElement = i;
  scoreAux->setButton(auxScoreElement,true);
}

void QtScore::updateCursor() {
  if (tool==ID_TOOL_IN) setCursor(*cursor[gLenValue()-1]);
  else if (tool==ID_TOOL_ANS) setCursor(*cursor[7]);
  else if (tool==ID_TOOL_AOS) setCursor(*cursor[8]);
}

void QtScore::resizeEvent( QResizeEvent * re ) {
  QtEditor::resizeEvent(re);
  setFixedHeight(parts*(100+yAux)+YTOP);
}

void QtScore::addOptions() {
  options->insertItem( klocale->translate("Show Score Symbol Buttons"), ID_OPTIONS_AUX );
  options->insertItem( klocale->translate("Show Note Symbol Buttons"), ID_OPTIONS_NEXT );
  options->insertSeparator();
  options->insertItem( klocale->translate("Show Tracknames"), ID_OPTIONS_STN );
  options->insertItem( klocale->translate("Show Instrumentnames"), ID_OPTIONS_SIN );
  options->insertSeparator();
  options->insertItem( klocale->translate("Show Lyrics"), ID_OPTIONS_LYRICS );
  options->insertItem( klocale->translate("Show Volumes"), ID_OPTIONS_VOLUMES );
  options->setCheckable(true);
  options->setItemChecked(ID_OPTIONS_SIN,TRUE);
}

void QtScore::addMenuEntries() {

  rbmenu->connectItem( rbmenu->insertItem(klocale->translate("flip stem")), this, SLOT(flipStem()) );
  rbmenu->connectItem( rbmenu->insertItem(klocale->translate("flip bow")), this, SLOT(flipBow()) );
  rbmenu->insertSeparator();
  rbmenu->connectItem( rbmenu->insertItem(klocale->translate("remove symbols")), this, SLOT(removeSymbols()) );
  rbmenu->connectItem( rbmenu->insertItem(klocale->translate("remove bow")), this, SLOT(removeBow()) );
}

void QtScore::removeSymbols() {
  part = partList[selSystem];
  ((KbNote*)selNote)->removeExp();
  selNote = 0; showNoteInfoOff();
}

void QtScore::removeBow() {
  part = partList[selSystem];
  ((KbNote*)selNote)->removeBow();
  selNote = 0; showNoteInfoOff();
}

void QtScore::flipStem() {
  if (selNote) ((KbNote*)selNote)->flipStem();
  selNote = 0; showNoteInfoOff();
}

void QtScore::flipBow() {
  if (selNote) ((KbNote*)selNote)->flipBow();
  selNote = 0; showNoteInfoOff();
}

void QtScore::settings() {
    QtChooser * ch = new QtChooser(part,this);
    ch->show();
}

void QtScore::optionsMenu(int n) {
  QtEditor::optionsMenu(n);
  switch(n) {
  case ID_OPTIONS_AUX:
    if (showAUX) { showAUX = false; options->setItemChecked(ID_OPTIONS_AUX,false); scoreAux->hide(); }
    else { showAUX = true; options->setItemChecked(ID_OPTIONS_AUX,true); scoreAux->show(); }
    break;
  case ID_OPTIONS_NEXT:
    if (showNEXT) { showNEXT = false; options->setItemChecked(ID_OPTIONS_NEXT,false); noteExt->hide(); }
    else { showNEXT = true; options->setItemChecked(ID_OPTIONS_NEXT,true); noteExt->show(); }
    break;
  case ID_OPTIONS_STN:
    if (showTN==TRUE) showTN=FALSE;
    else showTN=TRUE;
    options->setItemChecked(ID_OPTIONS_STN,showTN);
    break;
  case ID_OPTIONS_SIN:
    if (showIN==TRUE) showIN=FALSE;
    else showIN=TRUE;
    options->setItemChecked(ID_OPTIONS_SIN,showIN);
    break;
  case ID_OPTIONS_LYRICS:
    if (showLYR==true) { showLYR=false; yAux = 0; volGrabX1 = 0; }
    else { showLYR = true; showVOL = false; yAux = 20; volGrabX1 = 0; }
    options->setItemChecked(ID_OPTIONS_LYRICS,showLYR);
    options->setItemChecked(ID_OPTIONS_VOLUMES,showVOL);
    setFixedHeight(parts*(100+yAux)+YTOP);
    break;
  case ID_OPTIONS_VOLUMES:
    if (showVOL==true) { showVOL=false; yAux = 0; volGrabX1 = 0; }
    else { showVOL = true; showLYR = false; yAux = 64; volGrabX1 = 0; }
    options->setItemChecked(ID_OPTIONS_LYRICS,showLYR);
    options->setItemChecked(ID_OPTIONS_VOLUMES,showVOL);
    setFixedHeight(parts*(100+yAux)+YTOP);
    break;
  }
}

int QtScore::gEnhValue() {
  return enhValue;
}

void QtScore::sEnhValue(int e) {
  enhValue = e;
}


// *****************************************************************************
//
// PAINT EVENT
// ===========
//

void QtScore::paintEvent( QPaintEvent * pe ) {

  // scorelength = width()-20;
  
  QPixmap pix( width(), height() );
  pix.fill( this, 10,10 );
  QPainter score;
  score.begin( &pix );
  
  for (N=0;N<parts;N++) {
    
    // if (parts>1)
    part = partList[N];
    bool drawme=false;
    
    while (drawme==FALSE) {
      
      scrKey = part->gKey();
      clef = part->gClef();
      
      if (allParts==false) drawme = TRUE; // if single part view, don't care about following parts !!
      else {
	if (part->gLastAtom()!=0 && part->gLastAtom()->gPos()+part->gOffset()>=posLeft) drawme = TRUE;
	else {
	  if (part->gNext()!=0) part = part->gNext(); // DOIT: check
	  else drawme = TRUE;
	}
      }
    }
    
    KbScoreTrack * scTrack = (KbScoreTrack*) part->gTrack();
    
    // ticksPerBar = int(1536.0*time1/time2);

    yoffset = N*(100+yAux) + YTOP;
    nKey     = abs(scrKey);
    xoffset  = 60+6*abs(scrKey);
    xofftime = xoffset-10;
    // int barlen   = (scorelength-xoffset)/barnum;

    sprintf(t1, "%d", part->gTime1()); // DOIT: if master, get masters time1/time2...
    sprintf(t2, "%d", part->gTime2());
    sprintf(t3, "%d", xmOffset+1);
    
    for (int i=0;i<5;i++) {
      y = 40+i*6+yoffset;
      score.drawLine(10,y,width(),y);
    }
    score.drawLine(10,yoffset+40,10,yoffset+65);
    score.drawLine(width(),yoffset+40,width(),yoffset+65);
    score.drawPixmap(26-12,40-8+yoffset,imgClef[clef]); // draw Clef
    
    yytext = 0;
    if (showTN==TRUE) { score.drawText(10,14+yoffset-5,scTrack->gName()); yytext = 10; }
    if (showIN==TRUE) {
      if (scTrack->gProgram()==128) // track inst = "individual", i.e. delegated to parts
	score.drawText(10,14+yoffset+yytext-5,gmNames[part->gProgram()]);
      else 
	score.drawText(10,14+yoffset+yytext-5,gmNames[scTrack->gProgram()]);
    }
    
    score.setFont(QFont("Helvetica",12,QFont::Normal,TRUE));
    score.drawText(xoffset,yoffset+36,t3); // draw bar
    score.setFont(QFont("Helvetica",12,QFont::Bold));
    score.drawText(xofftime,yoffset+51,t1); yytext = 10; // draw measurement
    score.drawText(xofftime,yoffset+63,t2); yytext = 10;
    score.setFont(QFont("Helvetica",12));
    
    for (int i=0; i<nKey; i++) {
      if (scrKey>0) { score.drawPixmap(45+i*6-8,yoffset+40+sharpTab[i]+signShift[clef]-12,imgSharp); // draw sharps
      } else { score.drawPixmap(45+i*6-8,yoffset+40+flatTab[i]+signShift[clef]-2-9,imgFlat);         // draw flats
      }
    }

    // DOIT: for (int i=1; i<barnum; i++) { score.drawLine(xoffset+i*barlen-2, yoffset+40, xoffset+i*barlen-2, yoffset+65); }
    // new version:
    // double pixPerTick = barlen*1.0/1536;
    for (KbPosition pos = KbPosition(0);pos<posRight;) {
      pos.nextBar(master,met0,met1);
      // cout << "- " << pos.gPosTicks() << endl;
      int xxline = xoffset+(pos.gPosTicks()-posLeft.gPosTicks())*pixPerTick-2;
      score.drawLine(xxline,yoffset+40,xxline,yoffset+64);
    }
    
    // draw notes:
    
    // xLeft & xRight def at top of paintEvent
    // score.font().setCharSet(QFont::Latin2);
    freePos = draw(posLeft,posRight,&score);
    
    drawFlags(&score);
    xoffset = 60+6*abs(scrKey);

    leftMet0 = met0; leftMet1 = met1; freePos.gBBT(leftBar,leftBeat,leftTick,master,leftMet0,leftMet1,true);
    KbPosition cp1 = KbPosition(leftBar+1,1,0,master,met0,met1);
    int brk1 = cp1 - freePos.gPosTicks();
    // score.setPen(blue);
    // cout << brk1 << " at " << brkPos << ", ";
    drawBreak(brk1,freePos,yoffset+2,N,&score);
    // score.setPen(green);
    bool bloop=true;
    for (int i = leftBar+1; bloop; i++) {
      brkPos = cp1;
      cp1 = KbPosition(i+1,1,0,master,met0,met1); // cp1 at next bar!
      brk1 = cp1 - brkPos.gPosTicks();
      // cout << brk1 << " at " << brkPos;
      if (brkPos>=posRight) bloop = false;
      else drawBreak(brk1,brkPos,yoffset+2,N,&score);
    }
    

    /*
    // int n=0; // DOIT(old)!!
        
    // barlen = int(1.0*(scorelength-xoffset)/barnum);
    ticksPerBar = 1536; // DOIT!
    // cout << "ticksPB: " << ticksPerBar << endl;
    oldFreePos = freePos;
    freePos = KbPosition(posRight.gBar(master,met0,met1),1,0,master,met0,met1);
    
    KbPosition myLeftBar = KbPosition(xmOffset+1,1,0,master,met0,met1);
      KbPosition bPos = oldFreePos-myLeftBar;
      brk = freePos.gPosTicks()-oldFreePos.gPosTicks();
      int curBar;
      int curBeat;
      int curTick;
      int curMet0 = met0;
      int curMet1 = met1;
      bPos.gBBT(curBar,curBeat,curTick,master,curMet0,curMet1,true);
    timeDelta = int(brk/ticksPerBar)+1;
    
    if (brk>2) {
      brk = brk%ticksPerBar;
      if (brk>2) { drawBreak(brk,oldFreePos,yoffset+2,N,&score); }
      // for (i=1;i<timeDelta;i++) {
      // drawBreak(ticksPerBar,freePos-i*ticksPerBar,yoffset+2,N,&score);
      // }
    }
    cout << bPos << endl;
    */
    
  }
  
  // Line:
  // -----

  if (yAux!=0) {
    // int yline = yoffset + (100+yAux)*1 - yAux; // DOIT: statt 1 eine Schleife!
    // int yline = YTOP+(100+yAux)*1 - yAux;
    // score.drawLine(0,yline,width(),yline);
  }

  // --
  int yline;
  score.setPen(lightGray);
  for (int i=1;i<parts;i++) {
    yline = YTOP+(100+yAux)*i-2;
    score.drawLine(0,yline,width(),yline);
  }

  // Lyrics / Volume:
  // ----------------

  if (yAux!=0) {
    score.setPen(darkYellow);
    score.drawRect(xoffset,YTOP+(100+yAux)*selSystem+100,width()-xoffset-4,yAux-2);
    
    if (volGrabX1!=0)
      score.drawLine(volGrabX1,volGrabY1,volGrabX2,volGrabY2);
  }
  
  // SELECTIONS:
  // -----------

  if (grabX1!=0 && abs(grabX1-grabX2)>5 && volGrabX1==0 && grabNote == 0) { // draw grab rect
    score.setPen(gray);
    score.drawRect(grabX1,16+YTOP+selSystem*(100+yAux),grabX2-grabX1,80);
  }

  score.setPen(red);
  score.drawRect(8,YTOP+selSystem*(100+yAux)+38,4,29);

  score.end();

  //  if (part!=0) { part->print(); } else { cout << "no part !!" << endl; }

  //  sreal.begin(this);
  //  sreal.drawPixmap( myrect.topLeft(), pix );
  bitBlt( this, 0, 0, &pix );
  //sreal.end();

}



void QtScore::drawFlags( QPainter * score )
{
  if (neck==-1) {
    if (yFlag1>16) neck = StemUp;
    else neck = StemDown;
  }
  flagPen = score->pen();
  if (xFlag[0]>0) {
    yFlag1 = yFlag1/nnFlag1;
    // if (yFlag1>16) {
    if (neck==StemUp) {     
      // stem up
      yFlag1 = yFlag1Min-19;
      for (i=0;i<nnFlag1;i++) {
	flagPen.setWidth(0); score->setPen(flagPen);
	score->drawLine(QPoint(xFlag[i]+7,yFlagMax[i]),QPoint(xFlag[i]+7,yFlag1));
	//# anstelle von j=0, vielleicht j=$nFlag1 ?
	//flagPen.setWidth(3); score->setPen(flagPen); // back in for different lengths...
	//for (j=int(nFlag1);j<int(nFlag[i]);j++) {
	//  score->drawLine(QPoint(xFlag[i]+7,yFlag1+j*5),QPoint(xFlag[i]+13,yFlag1+j*5));
        //}
      }
      nnFlag1--;
      xFlag[nnFlag1]++;
      if (nnFlag1>0) {
	flagPen.setWidth(3); score->setPen(flagPen);
	for (i=0;i<int(nFlag1+0.9);i++) {
	  score->drawLine(QPoint(xFlag[0]+7,yFlag1+i*5),QPoint(xFlag[nnFlag1]+7,yFlag1+i*5));
	}
      } else {
	//cout << "nFlag1: " << int(nFlag1) << endl;
	for (i=0;i<int(nFlag1+0.9);i++) {
	  score->drawPixmap(xFlag[0]+9-2,yFlag1+i*5,imgFlag);
	}
      }
    } else {
      // stem down
      yFlag1 = yFlag1Max+19;
      for (i=0;i<nnFlag1;i++) {
	flagPen.setWidth(0); score->setPen(flagPen);
	score->drawLine(QPoint(xFlag[i]-1,yFlagMin[i]),QPoint(xFlag[i]-1,yFlag1));
	//flagPen.setWidth(3); score->setPen(flagPen); // back in for different lengths...
	//for (j=int(nFlag1);j<int(nFlag[i]);j++) {
	//  score->drawLine(QPoint(xFlag[i]-1,yFlag1+j*5),QPoint(xFlag[i]+5,yFlag1+j*5));
	//}
      }
      nnFlag1--;
      xFlag[nnFlag1]++;
      if (nnFlag1>0) {
	flagPen.setWidth(3); score->setPen(flagPen);
	for (i=0;i<int(nFlag1+0.9);i++) {
	  score->drawLine(QPoint(xFlag[0]-1,yFlag1-i*5),QPoint(xFlag[nnFlag1]-1,yFlag1-i*5));
	}
      } else {
	for (i=0;i<int(nFlag1+0.9);i++) {
	  score->drawPixmap(xFlag[0]+2-4,yFlag1-13+i*5,imgFlag1); // +2-4 war +2-3
	}
      }
    }
    xFlag[0] = 0;
    nnFlag1 = 0;
  
    flagPen.setWidth(0); score->setPen(flagPen);
  }
}

void QtScore::drawBreak( int l, KbPosition xx, int yy, int n, QPainter * score )
{
  drawFlags(score);
  triX0 = 0;

  l = l / 3;
  int m0 = met0;
  int m1 = met1;
  int bar; int beat; int tick;
  xx.gBBT(bar,beat,tick,master,m0,m1,true); bar--; beat--;
  int tpbeat = (1536.0/m1) / 3;

  int xxx = int( (tick+beat*1536.0/m1) / 3); // xxx is position in ticks within bar div by 3.
  xxx = xxx >> 2; // after one more shift the 64th-note flag is found on the first bit!
  int compl = 4; // complement = 1/64th note after one more (left-) shift (already div. by 3)
  while (l > 0) {
    xxx = xxx >> 1;
    compl = compl << 1;
    if (xxx==0) {
      for (int i = 0x200; i > 4; i = i >> 1) { // 0x200 equals a whole break
	if (l&i) {
	  drawBreak(i,xx,yy,score,tpbeat);
	  l -= i;
	  xx += 3*i;
	}
      }
      if (l>0) { cout << "PANIC: QtScore: l > 0" << endl; l = 0; }
    } else {
      if (xxx&1) {
	if (compl <= l) drawBreak(compl,xx,yy,score,tpbeat);
	else drawBreak(l,xx,yy,score,tpbeat);
	l -= compl;
	xx += 3*compl;
      }
    }
  }
}

void QtScore::drawBreak(int brk, KbPosition pos, int y, QPainter * score, int tpbeat) {
  // cout << brk << ", " << pos << endl;
  if (colorchan) score->setPen(gray);
  if (brk==512) {
    score->drawPixmap(xoffset+(pos+0.5*1536)*pixPerTick,y+39,arrBreak[9]);
  } else {
    while (brk>0) {
      int myBreak = 0;
      if (brk>tpbeat) myBreak = tpbeat; else myBreak =brk;
      int b=0;
      int bk = myBreak;
      for (b=0;bk>1;b++) bk = bk >> 1;
      if (b>6) score->drawPixmap(xoffset+(pos+0.5*3*myBreak)*pixPerTick,y+39,arrBreak[b]); // for Quarrters, Halfs & Wholes, add half of break to position!
      else score->drawPixmap(xoffset+pos*pixPerTick,y+39,arrBreak[b]);
      brk -= tpbeat;
      pos += 3*tpbeat;
    }
  }
  if (colorchan) score->setPen(black);
}

int QtScore::draw(KbPosition lpos, KbPosition rpos, QPainter * score) {
  // DOIT: posCoef = 1.0*time2/(1536*time1);
  posCoef = 1.0/1536;
  
  // oldTimeBar = 1;
  // curBar = 1;
  curMet0 = met0; curMet1 = met1; lpos.gBBT(curBar,curBeat,curTick,master,curMet0,curMet1,true);

  freePos = 0;
  n = 0;
  scrClef = clef;
  for (i=0;i<7;i++) scrSigns[i]=allSigns[scrKey+7][i];

  yyOld = 0; xxOld = 0; xxCol = 0;
  yFlag1 = 0;
  nFlag1 = 0;
  nnFlag1 = 0;
  xFlag[0] = 0;
  yFlagMax[0] = 0; 
  yFlagMin[0] = 0;
  triX0 = -1;

  KbPosition relPos = 0;

  xoffset = 60+6*abs(scrKey);
  // DOIT: barlen = (scorelength-xoffset)/barnum;
  // KbPosition myLeftBar = KbPosition(xmOffset+1,1,0,master,met0,met1);

  // cout << endl << "start:" << endl << endl;

  // KbPosition myLeftBar = KbPosition(xmOffset+1,1,0,master,met0,met1);
  //  cout << "lpos: " << lpos.gPosTicks() << ", mlb: " << myLeftBar.gPosTicks() << endl;

  KbAtom* atom = part->gFirstAtom();
  while (atom!=0 && atom->gPos()+part->gOffset() < lpos) atom = atom->gNext();
  while (atom!=0 && atom->gPos()+part->gOffset() < rpos) {

    if (atom->isNote()) {

      KbNote * note = (KbNote*) atom;

      freq = note->gFreq();
      pos  = note->gPos()+part->gOffset();
      relPos = pos - lpos;
      len  = note->gLen();
      vel = note->gVel();
      enh = note->gEnh();
      chan = note->gChan();
      stemDir = note->stemDir();
      next = note->gNextNote();
      if (next!=0) { deltapos = next->gPos()-note->gPos().gPosTicks(); } else { deltapos = 1; }
      
      /*
      curMet0 = met0;
      curMet1 = met1;
      oldCurBar = curBar;
      pos.gBBT(curBar,curBeat,curTick,master,curMet0,curMet1,true);
      */

      // --------------------------------------------------------
      
      
      step = freq%12;
      yy  = invFreq[freq];
      sg  = sign[freq];
      if (enh!=0) { yy += enhF[enh+2][step]; sg = enhS[enh+2][step]; }
      
      xx = relPos*pixPerTick +  xoffset + 2;
      
      
      // determine new bar and breaks:
      
      brk = relPos - freePos.gPosTicks();
      brkPos = freePos;
      freePos = relPos + len;
      // now just draw breaks of length "brk" between "brkPos" and "freePos":
      oldTimeBar = curBar;
      leftMet0 = met0; leftMet1 = met1; brkPos.gBBT(leftBar,leftBeat,leftTick,master,leftMet0,leftMet1,true);
      curMet0 = met0; curMet1 = met1; relPos.gBBT(curBar,curBeat,curTick,master,curMet0,curMet1,true);
      if (oldTimeBar!=curBar) { // reset flags at new bar!
	drawFlags(score);
	for (i=0;i<7;i++) scrSigns[i]=allSigns[scrKey+7][i];
      }
      if (brk>2) {
	if (leftBar==curBar) {
	  drawBreak(brk,brkPos,yoffset+2,N,score);
	} else {
	  // cout << "total br: " << brk << ", ";
	  KbPosition cp1 = KbPosition(leftBar+1,1,0,master,met0,met1); // cp1 follows immediately brkPos
	  int brk1 = cp1 - brkPos.gPosTicks();
	  // score->setPen(red);
	  // cout << brk1 << " at " << brkPos << ", ";
	  drawBreak(brk1,brkPos,yoffset+2,N,score);
	  // score->setPen(green);
	  for (int i = leftBar+1; i<curBar; i++) {
	    brkPos = cp1;
	    cp1 = KbPosition(i+1,1,0,master,met0,met1); // cp1 at next bar!
	    brk1 = cp1 - brkPos.gPosTicks();
	    // cout << brk1 << " at " << brkPos;
	    drawBreak(brk1,brkPos,yoffset+2,N,score);
	  }
	  // score->setPen(gray);
	  brkPos = cp1;
	  brk1 = relPos - cp1.gPosTicks();
	  // cout << brk1 << " at " << brkPos << endl;
	  if (brk1<0) cout << "PANIC" << endl;
	  else if (brk1>2) drawBreak(brk1,brkPos,yoffset+2,N,score);
	  // score->setPen(black);
	}
      }
      

      xx += 5;
      
      sgMem = scrSigns[yy%7]; // Vorzeichen
      scrSigns[yy%7] = sg;
      if (sgMem == sg) { sg = 0; } else { if (sg==0) { sg = 3; } }
      if (scrClef!=0) yy += yClef[scrClef]; // change yy when different clef
      
      // if (selNote==note || (selX1!=-1 && selX1 <= pos+part->gOffset() && pos+part->gOffset() <= selX2)) score->setPen(red); // selected Note red !
      if (sg!=0) { score->drawPixmap(xx-11,yy*3+yoffset-10,imgSign[sg+2]); } // draw Vorzeichen DOIT, position right ?!
      
      // cout << "yyOld: " << yyOld << ", yy: " << yy << ", xxOld: " << xxOld << ", xx: " << xx << endl;
      if (xxOld==xx) { if (abs(yyOld-yy)<2) { xxCol = 1-xxCol; xxShft = 8;} else { xxCol = 0; } }
      else { xxCol = 0; xxShft = 0; } // takes care of nearby notes 
      yyOld = yy; xxOld = xx;
      
      if (len>767) { img = imgNote[0]; } else { img = imgNote[1]; } // choose notebody (empty or filled)
      for (i=yy/2; i<6; i++) { score->drawLine(QPoint(xx-3,i*6+yoffset+5),QPoint(xx+9,i*6+yoffset+5)); } // draw Hilfslinien oben
      for (i=(yy-1)/2; i>10; i--) { score->drawLine(QPoint(xx-3,i*6+yoffset+5),QPoint(xx+9,i*6+yoffset+5)); } // ... unten
      
      if ((N==selSystem) && (selNote==note || (selX1!=-1 && selX1 <= pos && pos <= selX2))) score->setPen(red); // COLOR
      else {
	if (colorchan && (chan>-1)) score->setPen(chancolor[chan]);
	else score->setPen(black);
      }
      score->drawPixmap(xx+xxCol*8,yy*3+yoffset-1,img); // draw notebody
      if (yy<=16) xx += xxShft;
      score->setPen(black);
      
      
      if (yy<akkordmin) akkordmin = yy;
      if (yy>akkordmax) akkordmax = yy;
      if (len>akkordlen) akkordlen = len;
      dot = DOT(akkordlen);
      
      if (stemDir!=-1) neck = stemDir;
      else {
	if (akkordmax > 16) neck = StemUp;
	else                neck = StemDown;
      }
      
      if (deltapos!=0) {       // if following note is not at the same (time-) position...
	if (akkordlen<1536) { // if the length of the note/chord is less than 1536 (was ticksPerBar, rsp. a bar, but wrong !!)...
	  if (akkordlen==512 || akkordlen==256 || akkordlen==128 || akkordlen==64 || akkordlen==32 || akkordlen==16) { // triole
	    if (triX0!=-1) {
	      triMem += akkordlen;
	      if (akkordmax > triYmax) triYmax = akkordmax;
	      if (akkordmin < triYmin) triYmin = akkordmin;
	      if (triMem==1536 || triMem ==768 || triMem==384 || triMem==192 || triMem==96 || triMem==48) { // triolen zuende, 3 malen
		triDX = (xx+triX0)/2;
		if (akkordmax>16) score->drawText(triDX+3,3*triYmin-25+yoffset,"3"); // haelse nach oben
		else score->drawText(triDX-3,3*triYmax+35+yoffset,"3"); // haelse nach unten
		triX0 = -1;
	      }
	    } else { triX0 = xx; triYmin = akkordmin; triYmax = akkordmax; triMem = akkordlen; drawFlags(score); }
	  } else { triX0 = -1; }
	  if (stemDir!=-1) {
	    if ((nnFlag1>0) && (yFlag1/nnFlag1>16) && (stemDir==StemDown)) drawFlags(score);
	    if ((nnFlag1>0) && (yFlag1/nnFlag1<=16) && (stemDir==StemUp)) drawFlags(score);
	  }
	  if (abs(akkordmaxOld-akkordmax)>7) {
	    drawFlags(score);
	  }
	  akkordmaxOld = akkordmax;                  // memory: If diff in y is too large (>7), draw ! (s.a.)
	  cl =  10-log(akkordlen/3)/log(2)-3;        // cl>0, if flags occur: 1 = 1/8, 2 = 1/16, 3 = 1/32, etc
	  if (cl!=nFlag1) { drawFlags(score); }      // nFlag1 is the former cl: If difference: draw!
	  if (cl>0) {                                // if flags occur...
	    if (xFlag[0]==0) {                       // xFlag is where the first(left most) flag occurs
	      xFlag[0]  = xx;                        // remember first x-pos
	      yFlag1Min = 3*akkordmin+2+yoffset;     // top y-pos of chord so far
	      yFlag1Max = 3*akkordmax+2+yoffset;     // bottom y-pos of chord so far
	      yFlagMax[0] = yFlag1Max;               // will be remembered
	      yFlagMin[0] = yFlag1Min;               // dito
	      nnFlag1   = 1;                         // nnFlag1 points to the next free space in the array
	      nFlag1    = cl;                        // number of flags
	      nFlag[0]  = cl;                        // will be remembered
	      yFlag1    = (akkordmax+akkordmin)/2;   // y center of chord
	    } else { 
	      xFlag[nnFlag1] = xx;                       // remember current x-pos
	      yyyMin    = 3*akkordmin+2+yoffset;         // top y-pos of chord so far
	      yyyMax    = 3*akkordmax+2+yoffset;         // bottom y-pos of chord so far
	      if (yFlag1Min>yyyMin) yFlag1Min = yyyMin;  // yFlag1Min holds the y minimum
	      if (yFlag1Max<yyyMax) yFlag1Max = yyyMax;  // yFlag1Max holds the y maximum
	      yFlagMax[nnFlag1] = yyyMax;                // will be remembered
	      yFlagMin[nnFlag1] = yyyMin;
	      nFlag[nnFlag1]    = cl;
	      if (cl<nFlag1) nFlag1 = cl;                // if difference, nFlag1 is maximum length
	      nnFlag1++;
	      yFlag1 += (akkordmax+akkordmin)/2;         // add center to yFlag1 in order to avarage later on
	    }
	  } else {
	    // cout << neck << endl;
	    if (neck==StemUp) {
	      flag = 3*akkordmin-19;
	      score->drawLine( xx+7, flag+yoffset, xx+7, 3*akkordmax+1+yoffset ); // draw line to the right, up
	    } else {
	      flag = 3*akkordmax+19;
	      score->drawLine( xx-1, flag+yoffset, xx-1, 3*akkordmin+1+yoffset ); // draw line to the left, down
	    }
	  }
	  if ((cl<1)||(nnFlag1>maxNnFlags-1)) { drawFlags(score); }
	  
	} else {
	  // # akkordlen>1536 !!
	}
	
	akkordmin = 80;
	akkordmax = 0;
	akkordlen = 0 ;
      }
      
      for (i=0;i<dot;i++) {
	score->drawText(xx+10+5*i,yy*3+yoffset,".");
      }
      
      // velocity ?
      if (showVOL==true) {
	score->drawRect(xx+xxCol*8,yoffset+155,3,-vel/3);
      } else if (showLYR==true) {
	KbLyrics * lyr = note->lyrics();
	if (lyr) score->drawText(xx+xxCol*8,yoffset+114,lyr->gText());
      }
      
      // expressions ?
      KbExp * expr = note->gExp();
      while (expr) {
	score->drawPixmap(xx+xxCol*8-5,yoffset+3*yy+expr->gOffset(),noteAccent[expr->gExpression()]);
	expr = note->gExp(expr);
      }
      // bow ?
      KbBow * bow = note->gBow();
      if (bow) {
	int bowlen = bow->gLength();
	int drc = -1; if (bow->isDown()) drc = 1;
	int x1 = xx+xxCol*8;
	int y1 = yoffset+3*yy + drc*8;
	int dx = bowlen*pixPerTick/3;
	int dy = bowlen*pixPerTick/12 * drc;
	int ddy = bow->gDelta()/3;

	// cout << bowlen << ", " << drc << ", " << ddy << endl;
	QPointArray aa( 4 );
	aa.setPoint( 0, x1+4, y1 );
	aa.setPoint( 1, x1+dx, y1+dy + ddy );
	aa.setPoint( 2, x1+2*dx, y1+dy + 2*ddy );
	aa.setPoint( 3, x1+3*dx, y1 + 3*ddy );
	score->drawQuadBezier(aa);
	aa.setPoint( 1, x1+dx, y1+dy+1 + ddy );
	aa.setPoint( 2,x1+2*dx, y1+dy+1 + 2*ddy );
	score->drawQuadBezier(aa);
      }
      
      // --------------------------------------------------------
      
      // if (selNote==note || (selX1!=-1 && selX1 <= pos && pos <= selX2)) score->setPen(black);
      // note = note->gNextNote();
    } else if (atom->isAuxElement()) {
      pos = atom->gPos() + part->gOffset();
      KbPosition myLeftBar = KbPosition(xmOffset+1,1,0,master,met0,met1);
      xx = (pos-myLeftBar)*pixPerTick +  xoffset + 2;
      
      if (((KbAuxElement*)atom)->isAuxText()) score->drawText(xx, yoffset + ((KbText*)atom)->gOffset(), ((KbText*)atom)->gText());
      else if (((KbAuxElement*)atom)->isAuxSymbol()) score->drawPixmap(xx, yoffset + ((KbSymbol*)atom)->gOffset() - 9, scoreSymbol[((KbSymbol*)atom)->gSymbol()]);
      else { // parameterized score symbol!
	KbParSymbol * sym = (KbParSymbol*) atom;
	int yy = yoffset + sym->gOffset();
	int par = sym->gParameter()*pixPerTick;
	switch (sym->gSymbol()) {
	case AS_DECRESCENDO:
	  score->drawLine(xx,yy-3,xx+par,yy);
	  score->drawLine(xx,yy+3,xx+par,yy);
	  break;
	case AS_CRESCENDO:
	  score->drawLine(xx,yy,xx+par,yy-3);
	  score->drawLine(xx,yy,xx+par,yy+3);
	  break;
	case AS_8VA:
	  score->drawPixmap(xx, yy - 9, scoreSymbol[sym->gSymbol()]);
	  if (par>20) { score->setPen(DotLine); score->drawLine(xx+20, yy-5, xx+par, yy-5); score->setPen(SolidLine); }
	  break;
	case AS_15VA:
	  score->drawPixmap(xx, yy - 9, scoreSymbol[sym->gSymbol()]);
	  if (par>20) { score->setPen(DotLine); score->drawLine(xx+20, yy-5, xx+par, yy-5); score->setPen(SolidLine); }
	  break;
	case AS_TRILLX:
	  score->drawPixmap(xx, yy - 9, scoreSymbol[sym->gSymbol()]);
	  if (par>20) {
	    for (int i=0;int(i/20)<int(par/20);i += 20)
	      score->drawPixmap(xx+20+i, yy - 10, scoreSymbol[AS_TRILLX2]);
	  }
	  break;
	case AS_TRILLX2:
	  score->drawPixmap(xx, yy - 9, scoreSymbol[AS_TRILLX2]);
	  for (int i=0;int(i/20)<int(par/20);i += 20)
	    score->drawPixmap(xx+20+i, yy - 9, scoreSymbol[AS_TRILLX2]);
	  break;
	}
      }
    }

    atom = atom->gNext();
    
    if (allParts==TRUE && atom==0 && part->gNext()!=0) { // to the following part ;-)
      drawFlags(score);
      part = part->gNext();
      atom = part->gFirstAtom();
      scrKey = part->gKey();
      clef = part->gClef();
    }
      
  }
  return freePos.gPosTicks();
}


int QtScore::DOT( int l ) {

  x0 = int(1.000000001 * log(l/3)/log(2)); l = l-3*int(pow(2,x0));
  if (l<3) l = 3;
  x1 = int(1.000000001 * log(l/3)/log(2)); l = l-3*int(pow(2,x1));
  if (l<3) l = 3;
  x2 = int(1.000000001 * log(l/3)/log(2)); l = l-3*int(pow(2,x2));
  return (x0-x1==1)+(x1-x2==1);

}


// *****************************************************************************
//
// SLOTS
// =====
//


void QtScore::mousePressEvent ( QMouseEvent * mouse ) {
  QtEditor::mousePressEvent(mouse);

 if (mouse->button()==LeftButton) {
   part = partList[selSystem];

   if (tool == ID_TOOL_ANS) {
     noteExp = 0;
     noteBow = 0;
     KbPosition pos = mouseDownPos.gPosTicks() - (mouseDownPos.gPosTicks()%snapValue) - part->gOffset();
     getGrabNote(pos,Pitch(mouseDownY));
     if (grabNote) {
       if ((extNoteElement==NS_BOWDOWN)||(extNoteElement==NS_BOWUP)) { // Bow
	 int blen = 0;
	 KbNote * n = (KbNote*)grabNote;
	 while ((blen==0)&&(n->gNextNote()!=0)) {
	   n = n->gNextNote();
	   blen = int(n->gPos().gPosTicks() - grabNote->gPos().gPosTicks());
	 }
	 if (blen==0) blen = 384;
	 int dir = BowUp; if (extNoteElement==NS_BOWDOWN) dir = BowDown;
	 int delta = 0;
	 if (n) delta = (n->gFreq() - ((KbNote*)grabNote)->gFreq())*3;
	 if (grabNote&&grabNote->isNote()) noteBow = ((KbNote*)grabNote)->giveBow(blen,dir,delta);

       } else { // Accent
	 if (grabNote&&grabNote->isNote()) noteExp = ((KbNote*)grabNote)->giveExp(extNoteElement); // assures that noteExp exists!
       }
     }
     grabNote = 0;
     grabX1 = 0;

   } else if (tool == ID_TOOL_AOS) {
     auxEl = 0;

     KbPosition pos = mouseDownPos.gPosTicks() - (mouseDownPos.gPosTicks()%snapValue) - part->gOffset();
     int scoreY = ((mouseY-YTOP) % (100+yAux));
     int scoreTopLine = 12;
     int scoreBottomLine = 84;
     int offset = 0;
     switch (auxScoreElement) {
     case AS_LABEL1: auxEl = part->giveAux(pos,auxScoreElement,scoreTopLine); break;
     case AS_LABEL2: auxEl = part->giveAux(pos,auxScoreElement,scoreTopLine); break;
     case AS_LABEL3: auxEl = part->giveAux(pos,auxScoreElement,scoreTopLine); break;
     case AS_CASE1: auxEl = part->giveAux(pos,auxScoreElement,scoreTopLine); break;
     case AS_CASE2: auxEl = part->giveAux(pos,auxScoreElement,scoreTopLine); break;
     case AS_PEDAL1: auxEl = part->giveAux(pos,auxScoreElement,scoreBottomLine); break;
     case AS_PEDAL2: auxEl = part->giveAux(pos,auxScoreElement,scoreBottomLine); break;
     case AS_NOTEDOT: auxEl = part->giveAux(pos,auxScoreElement,scoreTopLine); break;
     case AS_NOTE3: auxEl = part->giveAux(pos,auxScoreElement,scoreTopLine); break;
     case AS_NOTE6: auxEl = part->giveAux(pos,auxScoreElement,scoreTopLine); break;
     case AS_NOTEXX: auxEl = part->giveAux(pos,auxScoreElement,scoreTopLine,0); break;
     case AS_8VA: auxEl = part->giveAux(pos,auxScoreElement,scoreTopLine,0); break;
     case AS_15VA: auxEl = part->giveAux(pos,auxScoreElement,scoreTopLine,0); break;
     case AS_TRILLX: auxEl = part->giveAux(pos,auxScoreElement,scoreY,384); break;
     case AS_TRILLX2: auxEl = part->giveAux(pos,auxScoreElement,scoreY,384); break;
     case AS_DECRESCENDO: auxEl = part->giveAux(pos,auxScoreElement,scoreY,192); break;
     case AS_CRESCENDO: auxEl = part->giveAux(pos,auxScoreElement,scoreY,192); break;
     case AS_BRACKETUP: auxEl = part->giveAux(pos,auxScoreElement,scoreY,768); break;
     case AS_BRACKETDOWN: auxEl = part->giveAux(pos,auxScoreElement,scoreY,768); break;
     case AS_ARPEGGIO: auxEl = part->giveAux(pos,auxScoreElement,scoreY,32); break;
     case AS_TEXT: // auxEl = part->giveAux(pos,auxScoreElement,score);
       break;
     case DYN_PPP: auxEl = part->giveAux(pos,auxScoreElement,scoreY); break;
     case DYN_PP: auxEl = part->giveAux(pos,auxScoreElement,scoreY); break;
     case DYN_P: auxEl = part->giveAux(pos,auxScoreElement,scoreY); break;
     case DYN_MP: auxEl = part->giveAux(pos,auxScoreElement,scoreY); break;
     case DYN_MF: auxEl = part->giveAux(pos,auxScoreElement,scoreY); break;
     case DYN_F: auxEl = part->giveAux(pos,auxScoreElement,scoreY); break;
     case DYN_FF: auxEl = part->giveAux(pos,auxScoreElement,scoreY); break;
     case DYN_FFF: auxEl = part->giveAux(pos,auxScoreElement,scoreY); break;
     case DYN_SFZ: auxEl = part->giveAux(pos,auxScoreElement,scoreY); break;
     case DYN_SF: auxEl = part->giveAux(pos,auxScoreElement,scoreY); break;
     case DYN_SFF: auxEl = part->giveAux(pos,auxScoreElement,scoreY); break;
     case DYN_FP: auxEl = part->giveAux(pos,auxScoreElement,scoreY); break;
     }

     grabNote = 0;
     grabX1 = 0;
   }
 }

 if ((mouseY>YTOP+(1+selSystem)*(100+yAux)-yAux)&&(mouseY<YTOP+(1+selSystem)*(100+yAux))&&(showVOL)) {
   volGrabX1 = mouseX; volGrabY1 = mouseY;
   volGrabX2 = volGrabX1; volGrabY2 = volGrabY1;
   ySysGrab = ((mouseY-YTOP) % (100+yAux));
 }
 
}


void QtScore::mouseMoveEvent  ( QMouseEvent * mouse ) {
  QtEditor::mouseMoveEvent(mouse);

  // cout << grabX1 << endl;

  if ((mouseY>YTOP+(1+selSystem)*(100+yAux)-yAux)&&(mouseY<YTOP+(1+selSystem)*(100+yAux))) {
    if (showLYR) setCursor(QCursor(4));
    if (showVOL) { setCursor(QCursor(2)); if (volGrabX1!=0) { volGrabX2 = mouseX; volGrabY2 = mouseY; repaint(false); } }
  } else {
    part = partList[selSystem];
    pos = mousePos.gPosTicks() - (mousePos.gPosTicks()%snapValue) - part->gOffset();

    scrKey = part->gKey();
    xoffset  = 60+6*abs(scrKey);
    if (mouseX<=20) setCursor(QCursor(1));
    else if ((mouseX>20) && (mouseX<=xoffset)) setCursor(QCursor(0));
    else {
      buttonbar->setPos(pos.gBar(master,met0,met1),pos.gBeat(master,met0,met1),pos.gTicks(master,met0,met1));
      showFreq();
      updateCursor();
      if (grabNote) {
	grabNote->sPos(pos);
	repaint(FALSE);
      }
    }
    
    if (tool==ID_TOOL_IN) {
      if (grabX1!=0) repaint(FALSE);

    } else if (tool==ID_TOOL_ANS) {
      int scoreY = ((mouseY-YTOP) % (100+yAux));

      if (noteExp) noteExp->sOffset(mouseY-mouseDownY);
      if (noteBow) {
	noteBow->sLength((mouseX-mouseDownX)*1.0/pixPerTick);
	noteBow->sDelta(mouseY-mouseDownY);
      }
      grabX1 = 0;
      repaint(FALSE);

    } else if (tool==ID_TOOL_AOS) {
      int scoreY = ((mouseY-YTOP) % (100+yAux));
      
      if (auxEl) {
	if (auxEl->isAuxSymbol()) ((KbSymbol*)auxEl)->sOffset(scoreY);
	else if (auxEl->isAuxParSymbol()) {
	  ((KbParSymbol*)auxEl)->sOffset(scoreY);
	  ((KbParSymbol*)auxEl)->sParameter((mouseX-mouseDownX)*1.0/pixPerTick);
	}
      }
      grabX1 = 0;
      repaint(FALSE);
    }

  }
}


void QtScore::mouseReleaseEvent ( QMouseEvent * mouse ) {
  QtEditor::mouseReleaseEvent(mouse);

  int yOff = mouseRelY-YTOP;
  int ySys = (yOff % (100+yAux));
  int system = (yOff-ySys)/(100+yAux);

  selSystem = system; if (selSystem>=parts) selSystem = 0;
  part = partList[selSystem];
  freq = Pitch(mouseRelY);
  
  if (mouseRelX < xoffset) {
    if (mouseRelX > 15) {
      QtChooser * ch = new QtChooser(part,this);
      ch->show();
    }
  } else {
    pos = mouseRelPos.gPosTicks() - (mouseRelPos.gPosTicks()%snapValue) - part->gOffset();

    if (tool==ID_TOOL_IN) {

      if (grabNote) {
	
      } else {
	if (createNote) {
	  if ((mouseRelY>YTOP+(1+selSystem)*(100+yAux)-yAux)&&(mouseY<YTOP+(1+selSystem)*(100+yAux))) {
	    if (showLYR) { // LYRICS
	      part = partList[selSystem];
	      // pos = mouseRelPos;
	      KbNote * n = 0;
	      KbLyrics * l = 0;
	      unsigned long newLyrPos = -1;
	      // cout << pos.gPosTicks() << endl;
	      for (n = part->gFirstNote(); n!=0 && (n->gPos()+part->gOffset()!=pos); n = (KbNote*)n->gNextNote()) { }
	      if (n!=0) { // ok
		KbLyrics * lyr = n->lyrics();
		createLyrics(n,xoffset+(n->gPos()+part->gOffset())*pixPerTick,YTOP+(selSystem+1)*(100+yAux)-18);
	      }
	    }
	  } else {
	    int llen = ticksOfLen(lenValue);
	    if (mouse->button()==LeftButton) {
	      if (freq!=0) {
		int myEnh = enhValue;
		if (shftFlag && (!ctrlFlag) && myEnh<2) myEnh++; // if SHIFT is pressed, increase enh-mode by one only for this note to create...
		if (ctrlFlag && (!shftFlag) && myEnh>-2) myEnh--;
		part->addNote(new KbNote(freq,velocValue,llen,pos,myEnh));
		grabX1=0; // if a note is created, no selection-frame should be displayed
		if (speaker) main->hit(((KbScoreTrack*)part->gTrack())->gOutput(),((KbScoreTrack*)part->gTrack())->gChannel(),freq,velocValue);
	      }
	    }
	  }
	} else { // SELECTION

	}
	
	if ((mouseRelY>YTOP+(1+selSystem)*(100+yAux)-yAux)&&(mouseY<YTOP+(1+selSystem)*(100+yAux))) {
	  
	  if (showVOL) {// VOLUME
	    int ybottom = YTOP+(1+selSystem)*(100+yAux)-yAux;
	    int yAux = 60;
	    KbNote * n = 0;
	    KbNote * m = 0;
	    KbPosition p = KbPosition((volGrabX1-xoffset)*1.0/pixPerTick) + posLeft;
	    for (n = part->gFirstNote(); n!=0 && (n->gPos()+part->gOffset()<p); n = (KbNote*)n->gNextNote()) {}
	    if (n!=0) {
	      p = KbPosition((volGrabX2-xoffset)*1.0/pixPerTick) + posLeft;
	      for (m = n; m!=0 && (m->gPos()+part->gOffset()<p); m = (KbNote*)m->gNextNote()) {}
	      if (m!=0) { // range is now: [n,m]
		//cout << *n << endl << *m << endl;
		int ry1 = 100+yAux-ySysGrab;
		int ry2 = 100+yAux- ((mouseRelY-YTOP) % (100+yAux));
		int deltax = (m->gPos().gPosTicks()-n->gPos().gPosTicks());
		int deltay = (ry2-ry1)*3.0;
		// cout << "yGrab: " << ySysGrab << " : " << ry1 << ", " << ry2 << endl;
		double slope = deltay*1.0/deltax;
		//cout << "slope: " << slope << endl;
		for (KbNote * note = n; note!=m; note = note->gNextNote())
		  note->sVel(3*ry1+int(slope*(note->gPos().gPosTicks()-n->gPos().gPosTicks())));
	      }
	    }
	    volGrabX1 = 0;
	    }
	}
	
      }
    } else if (tool==ID_TOOL_ANS) {
      // extNoteElement
      grabX1 = 0;
      noteExp = 0;
      noteBow = 0;
      grabNote = 0;
      selX1 = -1;
      enableSelItems(false);
    } else if (tool==ID_TOOL_AOS) {
      // auxScoreElement
      grabX1 = 0;
      auxEl = 0;
      selX1 = -1;
      enableSelItems(false);
    }
  }

  if (mouse->button()==RightButton) {
    mouseDownX = 0;
    grabX1 = 0;
  }
  volGrabX1 = 0;
  repaint( FALSE );
  
}

void QtScore::showFreq() {

  yOff = mouseY-YTOP;
  yy = (yOff % (100+yAux));
  system = (yOff-yy)/(100+yAux);
  
  if (system<parts) { 
    if (partList[system]->gClef()!=0) yy -= 3*yClef[partList[system]->gClef()];
    yy = yy/3;
    if (yy>=0 && yy<=37) {
      
      char ff = noteTab[yy];
      buttonbar->setFreq(ff,(int)6-(yy+4)/7,shftFlag,ctrlFlag);
    }
  }
}

int QtScore::Pitch(int y) {
  part = partList[selSystem];
  scrKey = part->gKey();
  xoffset  = 60+6*abs(scrKey);

  int yOff = y-YTOP;
  int ySys = (yOff % (100+yAux));
  int system = (yOff-ySys)/(100+yAux);
  selSystem = system; if (selSystem>=parts) selSystem = 0;
  part = partList[selSystem];
  int yy = ySys/3;
  int myEnh = 0;
  clef = part->gClef();
  
  int freq = 0;

  if (yy>0 && yy<=31 && selSystem<parts) {
    if (clef!=0) yy -= yClef[clef];
    freq = freqTab[yy];
    if (shftFlag && (!ctrlFlag)) freq++;
    if (ctrlFlag && (!shftFlag)) freq--;
  } else {
    freq = -1;
  }
  return freq;
}


void QtScore::createLyrics(KbNote * note, int x, int y) {
  lyrLine = new QLineEdit(this,"-");
  lyrLine->setGeometry(x,y,30,14);
  // cout << "lyr: " << x << ", " << y << " : " << pos << endl << *note << endl;
  lyricsNote = note;
  // lyricsPart = part;
  oldLyr = note->lyrics();
  if (oldLyr) lyrLine->setText(oldLyr->gText());
  lyrLine->show();
  lyrLine->setActiveWindow();
  lyrLine->setFocus();
  connect(lyrLine,SIGNAL(returnPressed()),SLOT(setLyrics()));
}

void QtScore::setLyrics() {
  if (lyricsNote!=0) {
    if (oldLyr) oldLyr->sText((char*)lyrLine->text());
    else lyricsNote->appendExt( new KbLyrics(lyricsNote,(char*)(strdup((char*)lyrLine->text()))) );
  }
  if (lyrLine!=0) delete lyrLine;
  lyrLine = 0;
  repaint(FALSE);
}

void QtScore::keyPressEvent ( QKeyEvent * key ) {
  switch( key->key() ) {
  case Key_Left:
    getPartInfo();
    if (selNote==0) {
      part->sCur(part->gLastAtom()); selNote = part->gCurAtom(); showNoteInfo();
    } else {
      part->sCur(selNote);
      if (part->leftNote()==true) { selNote = 0; showNoteInfoOff(); }
      else { selNote = part->gCurAtom(); showNoteInfo(); }
    }
    if (selNote!=0) {
      if (speaker) main->hit(((KbScoreTrack*)part->gTrack())->gOutput(),((KbScoreTrack*)part->gTrack())->gChannel(),((KbNote*)selNote)->gFreq(),((KbNote*)selNote)->gVel());
    }
    break;
  case Key_Right:
    getPartInfo();
    if (selNote==0) {
      part->sCur(part->gFirstAtom()); selNote = part->gCurAtom(); showNoteInfo();
    }
    else {
      part->sCur(selNote);
      if (part->rightNote()==true) { selNote = 0; showNoteInfoOff(); }
      else { selNote = part->gCurAtom(); showNoteInfo(); }
    }
    if (selNote!=0) {
      if (speaker) main->hit(((KbScoreTrack*)part->gTrack())->gOutput(),((KbScoreTrack*)part->gTrack())->gChannel(),((KbNote*)selNote)->gFreq(),((KbNote*)selNote)->gVel());
    }
  break;
  default:
    QtEditor::keyPressEvent(key);
    break;
  }
  repaint(FALSE);
}


void QtScore::keyReleaseEvent ( QKeyEvent * key ) {
  QtEditor::keyReleaseEvent(key);

}




#endif
