#ifndef _QTSCORE_H_
#define _QTSCORE_H_

#include "qtEditor.h"
#include "qtScoreButtons.h"
#include "kbPosition.h"

class KbNote;
class KbLyrics;
class KbExp;
class KbBow;
class KbAuxElement;
class QtChooser;
class QBitmap;
class QLineEdit;

/**
 * This is the qt implementation of the score editor.
 * @author Jan Wuerthner
 * @version 0.95
 */ 
class QtScore : public QtEditor
{
  friend QtChooser;

  Q_OBJECT
 private:
  QPopupMenu * toolBar;
  QPixmap imgClef[15];
  QPixmap arrBreak[10];
  QPixmap imgNote[2];
  QPixmap imgSign[6];
  QPixmap imgFlat;
  QPixmap imgSharp;
  QPixmap imgFlag;
  QPixmap imgFlag1;
  QPixmap noteAccent[21];
  QPixmap scoreSymbol[33];
  QPixmap cursorPM;
  QBitmap cursorBM[9];
  QCursor * cursor[9];
  Buttonbar * buttonbar;
  KToolBar * scoreAux;
  KToolBar * noteExt;
  QLineEdit * lyrLine;
  int extNoteElement;
  int auxScoreElement;
  KbNote * extNote;
  int extNoteParameter;
  KbExp * noteExp;
  KbBow * noteBow;
  KbAuxElement * auxEl;

  int tool;
  int yAux;
  int enhValue;
  int yytext;
  bool showIN;
  bool showTN;
  bool showLYR;
  bool showVOL;
  KbNote * lyricsNote;
  KbPart * lyricsPart;
  int N;
  int scrKey;
  int scrSigns[8];
  int clef;
  int nKey;
  int xofftime;
  char t1[5];
  char t2[5];
  char t3[5];
  int y;
  KbPosition freePos;
  KbPosition brkPos;
  // KbPosition oldFreePos;
  int ticksPerBar;
  int brk;
  int timeDelta;
  int xb;
  int system;
  int yOff;
  int ySys;
  int ySysGrab;

  // KbPosition xLeft;
  // KbPosition xRight;
  int oldCurBar;
  int curBar;
  int curBeat;
  int curTick;
  int curMet0;
  int curMet1;
  int leftBar;
  int leftBeat;
  int leftTick;
  int leftMet0;
  int leftMet1;

  double posCoef;
  int oldTimeBar;
  int n;
  int scrClef;
  int i;
  int j;
  int k;
  int yyOld;
  int xxOld;
  int xxCol;
  int yFlag1;
  double nFlag[24];
  double nFlag1;
  int nnFlag1;
  int xFlag[24];
  int yFlagMax[24];
  int yFlag1Max;
  int yFlagMin[24];
  int yFlag1Min;
  int yyyMin;
  int yyyMax;
  int flag;
  int maxNnFlags;
  int triX0;
  int scorelength;
  int freq;
  int oldfreq;
  int vel;
  int len;
  int enh;
  int chan;
  int stemDir;
  KbNote * next;
  double deltapos;
  int step;
  int yy;
  int sg;
  int xx;
  int sgMem;
  int xxShft;
  QPixmap img;
  int akkordmin;
  int akkordmax;
  int akkordmaxOld;
  int akkordlen;
  int dot;
  int triMem;
  int triYmax;
  int triYmin;
  int triDX;
  double cl;
 
  int x0; int x1; int x2;
  QPen flagPen;
  int neck;

  double xBrk[5];
  double llBrk[5];
  int bb;
  // int x0; int x1; int x2;
  int volGrabX1;
  int volGrabX2;
  int volGrabY1;
  int volGrabY2;
  KbLyrics * oldLyr;
  bool showAUX;
  bool showNEXT;

  void drawFlags(QPainter*);
  void drawBreak(int,KbPosition,int,int,QPainter*);
  void drawBreak(int,KbPosition,int,QPainter*,int);
  int draw(KbPosition,KbPosition,QPainter*);
  int DOT(int);
  virtual void showFreq();
  virtual int Pitch(int);

  void createLyrics(KbNote*,int,int);

 public:
  QtScore(KbPart * kbpart, bool all=false);
  int gEnhValue();
  void sEnhValue(int e);
  void updateCursor();

  virtual void addOptions();
  virtual void addMenuEntries();
  virtual void settings();
  virtual void paintEvent( QPaintEvent * );

 public slots:
  virtual void optionsMenu(int);
  virtual void mousePressEvent ( QMouseEvent * );
  virtual void mouseMoveEvent  ( QMouseEvent * );
  virtual void mouseReleaseEvent ( QMouseEvent * );
  virtual void keyPressEvent ( QKeyEvent * );
  virtual void keyReleaseEvent ( QKeyEvent * );
  void menuNoteExt(int);
  void menuScoreAux(int);
  void setLyrics();
  void toolMenu(int);
  void removeSymbols();
  void removeBow();
  void flipStem();
  void flipBow();
 /**
  * resize event
  */
 virtual void resizeEvent( QResizeEvent * );
};

#endif
