    /*

    Copyright (C) 1998 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#include "artsobject.h"
#include "artsorb.h"
#include "debug.h"

long ArtsObject_impl::objectInstances = 0;

ArtsObject_impl::ArtsObject_impl()
{
	referenceCount = 0;
	objectDescription = "<unknown>";
	objectInstances++;
}

ArtsObject_impl::~ArtsObject_impl()
{
	artsdebug("one %s object freed => total %ld ArtsObjects alive\n",objectDescription.c_str(),objectInstances-1);
	objectInstances--;
	if(objectInstances == 0)
	{
		//ArtsBoa->deactivate_impl( CORBA::ImplementationDef::_nil() );
		ArtsOrb->shutdown(TRUE);
	}
}

void ArtsObject_impl::describe(string desc)
{
	objectDescription = desc;
}

void ArtsObject_impl::incRef()
{	
	referenceCount++;
	artsdebug("incRef(%s) -> %ld\n",objectDescription.c_str(),referenceCount);
}

void ArtsObject_impl::decRef()
{	
	assert(referenceCount > 0);
	referenceCount--;
	artsdebug("decRef(%s) -> %ld\n",objectDescription.c_str(),referenceCount);
	if(referenceCount == 0)
	{
		cleanUp();				// same trick as in KOM
								// you may clean up children now, that have
								// references to you  ... overload that
								// function
		if(_refcnt() != 1)
			artsdebug("decRef: WARNING; CORBA reference count to %s is now %ld\n",objectDescription.c_str(),_refcnt());
		CORBA::release(this);	// free this instance
	}
}

void ArtsObject_impl::destroy()
{
	incRef();
	decRef();
}

void ArtsObject_impl::cleanUp()
{
	// overload me
}
