	/*

    Copyright (C) 1999 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#ifndef __AUDIOMAN_IMPL_H__
#define __AUDIOMAN_IMPL_H__

#include "config.h"
#include "arts.h"
#include "artsobject.h"
#include "ioevent.h"
#include "pipebuffer.h"
#include <string>

#define DEFAULT_AUDIOMANAGER_PORT 5007

class AudioClient {
public:
	// do we need status things and/or controls (like setBitDepth/etc)?
	virtual void setBus(const char *bus) = 0;
	virtual void terminate() = 0;
};

class AudioUplink_impl;

// Implementation for interface AudioManager
class AudioManager_impl : 
  virtual public ArtsObject_impl,
  virtual public Arts::AudioManager_skel,
  virtual public ArtsNotifyIO
{
  protected:
	int theSocket, thePort;
	Arts::Synthesizer_var Synthesizer;
	unsigned long _changes;
	list<AudioUplink_impl *> _uplinks;
	long maxClient;
	ArtsIOEvent *socketIOEvent;

	int open_listen_socket(int port);

  public:
	AudioManager_impl(Arts::Synthesizer_ptr Synthesizer);
	~AudioManager_impl();
	void notifyIO(int fd,long type);

	// interface to AudioUplink_impl
	void unregisterUplink(AudioUplink_impl *uplink);

	// CORBA exported attributes:
    char* url();
	unsigned long changes();
	Arts::AudioClientInfoSeq* clients();

	// CORBA exported functions:
	void configureClient(long ID, const char *destination);
};


// Implementation for interface AudioUplink
class AudioUplink_impl : 
  virtual public Arts::AudioUplink_skel,
  virtual public ArtsNotifyIO
{
  protected:
	int fd;
	PipeBuffer buffer;
	ArtsIOEvent *readIOEvent;
	ArtsIOEvent *writeIOEvent;

	Arts::Synthesizer_var Synthesizer;
	AudioManager_impl *AudioManager;

	long _underruns;
	string _type,_description,_bus;
	AudioClient *theClient;
	Arts::AudioClientStatus _status;
	Arts::AudioClientDirection _direction;

	long _clientID;
	static list<AudioUplink_impl *> instances;

	long structureID;
	bool gotBus, gotStart, gotClose, gotDirection, playing;
	bool writeRunning;

	void play();

  public:
	AudioUplink_impl(int fd, Arts::Synthesizer_ptr Synthesizer, long clientID,
							AudioManager_impl *manager);
	~AudioUplink_impl();

	long clientID();
	void notifyIO(int notifyfd,long type);

	// CORBA exported attributes:
    char* description();
    void description( const char* _new_value );
    char* type();
    void type( const char* _new_value );
	Arts::AudioClientDirection direction();
	void direction(Arts::AudioClientDirection direction);
    CORBA::Long bufferedSamples();
    CORBA::Long underruns();

	// CORBA exported functions:
    void start();

	// Interface to AudioManager:
	void setBus(const char *bus);
	const char *bus();
	
	void setStatus(Arts::AudioClientStatus newstatus);
	Arts::AudioClientStatus status(); 
	
	// Interface to AMAN_INJECT
	static AudioUplink_impl *find(long ID);

	PipeBuffer *pipeBuffer();
	void clientCreated(AudioClient *client);
	void clientDestroyed(AudioClient *client);

	void needMoreData();
	void haveMoreData();
};


#endif
