#include <string>
#include "pipebuffer.h"

class ASProducer {
public:
	virtual void needMore() = 0;
};

// FIXME: haveMore won't be called currently
class ASConsumer {
public:
	virtual void haveMore() = 0;
};

class AudioSubSystem {
	string _error;
	int audio_fd;
	int fragment_size;
	int usageCount;
	int _channels;
	bool _running;
	bool fullDuplex;
	PipeBuffer wBuffer, rBuffer;
	ASConsumer *consumer;
	ASProducer *producer;

	AudioSubSystem();

	void close();

public:
	enum { ioRead=1, ioWrite=2, ioExcept=4 };

	// singleton
	static AudioSubSystem *the();

	/*
	 * Currently, if you want to use the AudioSubSystem, you need to
	 * 
	 * 1. - attach one producer
	 *    - attach one consumer (only for full duplex)
	 *    - open the audio subsystem using open (watch the fd)
	 *    (in any order)
	 *
	 * 2. react on the callbacks you get for the producer
	 *
	 * 3. if you don't need the audio subsystem any longer, call detach
	 *    both, the producer and the cosumer.
	 *
	 * Be careful that you don't read/write from/to the audio subsystem
	 * when running() is not true.
	 */

	bool attachProducer(ASProducer *producer);
	bool attachConsumer(ASConsumer *consumer);

	void detachProducer();
	void detachConsumer();

	int open(int fragments, int size, int samplingrate, int channels,
			 bool wantfullduplex);
	const char *error();

	/*
	 * returncode of open: -1 indicates an error; otherwise, the returned
	 * filedescriptor must be watched using select calls, and, whenever
	 * fd is ready for something, handleIO must be called. 
	 *
	 * The type for handleIO must be set to ioRead if fd is ready for
	 * reading, ioWrite if fd is ready for writing, ioExcept if something
	 * special happend or any combination of these using bitwise or.
	 */
	void handleIO(int type);

	void read(void *buffer, int size);
	void write(void *buffer, int size);

	/*
	 * returns true as long as the audio subsystem is opened and active (that
	 * is, between successful opening, with attaching producer, and the first
	 * detachConsumer/detachProducer
	 */
	bool running();

	int channels();
};
