	/*

	Copyright (C) 1998 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#include "ioevent.h"	
#include "debug.h"	
#include "artsorb.h"

ArtsIOEvent::ArtsIOEvent(ArtsNotifyIO *object, int fd, long type, long ID)
{
	this->object = object;
	this->fd = fd;
	this->type = type;
	this->_ID = ID;
	this->running = false;
	artsdebug("created an io event...\n");
}

ArtsIOEvent::~ArtsIOEvent()
{
	stop();
}

void ArtsIOEvent::callback(CORBA::Dispatcher *, enum CORBA::Dispatcher::Event)
{
	object->notifyIO(fd,type);
}

void ArtsIOEvent::start()
{
	if(running) return;

	switch(type)
	{
		case ArtsIOEvent::ioRead:
						running = true;
						ArtsOrb->dispatcher()->rd_event(this,fd);
					break;
		case ArtsIOEvent::ioWrite:
						running = true;
						ArtsOrb->dispatcher()->wr_event(this,fd);
					break;
		default:		// unsupported
						assert(false);
					break;
	}
}

void ArtsIOEvent::stop()
{
	if(!running) return;

	ArtsOrb->dispatcher()->remove(this,CORBA::Dispatcher::All);
	running = false;
}

long ArtsIOEvent::ID()
{
	return _ID;
}
