    /*

    Copyright (C) 1999 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

/*
Try this. It's a really nice 4pole. Very Moog like.

in[x] and out[x] are member variables, init to 0.0
the controls:

fc = cutoff, nearly linear [0,1] -> [0, fs/2]
res = resonance [0, 4] -> [no resonance, self-oscillation]
*/

#include "synthmodule.h"

class Synth_MOOG_VCF :public SynthModule
{
protected:
	// inputs:
	enum { INVALUE, FREQUENCY, RESONANCE };

	// outputs:
	enum { OUTVALUE };

	double freqcorrect;
	double in1,in2,in3,in4;
	double out1,out2,out3,out4;

public:
	void Initialize();
	void Calculate() { /* don't have that */ };
	void CalculateBlock(unsigned long samples);
	string getParams() { return("invalue,frequency,resonance;outvalue"); }
	static void *Creator() { return new Synth_MOOG_VCF; };
};

ModuleClient MC_Synth_MOOG_VCF(SynthModule::get_MS,"Synth_MOOG_VCF",
												Synth_MOOG_VCF::Creator);

void Synth_MOOG_VCF::Initialize()
{
	haveCalculateBlock = true;
	in1 = in2 = in3 = in4 = out1 = out2 = out3 = out4 = 0.0;
}

void Synth_MOOG_VCF::CalculateBlock(unsigned long samples)
{
	float *outsig = out[OUTVALUE],*insig = in[INVALUE],*outend=outsig+samples;
	float *resonance = in[RESONANCE], *frequency = in[FREQUENCY];

    freqcorrect = 1.16 / (double)(samplingRate/2);
	while(outsig < outend)
	{
		double input = *insig++;
		double fc = *frequency++;
		double res = *resonance++;
		double f = fc * freqcorrect;
		double fb = res * (1.0 - 0.15 * f * f);

		input -= out4 * fb;
		input *= 0.35013 * (f*f)*(f*f);

		out1 = input + 0.3 * in1 + (1 - f) * out1; // Pole 1
		in1  = input;
		out2 = out1 + 0.3 * in2 + (1 - f) * out2;  // Pole 2
		in2  = out1;
		out3 = out2 + 0.3 * in3 + (1 - f) * out3;  // Pole 3
		in3  = out2;
		out4 = out3 + 0.3 * in4 + (1 - f) * out4;  // Pole 4
		in4  = out3;

		*outsig++ = out4;
	}
}
