	/*

	Copyright (C) 1999 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#include "synthmodule.h"
#include "parameters.h"
/*
#include "synth_impl.h"
#include "debug.h"
#include <sys/types.h>
#include <sys/time.h>
#include <termios.h>
#include <ctype.h>
#include <unistd.h>
#include <stdlib.h>
#include <fcntl.h>
#include <math.h>

extern "C" {
#include "utils.h"
#include "sound.h"
}
*/

class Synth_PARAM_SET :public SynthModule
{
	// inputs
	enum { VALUE, PROP_NAME };
	Parameter *param;
public:
	void Initialize();
	void Calculate() {};
	void CalculateBlock(unsigned long cycles);
	string getParams() { return("value,_name;"); }
	static void *Creator() { return new Synth_PARAM_SET; };
};

void Synth_PARAM_SET::Initialize()
{
	param =
	   ParameterManager::the()->lookupParameter(getStringProperty(PROP_NAME));
	haveCalculateBlock = true;
};

ModuleClient MC_Synth_PARAM_SET(SynthModule::get_MS,"Synth_PARAM_SET",Synth_PARAM_SET::Creator);

void Synth_PARAM_SET::CalculateBlock(unsigned long cycles)
{
	param->setFloatValue(in[VALUE][0]);
}

class Synth_PARAM_GET :public SynthModule, ParameterObserver
{
	// inputs
	enum { PROP_NAME };

	// outputs
	enum { VALUE };

	float value;
	Parameter *param;
public:
	void Initialize();
	void DeInitialize();
	void Calculate() {};
	void parameterChanged(const Parameter *parameter) {
		value = parameter->floatValue();
	}
	void CalculateBlock(unsigned long cycles);
	string getParams() { return("_name;value"); }
	static void *Creator() { return new Synth_PARAM_GET; };
};

void Synth_PARAM_GET::Initialize()
{
	param =
	   ParameterManager::the()->lookupParameter(getStringProperty(PROP_NAME));
	param->startObserve(this);
	value = param->floatValue();
	haveCalculateBlock = true;
};

void Synth_PARAM_GET::DeInitialize()
{
	param->stopObserve(this);
}

ModuleClient MC_Synth_PARAM_GET(SynthModule::get_MS,"Synth_PARAM_GET",Synth_PARAM_GET::Creator);

void Synth_PARAM_GET::CalculateBlock(unsigned long cycles)
{
	float *outvalue = out[VALUE], *end = &out[VALUE][cycles];

	while(outvalue != end) { *outvalue++ = value; }
}

/*----------- same thing, but for strings -----------*/
class Synth_PARAM_SSET :public SynthModule
{
	// inputs
	enum { PROP_VALUE, PROP_NAME };

	Parameter *param;
public:
	void Initialize();
	void Calculate() {};
	void CalculateBlock(unsigned long cycles);
	string getParams() { return("_value,_name;"); }
	static void *Creator() { return new Synth_PARAM_SSET; };
};

void Synth_PARAM_SSET::Initialize()
{
	param =
	   ParameterManager::the()->lookupParameter(getStringProperty(PROP_NAME));
	param->setStringValue(getStringProperty(PROP_VALUE));
	haveCalculateBlock = true;
};

ModuleClient MC_Synth_PARAM_SSET(SynthModule::get_MS,"Synth_PARAM_SSET",Synth_PARAM_SSET::Creator);

void Synth_PARAM_SSET::CalculateBlock(unsigned long cycles)
{
	// optimize that?
}

class Synth_PARAM_SGET :public SynthModule, ParameterObserver
{
	// inputs
	enum { PROP_NAME };

	// outputs
	enum { OPROP_VALUE };

	Parameter *param;
public:
	void Initialize();
	void DeInitialize();
	void Calculate() {};
	void parameterChanged(const Parameter *parameter) {
		setStringProperty(OPROP_VALUE, parameter->stringValue().c_str());
	}
	void CalculateBlock(unsigned long cycles);
	string getParams() { return("_name;_value"); }
	static void *Creator() { return new Synth_PARAM_SGET; };
};

void Synth_PARAM_SGET::Initialize()
{
	param =
	   ParameterManager::the()->lookupParameter(getStringProperty(PROP_NAME));
	param->startObserve(this);
	setStringProperty(OPROP_VALUE, param->stringValue().c_str());
	haveCalculateBlock = true;
};

void Synth_PARAM_SGET::DeInitialize()
{
	param->stopObserve(this);
}

ModuleClient MC_Synth_PARAM_SGET(SynthModule::get_MS,"Synth_PARAM_SGET",Synth_PARAM_SGET::Creator);

void Synth_PARAM_SGET::CalculateBlock(unsigned long cycles)
{
	// optimize away?
}
