    /*

    Copyright (C) 1999 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#include "parameters.h"
Parameter::Parameter(const char *name)
{
	this->_name = name;

	// standard start values
	_floatValue = 0;
	_stringValue = "";
}

void Parameter::setFloatValue(float newValue)
{
	float diff = _floatValue-newValue;

	if(diff*diff < 0.00000001) return;

	list<ParameterObserver *>::iterator i;

	_floatValue = newValue;

	for(i=observers.begin(); i!=observers.end(); i++)
		(*i)->parameterChanged(this);
}

void Parameter::setStringValue(string newValue)
{
	if(_stringValue == newValue) return;

	list<ParameterObserver *>::iterator i;

	_stringValue = newValue;

	for(i=observers.begin(); i!=observers.end(); i++)
		(*i)->parameterChanged(this);
}

void Parameter::startObserve(ParameterObserver *observer)
{
	observers.push_back(observer);
}

void Parameter::stopObserve(ParameterObserver *observer)
{
	observers.remove(observer);
}

ParameterManager::ParameterManager()
{
	// just there to make the constructor protected
}

ParameterManager *ParameterManager::the()
{
	static ParameterManager *instance = 0;

	if(!instance) instance = new ParameterManager;
	return instance;
}

Parameter *ParameterManager::lookupParameter(const char *name)
{
	list<Parameter *>::iterator i;

	for(i=parameters.begin();i!=parameters.end();i++)
	{
		if(strcmp((*i)->name(),name) == 0) return(*i);
	}
	Parameter *newParam = new Parameter(name);
	parameters.push_back(newParam);

	return newParam;
}
