    /*

    Copyright (C) 1998 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */


#ifndef __STRUCTURES_H__
#define __STRUCTURES_H__

#include "arts.h"
#include "string.h"
#include "artsobject.h"
#include <algorithm>


// Implementation for interface PortDesc
class PortDesc_impl : 	public ArtsObject_impl,
						public Arts::PortDesc_skel
{
  protected:
	string _Name;
	long _ID;
	Arts::PortType _Type;
	Arts::ModuleDesc_ptr _Parent;
	Arts::PortDescSeq *_Connections;
	bool _hasValue;
	bool _isConnected;
	CORBA::Float _FloatValue;
	string _StringValue;

	CORBA::Long _OldID;			// for reconnection
	list<long> oldConnections;

  public:
    CORBA::Long ID();
    Arts::ModuleDesc_ptr Parent();
    char* Name();
    Arts::PortType Type();

    CORBA::Boolean isConnected();
    CORBA::Boolean hasValue();
    void hasValue(CORBA::Boolean newvalue);

    Arts::PortDescSeq* Connections();
    CORBA::Float FloatValue();
    void FloatValue( CORBA::Float _new_value );
    char* StringValue();
    void StringValue( const char* _new_value );

    CORBA::Boolean connectTo( Arts::PortDesc_ptr port );
    void internalConnectInput( Arts::PortDesc_ptr port );
	void internalReConnect( const Arts::PortDescSeq& allports );
	long internalOldID();

    void disconnectFrom( Arts::PortDesc_ptr port );
    void disconnectAll();
	void cleanUp();

	void loadFromList(const Arts::StringSeq& list);
	Arts::StringSeq *saveToList();

	PortDesc_impl(Arts::ModuleDesc_ptr parent, string name,
									Arts::PortType type);
	~PortDesc_impl();
};


#ifdef _X
/* FreeBSD-3.2 has some strange ideas what to define and what not ;) */
#undef _X
#endif

// Implementation for interface ModuleDesc
class ModuleDesc_impl : public ArtsObject_impl,
						public Arts::ModuleDesc_skel
{
  protected:
	string _Name;
	long _ID,_X,_Y;
	CORBA::Boolean _isInterface;
	CORBA::Boolean _isStructure;
    Arts::PortDescSeq* _Ports;
	Arts::StructureDesc_ptr _Parent;

  public:
    CORBA::Long ID();
    Arts::StructureDesc_ptr Parent();
    char* Name();
    Arts::PortDescSeq* Ports();
    CORBA::Long X();
    CORBA::Long Y();
    CORBA::Long Width();
    CORBA::Long Height();

    CORBA::Boolean moveTo( CORBA::Long X, CORBA::Long Y );
	CORBA::Boolean isInterface();
	CORBA::Boolean isStructure();

	Arts::PortDesc *findPort( const char *name );
	void loadFromList(const Arts::StringSeq& list);
	Arts::StringSeq *saveToList();
	// C++ functions:

	ModuleDesc_impl( Arts::StructureDesc_ptr parent, Arts::ModuleInfo *info );
	~ModuleDesc_impl();

	long collectPorts( Arts::ModuleInfo *info );
/*
	long collectPorts( SynthModule *module,
			SynthModule::ArgType mdir, Arts::PortDirection pdir );
*/
	void cleanUp();
};


class StructurePortDesc_impl : public PortDesc_impl,
                               public Arts::StructurePortDesc_skel
{
  protected:
	long _X, _Y, _Position;
	Arts::StructureDesc_ptr _ParentStructure;

  public:
	StructurePortDesc_impl(Arts::StructureDesc_ptr parent, string name, Arts::PortType type);
	~StructurePortDesc_impl();

    CORBA::Long X();
    CORBA::Long Y();
    CORBA::Long Position();
    Arts::StructureDesc_ptr ParentStructure();
    CORBA::Boolean moveTo( CORBA::Long X, CORBA::Long Y );

	void lowerPosition();           // will move the port more left
	void raisePosition();           // will move the port more right
	void rename(const char *newname);
 
	// only used by the structure to reorder the ports
	void internalSetPosition(long Position);

	// override load & save behaviour

	void loadFromList(const Arts::StringSeq& list);
	Arts::StringSeq *saveToList();
};

// Implementation for interface StructureDesc
class StructureDesc_impl : public ArtsObject_impl,
						   public Arts::StructureDesc_skel
						   
{
  protected:
	long nextID;	
	long subStructureCount;
	bool _valid;
	//string _Name;
	Arts::ModuleInfo _ExternalInterface;
    Arts::ModuleDescSeq* _Modules;
    Arts::StructurePortDescSeq* _Ports;
	Arts::ModuleBroker_var ModuleBroker;

  public:
	StructureDesc_impl(Arts::ModuleBroker *myModuleBroker);
	~StructureDesc_impl();
	void cleanUp();

    Arts::ModuleDesc_ptr createModuleDesc( const char *name );

// CORBA exported functions:

	void Name(const char *);
	char *Name();

    CORBA::Long Width();
    CORBA::Long Height();
    CORBA::Boolean containsStructures();
    CORBA::Boolean valid();

    Arts::ModuleDesc_ptr createModuleDesc( const Arts::ModuleInfo& info );
	void freeModuleDesc( Arts::ModuleDesc_ptr moduledesc );
	Arts::ModuleDescSeq *Modules();
    CORBA::Long obtainID();

	void clear();

	void loadFromList(const Arts::StringSeq& list);
	Arts::StringSeq *saveToList();

	// external interface stuff (structure ports):

	Arts::ModuleInfo *ExternalInterface();
	Arts::StructurePortDescSeq *Ports();
	Arts::StructurePortDesc *createStructurePortDesc(const Arts::PortType& type,
													 const char *name);
	void freeStructurePortDesc(Arts::StructurePortDesc *portdesc);
	void moveStructurePortDesc(Arts::StructurePortDesc *portdesc,
                                                long newposition);
};

#endif
