	/*

	Copyright (C) 1998 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#ifndef _SYNTH_IMPL_H
#define _SYNTH_IMPL_H

#include "arts.h"
#include "synthmodule.h"
#include "moduleserver.h"
#include "artsobject.h"
#include "mbroker_impl.h"
#include "audioman_impl.h"
#include "execrequest.h"
#include "cache.h"
#include "midi.h"
#include "expand.h"
#include "ioevent.h"
#include "iomanager.h"

#include <list>
#include <string>

class ArtsIOEvent;
class StructureExpander;
class AudioManager_impl;


struct RestoreInfo {
	long restoreID;
	long oldID;

	bool haveStructureName, haveSessionData,ok;

	string structureName;
	Arts::StringSeq_var sessionData;
};

class Synthesizer_impl :virtual public ArtsObject_impl,
						virtual public Arts::ArtsServer_skel,
						virtual public Arts::SessionManager_skel,
						virtual public Arts::Synthesizer_skel,
						virtual public ArtsNotifyIO
						 
{
	Cache *_Cache;
	MidiChannel_impl *_MidiChannel;
	ModuleBroker_impl *_ModuleBroker;
	AudioManager_impl *_AudioManager;
	StructureExpander *_StructureExpander;

	CORBA::Long _ID;	// ArtsServer attribute ID

	list<SynthModule *> _global_interfaces_hack;
	list<SynthModule *> callBackList;
	list<RestoreInfo *> riList;

	SynthModule	**SynthModules;
	unsigned long MCount;

	unsigned long schedulerLocks;
	bool inScheduler;

	list<ExecRequest *> execRequests;	// what is running on the server ?
	//list<ArtsIOEvent *> IOEvents;
	IOManager ioManager;
	long _StructChangeCount;

	list<long> killList;

/** status watching -> don't bring down the system by hogging the cpu **/

	long status_stalled;
	long status_clocks;
	long status_cycles;
	bool status_halted;
	float status_cpu_usage;
	long status_cache_usage;

protected:
	ModuleServer<SynthModule> *MS_SynthModule;
	float *AllocArg(string name, int flags);
	void initModules();

	long nextID;		// execution IDs
	long nextMID;		// execution IDs
	long nextRestoreID;	// restauration IDs

	Arts::RealtimeConfig _RTConfig;
	Arts::StructureDescSeq _Structures;
	Arts::StringSeq _artsPath;

public:
	long StructChangeCount();

	void notifyIO(int fd,long type);
	void Run();
	bool Exec();
	void kill(long ID);
	void requestCallBack(SynthModule *m);
	Cache *getCache();
	MidiChannel_impl *getMidiChannel();

	void removeDynamicConnections (SynthModule *module);
	void addDynamicConnection (SynthModule *target, SynthModule *source, long unsigned int size);

/*
	void expandStructure(Arts::StructureDesc *structuredesc,
   		list<SourceDesc *>& inputs, list<SourceDesc *>& outputs,
		list<SourceDesc *>& sourcedescs, Arts::StructureDesc *target);
*/

	long createConnectedStructure(Arts::StructureDesc *structuredesc,
		const Arts::ArtsServerSeq& preferredservers,
		list<SynthModule *> interfaces, long restoreID=0, long oldID=0);

	Synthesizer_impl();
	~Synthesizer_impl();
	void cleanUp();

	void lockScheduler();
	void unlockScheduler();

// exported CORBA attributes

	Arts::RealtimeConfig RTConfig();
	void RTConfig(const Arts::RealtimeConfig &newconfig);

	Arts::ResourceInfoSeq *Resources();
	Arts::StructureDescSeq *publishedStructures();
	Arts::ModuleBroker *moduleBroker();
	Arts::AudioManager *audioManager();

    Arts::StringSeq* artsPath();
	Arts::StringSeq *busList();

	CORBA::Long ID();	// ArtsServer ID

// exported CORBA functions

// for the execution server
	
	// to get the synth_server down if something breaks badly:
    void forceTermination();

    void Reset();
    Arts::Status getStatus();

    Arts::StructureDesc *createStructureDesc();
    void publishStructureDesc(Arts::StructureDesc *structuredesc);
    Arts::StructureDesc *lookupStructureDesc(const char *name);
 
	Arts::StructureDesc *expandStructureDesc(Arts::StructureDesc *structuredes);
	CORBA::Long createStructure(Arts::StructureDesc *structuredesc,
								const Arts::ArtsServerSeq& preferredservers);
	CORBA::Long restoreStructure(Arts::StructureDesc *structuredesc,
		const Arts::ArtsServerSeq& preferredservers, CORBA::Long restoreID,
		CORBA::Long oldID);
								
    CORBA::Boolean isExecuting(long int id);
    CORBA::Boolean freeStructure(long int id);

	// global session management
	CORBA::Boolean saveSession(CORBA::Long structureID,
				CORBA::Boolean saveStructureDescs, Arts::StringSeq*& session);

	CORBA::Long restoreSession(const Arts::StringSeq& session, const Arts::ArtsServerSeq& preferredservers);

// for the flow system server

    CORBA::Long createModules();
    CORBA::Boolean createModule(CORBA::Long mid, Arts::ModuleDesc *desc);
    CORBA::Boolean localConnectModules(CORBA::Long mid);
	CORBA::Boolean remoteConnectModules(CORBA::Long mid, CORBA::Long remotemid,
		const Arts::ModuleDescSeq& modules, ArtsServer *server);
    CORBA::Boolean finalizeModules(CORBA::Long mid);
    void startModules(CORBA::Long mid);
    void deleteModules(CORBA::Long mid);

    void requestSignal(CORBA::Long mid, CORBA::Long portid,
		Arts::Receiver *receiver);

	// flow server session management
	
	CORBA::Boolean saveSessionModules(CORBA::Long mid,
			Arts::StringSeq*& data, Arts::IDSeq*& structureIDs);

	CORBA::Boolean restoreSessionModules(CORBA::Long mid,
			const Arts::StringSeq& data, CORBA::Long restoreID);

// path management
	void addArtsDirectory(const char* directory);
    char* artsFileName(const char *directory, const char* name);
    Arts::StringSeq* listFiles(const char* directory, const char* extension);

};

#endif
