/* Dies ist unsere grafische Oberflche. Im Gegensatz zur Vorlage "kradio"
 * im xawtv Paket wollte ich viel mehr "echte" GUI Elemente und keine
 * Buttons fr Stationsknpfe haben.
 *
 * Geschrieben und (C)  Nov 1998 Carsten Gro,
 *                                carsten@sol.wohnheim.uni-ulm.de
 * dabei orientiert an der kexample Vorlage von Matthias Ettrich 
 *
 * 
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Standardbibliotheken
#include <minmax.h>
#ifndef NDEBUG
#include <iostream.h>
#endif
#include <errno.h>
#include <assert.h>   // Wollen wir auf jeden Fall :-)
#include <stdlib.h>	  // We need it for strtod

// Qt Zeug
#include <qstring.h>
#include <qspinbox.h>
#include <qpopupmenu.h>
#include <qmessagebox.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qgroupbox.h>
#include <qtooltip.h>
#include <qstrlist.h>
#include <qtextstream.h>
#include <qlineedit.h>

// KDE Includes
// #include <kfm.h>
#include <kapp.h>
#include <kmainwindow.h>
#include <kmenubar.h>
#include <kaccel.h>
#include <kfiledialog.h>
#include <klocale.h>
#include <kiconloader.h>

// Eigenes
#include "radioctrl.h"
#include "kderadio.h"
#include "stationsdialog.h"


/*
 * Im Konstruktor, hngt eigentlich die meiste Konfigurationsarbeit. 
 * man kann eigentlich sagen, da das gesamte Setup der Applikation
 * hier gemacht wird. Unter anderem wird hier auch das Radio angeschaltet,
 * indem der Konstruktor der Radio-Klasse aufgerufen wird.
 * Es wird hier auch die QList der Radioprogramme angelegt
 */

KRadio::KRadio() {

	double Frequenz;	
	// Ja, debugging macht Spa
	magic = MAGIC;

	/* Nun folgen die Aufrufe verschiedener Initialisierungs-
	 * funktionen
	 */
	// Speicher fr die Widgets anfordern (alle new Aufrufe sind hier 
	// drin)
	initWidgets();
	// Die Keyboard Bindings definieren
	// und den Accelarator zurckgeben, womit nachher 
	// die Popup Mens definiert werden
	KAccel * keyaccel = new KAccel(this);

	// Define the keybindings
	initKeyAccel(keyaccel);

	// Die Popup Mens 
	initPopupMenus(keyaccel);

	// Signale und Slots verbinden
	initConnect();
	// Die Stationsliste laden, bzw. wenn sie nicht vorhanden 
	// ist, ein Defaultprogramm einstellen. Diese Funktion
	// gibt die am Anfang einzustellende Frequenz zurck.
	Frequenz=initList();	
	// QToolTips einrichten
	initTooltips();
	// Den Suffix der Frequenzbox einrichten. (Das mu 
	// vor der Greneinstellung kommen!
	pFrequenzBox->setSuffix("MHz");
	// Die Gren der Widgets einstellen und sie positionieren
	// Ohne diesen Aufruf she es sehr komisch aus
	initSize();
	// Nun noch diverse Konfigurationsarbeit erledigen
	// Eine Drag'n Drop Zone einrichten. Das Main Widget 
        // nimmt all unsere Drag's auf.
	// KEINE KDE drop zone
	//	connect( new KDNDDropZone( this , DndURL), 
	//		SIGNAL( dropAction( KDNDDropZone *) ), 
	//		SLOT( slotDropEvent( KDNDDropZone *) ) );


	// Am Schlu des Konstruktors noch das Radio auf
	// die richtige Frequenz "einschalten"
	pRadio = new Radio(Frequenz, 128, this->Device);
	// Luft das Radio wirklich? 
	if ( 0 > pRadio->getStatus()) {
		QString a;
		a = sys_errlist[-(pRadio->getStatus())];

		QMessageBox::critical(0, "kderadio",  
		i18n("Error while opening ") + Device + QString(": \n") + \
		a + QString("\n"));
//		exit(1);
	}
	// Caption und Comboxbox setzen (Frequenz ist schon 
        // im Radio konstruktor aufgerufen worden)
	this->slotChangeStation(LastStation);
	assert (MAGIC == magic);
}

/* Hier folgend Prgrammteile die vom Konstruktor aufgerufen werden,
 * aber eigentlich thematisch eigenstndige Blcke bilden. Deshalb
 * habe ich sie hier als Funktionen definiert 
 */

// In dieser Subfunktion definieren wir die Widgets und fordern Speicher an
void KRadio::initWidgets(void) {
	// Unser Main Widget
	pMainWidget = new QWidget;
	pFileMenu = new QPopupMenu;
	pExtraMenu = new QPopupMenu;
	// 8750 entspricht natrlich 87.5 MHz und 500 kHz Schritte
	pFrequenzBox = new FrequenzBox (8750, 10800, 5, this);
	// Die ComboBox ist Readonly (das False) 
	pStationList = new QComboBox( FALSE, this, 0);
	pEditButton = new QPushButton(i18n("New Station"), this);
	pRemoveButton = new QPushButton(i18n("Remove Station"), this);
	pDocking = new DockWidget( this, "Radio");
	return;
}

// Die Keybindings mit der Methode von KDE 1.1 definieren.
KAccel * KRadio::initKeyAccel(KAccel * keyaccel) {
//	keyaccel->connectItem("save", this, SLOT( slotSaveFile() ) ); 
//	keyaccel->connectItem("&Open", this, SLOT( slotOpenFile() ) );
//	keyaccel->connectItem("quit", kapp, SLOT( quit() ) );
	return keyaccel;
}

// Die Popup-Mens belegen
void KRadio::initPopupMenus(KAccel * keyaccl) {
	// Das "File" Popupmenu
	int id = pFileMenu->insertItem(i18n("Open"), this, SLOT( slotOpenFile() ));
	pFileMenu->changeItem(id, SmallIcon("fileopen"), i18n("Open"));
//	keyaccl->insertItem("&Open", "&Open", 0, id, pFileMenu);
	id = pFileMenu->insertItem(i18n("Save"), this, SLOT( slotSaveFile() ));
	pFileMenu->changeItem(id, SmallIcon("filesave"), i18n("Save"));
//	keyaccl->changeMenuAccel(pFileMenu, id, "save");
	pFileMenu->insertSeparator();
	id = pFileMenu->insertItem(i18n("Quit"), this, SLOT( slotQuit() ) ); 
	 pFileMenu->changeItem(id, SmallIcon("exit"), i18n("Quit"));
//	keyaccl->changeMenuAccel(pFileMenu, id, "quit");
	
	// Das File Popupmenue in die Menuleiste eintragen.
	menuBar()->insertItem(i18n("&File"), pFileMenu);

	// Das Optionen Menu 
	id = pExtraMenu->insertItem(i18n("Dock"), this, \
		SLOT( slotDock()) );
	pExtraMenu->changeItem(id, SmallIcon("attach"), i18n("Dock"));

	id = pExtraMenu->insertItem(i18n("Radiodevice"), this, \
		SLOT( slotPreferencesMenu()));
	pExtraMenu->changeItem(id, SmallIcon("configure"), i18n("Radiodevice"));

	menuBar()->insertItem(i18n("&Options"), pExtraMenu);

	// Und der Abstand zur Hilfe
	menuBar()->insertSeparator();
	// Wir lassen uns das Hilfe Menue mit Hilfe von KDE erzeugen.
	pHelpMenu = this->helpMenu(
		i18n("kderadio, a KDE application for\n"
                "controlling a video4linux compatible\n"
                "radio card.\n\n(C) 1998,2001 by Carsten Gross\n"
                "carsten@siski.de\n"\
		"http://www.siski.de/~carsten\n"\
		"Copying licence is GPL\n"));
	menuBar()->insertItem(i18n("&Help"), pHelpMenu );
	return;
}


// Hier setzen wir die Gre und Position(!) aller Widgets, damit sich ein
// schnes Aussehen der Applikation ergibt.
void KRadio::initSize(void) {

	int distanz = 20;		// Dieser Wert ist Intuition
	int yoffset = 2 *distanz;

	// 1. Spalte: Stations- / Frequenzanzeige
	pStationList->resize(pStationList->sizeHint());
	pStationList->move(distanz,yoffset);
	pFrequenzBox->resize(pFrequenzBox->sizeHint());
	pFrequenzBox->move(distanz, pStationList->height() + yoffset +distanz);

	int xsize = max(pStationList->width(), pFrequenzBox->width());

	// Die 2. Spalte
	int x2size;
	pEditButton->resize(pEditButton->sizeHint());
	pEditButton->move(2*distanz + xsize, yoffset);
	pRemoveButton->resize(pRemoveButton->sizeHint());
	x2size = max(pRemoveButton->width(), pEditButton->width());
	pEditButton->setFixedWidth(x2size);
	pRemoveButton->setFixedWidth(x2size);
	pRemoveButton->move(2*distanz + xsize, yoffset + \
		distanz + pEditButton->height());

	// Applikationsgre setzen, Vernderung verbieten.
	this->setFixedSize(3*distanz+ xsize + x2size, \
		yoffset+pStationList->height()+\
		pFrequenzBox->height()+2*distanz);

	return;
}


// Hier verbinden wir Ereignisse mit Programmcode
// "Was passiert wenn ich 'hier' drcke"?
void KRadio::initConnect(void) {

	// Neue Station eintragen
	connect ( pEditButton, SIGNAL(clicked() ), this, 
		SLOT( slotNewStation() ));
	// Station lschen
	connect (pRemoveButton, SIGNAL(clicked() ), this, 
		SLOT( slotRemoveStation() ));
	// Signal "Frequenznderung" vom User
	connect ( pFrequenzBox, SIGNAL( valueChanged(int ) ), this, 
		SLOT( slotChangeFrequenz(int )));
	// Signal "Neue Station" (Combobox verndert) auf Funktion
	connect ( pStationList, SIGNAL( activated(const QString &) ), this,
		SLOT( slotChangeStation(const QString &)));
	return;
}

// Wir laden und initialisieren die Liste und die ComboBox-Liste
double KRadio::initList(void) {
	// Die Liste in der wir uns die Radioprogramme merken
	pListe = new QList<RadioProgramm>;
	
	pListe->setAutoDelete(TRUE);
	
	// Globales Config File einlesen (Stationsliste)
	kapp->disableSessionManagement();
	readGlobalProperties(kapp->config());

	// In pListe sind die ganzen Programme drin.
	// Falls das Object leer ist, dann legen wir ein einziges Programm 
	// rein!
	RadioProgramm * temp;
	if (pListe->isEmpty() == TRUE) {
		temp = new RadioProgramm("SWR1 BW", 88.35);
		pListe->append(temp);
		LastStation = "SWR1 BW";
	}
	// Hier legen wir die ComboBox an
	int i=0;
	double Frequenz=87.5;
	for (temp=pListe->first(); temp != 0; temp=pListe->next()) {
		pStationList->insertItem(temp->Station(), i);
		if (LastStation == temp->Station()) {
			Frequenz = temp->Frequenz();
		}
		i++;
	}
	return Frequenz;
}

// Wir setzen die Tooltips des Programms, diese kleinen (nutzlosen, aber 
// hbschen :) ) Ballonhilfen
void KRadio::initTooltips(void) {
	QToolTip::add(pStationList, i18n("Tuned in station"));
	QToolTip::add(pFrequenzBox, i18n("Tuned in frequency"));
	QToolTip::add(pEditButton, i18n("Adds a new station to the list"));
	QToolTip::add(pRemoveButton, i18n("Removes the current station"));
	return;
}


// Die Datei "FileName" laden.
void KRadio::loadFile(QString FileName) {
	RadioProgramm * p;	

	if ( FileName.isNull() ) {
		return;
	}
	QFile FrequenzDatei(FileName);
	// Datei zum lesen ffnen
	if ( FrequenzDatei.open(IO_ReadOnly) ) {
		QString Station;
		double frequenz;
		QString Muelleimer;
		
		// Wir lschen erstmal die 2 Listen (ComboBox und 
		// die Programmliste
		pListe->clear();
		pStationList->clear();

		// In die Liste schreiben
		QTextStream Dateistrom(&FrequenzDatei);
		// Lesen bis Dateiende
		while (Dateistrom.eof() != TRUE) {
			Station = Dateistrom.readLine();
			Dateistrom >> frequenz;
			Muelleimer = Dateistrom.readLine();
#ifndef NDEBUG
			cout << "Gelesen: " << Station << ", f:" <<\
				frequenz << "\n";
#endif
			p = new RadioProgramm(Station, frequenz);
			pListe->append(p);
			pStationList->insertItem(p->Station(), -1);
		}
			FrequenzDatei.close(); // und Ende
	} else {
		// TODO: ErrorBox 
		cerr << "Open failed!" << errno << "\n";
	}
	// Noch die erste Frequenz der Liste nach dem Laden einstellen.
	slotChangeStation(pListe->first()->Station());
	return;
}

// Das rufen wir auf, wenn auf das File->Open Men geklickt wurde
void KRadio::slotOpenFile() {

	QString FileName(KFileDialog::getOpenFileName(0, "*.freq", 0, 0));
	if (FileName.isNull()) {
		return;
	}
	loadFile(FileName);
	return;
}

void KRadio::slotSaveFile() {
	RadioProgramm * p;
	
	QString FileName(KFileDialog::getSaveFileName(0, "*.freq", 0, 0));
	// Keine Datei ausgesucht
	if ( FileName.isNull() ) {
		return;
	}
	QFile FrequenzDatei(FileName);
	// Datei zum Schreiben ffnen
	if ( FrequenzDatei.open(IO_WriteOnly) ) {
		// Die Liste schreiben
		QTextStream Dateistrom(&FrequenzDatei);
		for (p = pListe->first(); p != NULL; p = pListe->next()) {
			Dateistrom << p->Station() << "\n";
			Dateistrom << p->Frequenz() << "\n";
		}
		FrequenzDatei.flush(); // alles auf Platte bannen
		FrequenzDatei.close(); // und Ende
	} else {
		// TODO: ErrorBox 
		cerr << "Open failed!" << errno << "\n";
	}
	return;
}

// Programm verlassen
void KRadio::slotQuit() {

	pRadio->off();
	saveGlobalProperties(kapp->config());
	kapp->quit();
}

// No drag and drop zones any more

#if 0 
void KRadio::slotDropEvent( KDNDDropZone * DNDevent) {
	
	assert(DNDevent);

	const char *b;
	QString a = DNDevent->getURLList().first(), s;
#ifndef NDEBUG
	cerr << "DND Event! Filename: " << a << "\n";
#endif 
	// Ist das Ende auch wirklich .freq ? 
	b = a;
	if ( strncmp( (b + strlen(b) - 5), ".freq", 5 ) == 0 ) {
		if (KFM::download(a, s)) {
#ifndef NDEBUG
			cerr << "Wir laden ... " << s << "\n";
#endif
			loadFile(s);
			KFM::removeTempFile(s);
		}
	}
}
#endif 

// Stelle die genderte Frequenz auch am Tuner ein.
void KRadio::slotChangeFrequenz(int freq) {
	// Zur Zeit mssen wir das noch umrechnen ... 
	double frequenz;
	QString a;	

	assert(MAGIC == magic);
	
	frequenz=((double)freq)/100;
	
	RadioProgramm * p;		// Zum Durchsuchen der Liste
	signed int i = 0;		// Pointer auf die Position	

	assert((frequenz >= 87.5) && (frequenz <=108.0));

	// Gibt es vielleicht einen Stationsnamen in der Liste?
	// Wenn ja zeigen wir ihn in der Stationsbox
	// Es ist zwar nicht optimal jedesmal eine Liste zu durchsuchen, 
	// allerdings drften im Normalfall sowieso nicht mehr als 30 
	// bis 40 Stationen in dieser Liste drin sein.

	for (p = pListe->first(); p != NULL; p=pListe->next() ) {
		if ( p->Frequenz() == frequenz ) {
			this->pStationList->setCurrentItem(i);
			this->setCaption(p->Station());
			break;
		}
		i++;
	}
	// Liste ist kaputt, Programmfehler 
	assert (((this->pStationList->count()) >= i) );
	if (0 == p) {
		a.setNum(frequenz, 'f', 2);
		a = a + " MHz";	
		this->setCaption(a);
	}
	pDocking->setCaptions(this);
	pRadio->setFrequenz(frequenz);  // Frequenz am Tuner einstellen
	return;
}

// Eine Read Only ComboBox.. ist einfacher... 
void KRadio::slotChangeStation(const QString& Station) {
	RadioProgramm * p;
	bool flag=FALSE;
	int index = 0;

	// Konsistenzcheck
	assert (MAGIC == magic);
	
	for (p = pListe->first(); p != 0; p=pListe->next() ) {
		if (Station == p->Station() ) {
			// Frequenz einstellen und anzeigen
			this->pFrequenzBox->setValue((p->Frequenz()* 100) + 0.5);
			flag=TRUE;
			break;
			}
		index++;
	}
	if ( TRUE == flag ) {
		this->setCaption(Station);
	}
	return;
}

void KRadio::slotNewStation(void) {
	StationsDialog	* pStationsDialog;
	RadioProgramm * p;
	double tunedfreq;
	
	tunedfreq = this->pRadio->getFrequenz();

	pStationsDialog = new StationsDialog(0, i18n("Enter new Station"),\
			tunedfreq);
	if ( TRUE == pStationsDialog->exec() ) {
		// Nur wenn kein Quark eingetippt wurde kommt hier was
		// zurck.
		if (0 != pStationsDialog->getStation()) {
#ifndef NDEBUG
			cout << "Wir tragen es ein\n";
#endif	
			p = new RadioProgramm(\
			pStationsDialog->getStation(), \
			this->pRadio->getFrequenz());
			pListe->append(p);
// Dummes Qt Problem (ist in der Doku besschrieben) workarounden 
// Wenn man in eine ComboBox reinschaut, dann ist
// die dazugehrige Stringlist nicht mehr leer
			if (1 != pStationList->count() ) {
#ifndef NDEBUG
				cerr << "Liste war unproblematisch, "\
					<< pStationList->count() << "\n";
#endif
				pStationList->insertItem(p->Station(), -1);
				pStationList->setCurrentItem((pStationList->count())-1);
			} else { if (strlen(pStationList->currentText()) == 0) {
#ifndef NDEBUG
				cerr << "Liste war ganz leer\n";
#endif
				pStationList->changeItem(p->Station(), 0);
				pStationList->setCurrentItem((pStationList->count())-1);
			} else {
#ifndef NDEBUG
                                cerr << "In der Liste war ein Eintrag :"\
				     << pStationList->currentText() << ":\n";
#endif
                                pStationList->insertItem(p->Station(), -1);
				pStationList->setCurrentItem((pStationList->count())-1);
			}
			}
		}
	}
	return;
}

// get currently tuned in station

QString KRadio::getStation() {
	int index;
	RadioProgramm *p;

	index = pListe->at();
	if (index != -1) {
		p = pListe->at(index);
		return (p->Station());
	} 
	return NULL;
}	
		
// get next station 

QString KRadio::nextStation() {
	int index;
	int oldindex;
	RadioProgramm *p;

	index = pListe->at();	
	oldindex = index;
	index++;
	p = pListe->at(index);
	pListe->at(oldindex);
	if (p != NULL) {
		return p->Station();
	}
	return NULL;	
}		

// get previous station

QString KRadio::prevStation() {
	int index;
	int oldindex;	
	RadioProgramm *p;

	index = pListe->at();
	oldindex = index;
	index--;
	p = pListe->at(index);
	pListe->at(oldindex);
	if ( p != NULL) {
		return p->Station();
	} 
	return NULL;
}

// Eine Station an der aktuellen Listenposition entfernen

void KRadio::slotRemoveStation(void) {
	int index;
	index = pListe->at();
	if ( index != -1 ) {
		pStationList->removeItem(index);
		pListe->remove();
	} else {
		// Nur whrend des Debuggens! 
		// Die Liste ist ganz leer oder sonstiger Fehler
		assert(index);
	}
	slotChangeStation(pStationList->currentText());
	return;
}	

// saveGlobalProperties wird aufgerufen wenn die Applikation "about to close" ist
// Das heit zum Beispiel wenn der Benutzer den "Ausloggen" beim kwm
// gewhlt hat. Wir speichern unsere aktuelle Frequenzliste und was man
// sonst so configurieren kann.
void KRadio::saveGlobalProperties(KConfig * config) {
	RadioProgramm *p;

	QStrList a;
	// Gltiges Config Object und gltige Liste?
	assert (config && pListe);
// Zuerst mal die Frequenzliste speichern
	config->setGroup("Stations");
	for ( p = pListe->first(); p != NULL; p = pListe->next()) {
		a.append( p->Station());
		config->writeEntry(p->Station(), p->Frequenz());
	}
	config->writeEntry("Stations", a, ';', TRUE, FALSE, FALSE);
// Jetzt speichern wir noch die Optionen ab
	config->setGroup("Configuration");
// TODO: /dev/radio in einer Variablen speichern!
	config->writeEntry("RadioDevice", this->Device);
	config->writeEntry("CurrentStation", pStationList->currentText());
	config->sync();

#ifndef NDEBUG
	a = 0;
#endif 
	return;
}

// Die Frequenzliste wieder laden
void KRadio::readGlobalProperties(KConfig * config) {
	RadioProgramm *p;

	QString device;
	QString Station;
	double d;
	int count;
	QStrList a;
	char * b;
	// Gltiges Config Object und gltige Liste?
	assert (config && pListe);

	// TODO: Hier noch ne Abfrage? 
	pListe->clear();
	config->setGroup("Stations");
	count = config->readListEntry("Stations", a, ';');
	for ( b = a.first(); b != 0; b=a.next()) {
		d = config->readDoubleNumEntry(b, 87.5);
		p = new RadioProgramm(b, d); 
		pListe->append(p);
	}
	// Noch die anderen Einstellungen lesen.
	config->setGroup("Configuration");
	this->Device = config->readEntry("RadioDevice", "/dev/radio");
	if (pListe->first()) {
		this->LastStation = config->readEntry("CurrentStation", \
			  pListe->first()->Station());
	}
#ifndef NDEBUG
	a = 0;
#endif 
	return;
}

void KRadio::slotPreferencesMenu(void) {
	
	QDialog * pDeviceDialog = new QDialog(0, 0, TRUE, WStyle_DialogBorder);
	QLabel * pDeviceLabel = new QLabel(i18n("Please enter the device " \
		"special file name\n"), pDeviceDialog);
	QLineEdit * pDeviceEdit = new QLineEdit(pDeviceDialog);
	QPushButton * pOk = new QPushButton(i18n("OK"), pDeviceDialog);
	
	int distanz = 20;

	// Schicke Gren einstellen	
	pDeviceLabel->resize(pDeviceLabel->sizeHint());
	pDeviceEdit->resize(pDeviceEdit->sizeHint());
	pOk->resize(pOk->sizeHint());
	pDeviceDialog->resize(2 * distanz + pDeviceLabel->width(), \
		2*distanz + distanz/4 + pDeviceLabel->height() + \
		pDeviceEdit->height());
	pDeviceLabel->move(distanz,distanz);
	int yoff = distanz + distanz/4 + pDeviceLabel->height();
	pDeviceEdit->move(distanz, yoff);
	pOk->move(2 * distanz +  pDeviceEdit->width(), yoff);
	pDeviceEdit->setText(Device);
	connect( pDeviceEdit, SIGNAL( returnPressed()), pDeviceDialog, 
		SLOT(accept()));
	connect( pOk, SIGNAL(clicked()), pDeviceDialog, SLOT(accept()));
	pDeviceDialog->exec();
	Device=pDeviceEdit->text();
	pRadio->on(Device);
	return;
}

void KRadio::slotDock() {
	if (pDocking) {
		pDocking->SaveKDERadioPosition();
		this->hide();
		pDocking->dock();
		QToolTip::add(pDocking, this->pStationList->currentText());
	} else {
		// Programmfehler, warum geht denn das Docken nicht :) ? 
		assert(0);
	}
	return;
}

void KRadio::slotUndock() {
	pDocking->undock();
	return;
}
