/*
  Copyright (C) 1999 Rainer Maximini

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package
*/

#ifndef CONFIGPLAYER_H
#define CONFIGPLAYER_H

#include <kapp.h>
#include <kconfig.h>
#include <qwidget.h>
#include <qgroupbox.h>
#include <qcheckbox.h>
#include <qframe.h>
#include <qcombobox.h>
#include <klined.h>
#include <kconfig.h>
#include <qlabel.h>
#include "configfolder.h"
#include "kjukebox.h"
#include "amplifier/amplifier.h"

class ConfigPlayer : public QWidget{
  Q_OBJECT
 private:
  KConfig   *config;
  QGroupBox *boxTime;
  QGroupBox *boxDevice;

  QCheckBox *enableDefaultTime;
  QCheckBox *enableFadeOut;
  QCheckBox *enableFadeIn;
  QCheckBox *enableMixing;
  KLined    *firstSecBox;
  KLined    *lastSecBox;
  KLined    *audioDevBox;
  KLined    *fadeInDurationBox;
  KLined    *fadeOutDurationBox;
  QLabel    *firstSecBoxLabel;
  QLabel    *lastSecBoxLabel;
  QLabel    *audioDevBoxLabel;
  QLabel    *mixingLabel;
  QLabel    *fadeInDurationBoxLabel;
  QLabel    *fadeOutDurationBoxLabel;

  QGroupBox *boxQuality;
  QCheckBox *monoQuality;
  QCheckBox *downsampleQuality;


  bool    defaultTime;
  bool    fadeOut;
  bool    fadeIn;
  bool    mixing;
  int     quality;
  int     priorityPlayer;
  int     firstSeconds;
  int     lastSeconds;
  int     fadeOutDuration;
  int     fadeInDuration;
  QString audioDevice;

 protected:
  void resizeEvent(QResizeEvent *);
 public:
  ConfigPlayer( QWidget *parent=0,  const char *name=0 );
  
 public slots:
  void cancel();
  void accept();

 signals:
  void audioDeviceChanged();

};

#endif
