/*
  Copyright (C) 1999 Rainer Maximini

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package
*/

#include "fadeDeviceGui.h"
#include "icons.h"

FadeDeviceGui::FadeDeviceGui( QWidget *parent=0, const char *name=0 )
  : QWidget(parent,name) {


  fadeSlider    = new QSlider(0,100,1,10,QSlider::Vertical,this,"fadeSlider");
  fadeSlider->setTickmarks(QSlider::Right);
  fadeSlider->setTickInterval(20);
  fadeInButton  = new KButton(this,"fadeInButton");
  fadeInButton  ->setPixmap(ICON_FADEIN_INACTIVE);
  fadeOutButton = new KButton(this,"fadeOutButton");
  fadeOutButton ->setPixmap(ICON_FADEOUT_INACTIVE);
  fadeSlider->setFocusPolicy(QWidget::NoFocus);
  fadeInButton->setFocusPolicy(QWidget::NoFocus);
  fadeOutButton->setFocusPolicy(QWidget::NoFocus);

  connect(fadeSlider,    SIGNAL(valueChanged(int)), this, SLOT(setVolumeFromSlider(int)));
  connect(fadeInButton,  SIGNAL(clicked()),         this, SLOT(fadeInButtonClicked()));
  connect(fadeOutButton, SIGNAL(clicked()),         this, SLOT(fadeOutButtonClicked()));

  fadeInActive  = false;
  fadeOutActive = false;
  volume = 0;
}

FadeDeviceGui::~FadeDeviceGui(){ 
  disconnect(fadeSlider ,NULL, this, NULL);
  disconnect(fadeInButton ,NULL, this, NULL);
  disconnect(fadeOutButton ,NULL, this, NULL);
}


/*
 * Public Slots
 */

void FadeDeviceGui::setVolume(int value){ 
  volume = value;
  fadeSlider->setValue(100-value);
}

void FadeDeviceGui::fadeIn(){
  fadeInActive = true;
  fadeOutActive = false;
  refresh();
}

void FadeDeviceGui::fadeOut(){
  fadeInActive  = false;
  fadeOutActive = true;
  refresh();
}

void FadeDeviceGui::stopFade(){
  fadeInActive  = false;
  fadeOutActive = false;
  refresh();
}



void FadeDeviceGui::setVolumeFromSlider(int value){  
  if(volume != 100-value)
    emit volumeChanged(100-value);
}


void FadeDeviceGui::fadeInButtonClicked(){
  if(fadeInActive)
    emit stopFadingClicked();
  else
    emit fadeInClicked();
  fadeInActive = !fadeInActive;
}

void FadeDeviceGui::fadeOutButtonClicked(){
  if(fadeOutActive)
    emit stopFadingClicked();
  else
    emit fadeOutClicked();
  fadeOutActive = !fadeOutActive;
}


void FadeDeviceGui::refresh(){
  if (fadeInActive)
    fadeInButton->setPixmap(ICON_FADEIN_ACTIVE);         
  else
    fadeInButton->setPixmap(ICON_FADEIN_INACTIVE);         
  
  if (fadeOutActive)
      fadeOutButton->setPixmap(ICON_FADEOUT_ACTIVE);         
  else
      fadeOutButton->setPixmap(ICON_FADEOUT_INACTIVE);         
}

    
void FadeDeviceGui::resizeEvent( QResizeEvent *tmp ){  
  fadeInButton  ->setGeometry(  0,  0, 25,        height());
  fadeSlider    ->setGeometry( 27,  0,width()-54, height());
  fadeOutButton ->setGeometry(width()-25,  0, 25, height());
}



