/*
  buffers audiodata
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#ifndef __AUDIOBUFFER_H
#define __AUDIOBUFFER_H

#include <iostream.h>
#include <deviceConfig/mem/memChunk.h>
#include <deviceConfig/info/info.h>

#define _AUDIOBUFFER_PREFERRED_FILLGRADE_DEFAULT 4096

extern "C" {
#include <stdio.h>
	   }



class AudioBuffer : public Info {

  int prefFillGrade;
  int nReadBytes;
  int lBufferFilled;
  float percent;

  MemChunk* memChunk;

 public:
  AudioBuffer();  // if size == 0 then it is shared!
  ~AudioBuffer();


  MemChunk* getMemChunk();
  void setMemChunk(MemChunk* memChunk); // useful for shared buffers

  int getPreferredFillGrade();
  void setPreferredFillGrade(int prefGrade);

  int getReadBytes();
  void setReadBytes(int bytes);

  int getBufferFilled();
  void setBufferFilled(int value);

  float getMainBufferFillgrade();
  void setMainBufferFillgrade(float percent);
  
  void copyTo(AudioBuffer* aBuffer);
  void print();
};

#endif
