/*
  defines the format of an audio stream
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#ifndef __AUDIOINFO_H
#define __AUDIOINFO_H

#include <iostream.h>
#include <deviceConfig/info/info.h>


class AudioInfo : public Info  {

  int   stereo;
  int   samplesize;
  int   speed;
  static char *device;

 public:
  AudioInfo();
  ~AudioInfo();

  //cd-quality:true,16,44100
  void setFormat(int stereo,int samplesize,int speed);  

  int getStereo() const;
  int getSampleSize() const;
  int getSpeed() const;
  const char* getDevice() const;
  

  void setStereo(int stereo);
  void setSampleSize(int samplesize);
  void setSpeed(int speed);
  void setDevice(const char* device);


  float calculateTime(int bytes);

  // returns true if both AudioInfos are the same
  int equals(AudioInfo* aInfo);
  void copyTo(AudioInfo* aInfo);

  void print();
  
};



#endif
