/*
  streams data from one source to n listeners
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#include <devices/multicastDevice.h>


MulticastDevice::MulticastDevice():OutputDevice("MulticastDevice") {
}


MulticastDevice::~MulticastDevice() {
}


char* MulticastDevice::getNodeName() {
  return "MulticastDevice";
}

  
void MulticastDevice::writeIn(NodeDevice* source,DeviceConfig* buf) {
  int i; 
  NodeDevice* nodeDevice;
  Edges* edges=getListeners();
  int n=edges->getElements();

  for (i=0;i<n;i++) {
    nodeDevice=edges->getNodeDevice(i);
    nodeDevice->writeInLock();
    nodeDevice->writeIn(this,buf);
    nodeDevice->writeInUnlock();
  }
}













