/*
  produces data and sends them through the device graph (abstract class)
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#ifndef __STREAMPRODUCER_H
#define __STREAMPRODUCER_H

#include <devices/outputDevice.h>
#include <graph/daisyChain.h>



#define _STREAMPRODUCER_DELIVERS_CONTINOUS    2
#define _STREAMPRODUCER_DELIVERS_SINGLE       4

/**
   A StreamProducer data. This device can be seen as a postman.
   He gets the data from his postoffice (a deviceConfigServer)
   and then delivers it to the connected listeners.
   This class is abstract. The real implementation is
   in genericStreamProducer.
   <p>
   You can set the "postman" in to different states. One state
   is _CONTINOUS_ (default) the other is _SINGLE. If the state is single
   The the postman waits after each delivery for a "wakeup"
   If it is continous he delivery until stopped by the 
   postoffice (deviceConfigServer)or the user.
   As every device this device sends _OUTPUT_GENERAL_EVENT 
   after every "tour".
   Then it sends _STREAMPRODUCER_DELIVERS_SINGLE events if
   the streamProducer in in the SINGLE state.
   A gui can monitor these events. For this it must set the EventQueue
   to "deliver all" Then the gui can wakeup the thread with
   the wakeup call.
   <p>
   The incBlockCounter can only be called during the delivery tour
   of the postman. But it should never be called directly by a
   device. Instead use correspondig daisyChain calls. Because
   If a device would call this method directly an then
   it is deleted it must keep track to delete the locks as well.
   This is already implemented in daisyChain. Thus use it!
   The daisyChain stores a global lock table for the whole graph.
   The decBlockCounter removes the lock. This can be called 
   (through daisyChain) by a device which already has called incBlockCounter
   (through daisyChain). <p>
   Why ever should a device block the producer?<p>
   Because a device must take care that it is not "floated" with
   data. It can stop the producer until it has the resources
   to get new data.
   
*/
   


class StreamProducer : public OutputDevice {

 public:
  StreamProducer();
  virtual ~StreamProducer();

  void setDeliverMode(int mode);
  int getDeliverMode();

  void wakeup();
  void dumpThread();
  int getInstanzCounter();

 protected:

  // can only be called by the delivering thread
  int waitForUnblock();

  int getRunCredit();
  void setRunCredit(int value);

  pthread_t tr;
  
  char* cThreadPos;
  int pid;
  int nBlockCounter;
  int mode;
  int runCredit;
  int instanz;

};


#endif
