/*
  abstract filter class
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#ifndef __FILTER_H
#define __FILTER_H

#include <accel/accelerator.h>
#include <deviceConfig/deviceConfigArray.h>
#include <limits.h>
#include "../../../../config.h"


/*
  filter implement algorithms which are used by devices.
  They transform the stream into another stream. 

  
  filter dont need to be thread safe. The devices takes care
  that a filter is only called by one thread.

*/


class Filter {

 public:
  Filter();
  virtual ~Filter();

  // usefull for the algorithms in the filter
  Accelerator* getAccelerator();

  virtual void transform(DeviceConfig* input,DeviceConfig* output);
  virtual void transform(DeviceConfigArray* input,DeviceConfig* output);

};

#endif;
