/*
  starts a new yafclient and stores the stdout,stdin,sterr channels
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <producer/yaf/yafClient.h>
#include "../../../../config.h"



    
YafClient::YafClient()  {
  multicaster=new YafMulticaster();

  outputDecoder=new OutputDecoderBridge(this);

  yafProcess = new YafProcess();
  inLineStack = new LineStack();
  outLineStack = new LineStack();
  tmpBuffer=new Buffer(512);
  msgBuffer=new Buffer(512);
  currentTransmitBuffer=new Buffer(512);
  lSending=false;
  cmdNr=100;       // we must start with a nr > 40 <= is resevered!
  parser=new Parser();
}


void YafClient::addArgument(char* arg) {
  (*yafProcess) << arg;
}



void YafClient::startDecoder() {
  char* msg="protocol\n";
  
  connect( yafProcess, SIGNAL(processExited(YafProcess*)),
	   SLOT(processExited(YafProcess*)));
  connect( yafProcess, SIGNAL(receivedStdout(YafProcess*, char*, int)),
	   SLOT(receivedStdout(YafProcess*, char*, int)));

  connect( yafProcess, SIGNAL(receivedStderr(YafProcess*, char*, int)),
	   SLOT(receivedStderr(YafProcess*, char*, int)));
  connect( yafProcess, SIGNAL(wroteStdin(YafProcess* )),
	            SLOT(  wroteStdin(YafProcess* )) );
  if (yafProcess->start(YafProcess::NotifyOnExit,YafProcess::All) == false) {
    debugOutput( cout << "process cannot be started"<<endl );
    exit(1);
  }
  // Ok after we have started the client we set him in raw-protocol-state
  rawSend(msg);
}



YafClient::~YafClient() {
  disconnect(this);

  if (yafProcess->isRunning()) {
    yafProcess->kill();
  }
  
  delete yafProcess;

  delete inLineStack;
  delete outLineStack;
  delete tmpBuffer;
  delete msgBuffer;
  delete currentTransmitBuffer;
  delete parser;
  delete outputDecoder;
  delete multicaster;
}


int YafClient::createCommand(char* msg, Buffer* cmd) { 
  int back=cmdNr;

  QString number;
  number=number.setNum(cmdNr);
  cmdNr++;

  cmd->clear();

  cmd->append("Command:");
  cmd->append(number.data());
  cmd->append(" Msg:");
  cmd->append(msg);

  return back;
}


int YafClient::send(char* msg) {
  int back;
  back=createCommand(msg,msgBuffer);
  rawSend(msgBuffer->getData());
  return back;
}




/*
  The return code is the number which is atteched to this command msg
*/
void YafClient::rawSend(char* msg) {
  if (lSending == false){
    lSending=true;
    currentTransmitBuffer->clear();
    currentTransmitBuffer->append(msg);
    writeStdinToProcess(currentTransmitBuffer->getData(),
			currentTransmitBuffer->len());
  } else {
    inLineStack->appendBottom(msg,strlen(msg));
  }
}
  

void YafClient::writeStdinToProcess(char* buf,int len) {
  int success;
  success=yafProcess->writeStdin(buf,len);
#ifdef _DEBUG_WRITE_STDIN
  ofstream infile("writeStdin.dbg",ios::app);
  Buffer myOut(80);
  myOut.append(buf,len);
  infile << "Success:"<<success<< "msg:"<<myOut.getData() <<endl;
#endif
}


void YafClient::wroteStdin(YafProcess *proc) {
  if (inLineStack->hasLine()) {
    inLineStack->nextLine(tmpBuffer);
    tmpBuffer->append("\n");
    writeStdinToProcess(tmpBuffer->getData(),tmpBuffer->len());
  } else {
    lSending=false;
  }
}
  

void YafClient::receivedStdout(YafProcess* proc, char* buffer, int buflen) {
  QString msg(buffer,buflen);
  CommandLine* commandLine;

  outLineStack->appendBottom(buffer,buflen);
#ifdef _DEBUG_STDOUT
  ofstream infile("receivedStdout.dbg",ios::app);
  Buffer myOut(80);
  myOut.append(buffer,buflen);
  infile << myOut.getData() <<endl;
#endif
  while(outLineStack->hasLine()) {
    outLineStack->nextLine(tmpBuffer);
    parser->setParseString(tmpBuffer->getData());
    parser->parse();
    
    if (parser->isOK()){
      commandLine=parser->getCommandLine();
      outputDecoder->processCommandLine(commandLine);
    }
  }


}

void YafClient::receivedStderr(YafProcess* proc, char* buffer, int buflen) {
  QString msg(buffer,buflen);
  debugOutput( cout << "buflen:"<<buflen<<endl );
  //debugOutput( cout << "Stderr: "<<msg<<endl );
}

void YafClient::processExited(YafProcess* proc) {

  debugOutput( cout << "******      ERROR *******************************"<<endl );
  debugOutput( cout << "* possible reasons: "<<endl );
  debugOutput( cout << "*"<<endl );
  debugOutput( cout << "* - decoder not found "<<endl );
  debugOutput( cout << "* - decoder crashed"<<endl );
  debugOutput( cout << "*"<<endl );
  debugOutput( cout << "* possible solutions:"<<endl );
  debugOutput( cout << "*"<<endl );
  debugOutput( cout << "* - you dont have the decoder in the search path!"<<endl );
  debugOutput( cout << "* - decoder cannot handle data!"<<endl );
  debugOutput( cout << "*"<<endl );
  debugOutput( cout << "*************************************************"<<endl );
  if (proc->isRunning() == false) {
    // never (really!) try to delete directly the class
    // when receive this signal. This can only be done
    // with a native and global signal->slot connection from the toolkit!
    processRuntimeCommand(_YAF_RUN_EXIT,"decoder terminated");
  }
}


//
//  Bridge to fix compiler bug (?) [START]
//


int YafClient::processRuntimeCommand(int command,char* args) {
  multicaster->multicastRuntimeCommand(command,args);
  return 1;
}



int YafClient::processReturnCommand(int cmdNr,int cmdId,
					      char* ret,char* args) {
  multicaster->multicastReturnCommand(cmdNr,cmdId,ret,args);
  return 1;
}


void YafClient::addYafListener(ControlChannel* listener) {
  multicaster->addYafListener(listener);
}


void YafClient::removeYafListener(ControlChannel* listener) {
  multicaster->removeYafListener(listener);
}


void YafClient::appendCommandTable(CommandTable* table) {
  outputDecoder->appendCommandTable(table);
}


void YafClient::appendRuntimeTable(CommandTable* table) {
  outputDecoder->appendRuntimeTable(table);
}
 

//
//  Bridge to fix compiler bug (?) [END]
//

   
