/*
  a wrapper for the audioDevice.
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <audio/audioWrapper.h>
#include "../../../../config.h"


AudioWrapper::AudioWrapper() {
  lopen=false;
}

AudioWrapper::~AudioWrapper() {
  if (lopen) {
    audioClose();
  }
}
 

int AudioWrapper::isOpen() {
  return lopen;
}

int AudioWrapper::open(){
  lopen=audioOpen();
  return lopen;
}  

int AudioWrapper::open(const char *device) {
  lopen=audioOpen(device);
  return lopen;
}  
 
int AudioWrapper::close() {
  if (isOpen() == true) {
    audioClose();
    lopen=false;
  }
  return true;
}


    


void AudioWrapper::init(int sampleSize,int speed,int stereo) {

  if (isOpen()) {
    audioInit(sampleSize,speed,stereo);
  } else {
    debugOutput( cout << "cannot init AudioDevice->not open!"<<endl );
  }
}


int AudioWrapper::write(char* buf,int len) {
  return audioWrite(buf,len);
}


void AudioWrapper::setVolume(float leftPercent,float rightPercent) {
  audioSetVolume((int)leftPercent,(int)rightPercent);
}


