/***************************************************************************
                          kmp3info.cpp  -  description                              
                             -------------------                                         
    begin                : Son Dez  5 13:44:54 CET 1999
                                           
    copyright            : (C) 1999 by Frank von Daak                         
    email                : frank.fun@skydsl.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "kmp3info.h"

char titel[31]="",artist[31]="",album[31]="",jahr[4]="",comment[31]="",fbuf[4];

KMP3Info::KMP3Info()
{
	kapp->getConfig()->setGroup("KMP3Info");
	mp3player = kapp->getConfig()->readEntry("MP3Player");
	titleXPos1 = 480;
	titleXLen1 = 0;
	titleXPos2 = 480;
	titleXLen2 = 0;
	initMenuBar();
	initToolBar();
	initView();
}

KMP3Info::~KMP3Info(){
}

void KMP3Info::getArgv( char *path )
{
	fileToOpen = path;
	if ( !fileToOpen.isEmpty() ) {
		argvFile();
		fileToOpen = fileName;
		return;
	} else {
		return;
	}
}

void KMP3Info::initMenuBar()
{
  ///////////////////////////////////////////////////////////////////
  // MENUBAR
  ///////////////////////////////////////////////////////////////////
  file_menu = new QPopupMenu();
  file_menu->insertItem(Icon("fileopen.xpm"), i18n("&Open..."), ID_OPEN );
  file_menu->connectItem(ID_OPEN, this, SLOT (openFile()));
  file_menu->insertSeparator();
  file_menu->insertItem(Icon("filefloppy.xpm") ,i18n("&Save"), ID_FILE_SAVE );
  file_menu->connectItem(ID_FILE_SAVE, this, SLOT (saveFile()));
  file_menu->insertSeparator();
  file_menu->insertItem(i18n("E&xit"), ID_FILE_QUIT );
  file_menu->connectItem(ID_FILE_QUIT, kapp, SLOT (quit()));
	
  ///////////////////////////////////////////////////////////////////
  // menuBar entry edit_menu
  options_menu = new QPopupMenu();
  options_menu->insertItem(Icon("start.xpm"), i18n("&Play File"), ID_EDIT_CUT );
  options_menu->connectItem(ID_EDIT_CUT, this, SLOT (playFile()));
  options_menu->insertItem(Icon("prev.xpm"), i18n("&Player-Setup"), ID_EDIT_PASTE );
	options_menu->connectItem( ID_EDIT_PASTE, this, SLOT (prefMenu()));
  ///////////////////////////////////////////////////////////////////
  // menuBar entry help_menu
  QString aboutstring=kapp->appName()+" "+VERSION+"\n(C)1999 by Frank von Daak\nfrank.fun@skydsl.de";

  help_menu = new QPopupMenu();
  help_menu = kapp->getHelpMenu(true, aboutstring );

  ///////////////////////////////////////////////////////////////////
  // MENUBAR CONFIGURATION
  menuBar()->insertItem(i18n("&File"), file_menu);
  menuBar()->insertItem(i18n("&Options"), options_menu);

  menuBar()->insertSeparator();
  menuBar()->insertItem(i18n("&Help"), help_menu);
  menuBar()->setItemEnabled(ID_FILE_SAVE, false);
  menuBar()->setItemEnabled(ID_EDIT_CUT, false);
}

void KMP3Info::initToolBar()
{
  ///////////////////////////////////////////////////////////////////
  // TOOLBAR
	toolBar()->insertButton(Icon("fileopen.xpm"), ID_TOPEN, SIGNAL(clicked(int)),
  			 this, SLOT(openFile(int)),true, i18n("Open File") );
  toolBar()->insertSeparator();
  toolBar()->insertButton(Icon("filefloppy.xpm"), ID_TFILE_SAVE, SIGNAL(clicked(int)),
  				this, SLOT(saveFile(int)), true, i18n("Save File") );
  toolBar()->insertSeparator();
  toolBar()->insertSeparator();
  toolBar()->insertButton(Icon("start.xpm"), ID_EDIT_CUT, SIGNAL(clicked(int)),
  				this, SLOT(playFile(int)), true, i18n("PlayMP3") );
  toolBar()->setItemEnabled(ID_TFILE_SAVE, false);
  toolBar()->setItemEnabled(ID_EDIT_CUT, false);
}

void KMP3Info::initView()
{
	QFont f ("Helvetica", 12, QFont::Bold);
	mainFrame = new QFrame(this);
	mainFrame->setFrameStyle( QFrame::WinPanel | QFrame::Raised);
	mainFrame->setGeometry(5,55,490,240);

	fileLab = new QLabel(i18n("Filename :"), mainFrame);
	fileLab->setGeometry(10,15,100,20);
	fileLab->setFont(f);
	
	fileLine = new QMultiLineEdit(mainFrame);
	fileLine->setGeometry(110,15,360,20);
	fileLine->setReadOnly(true);
	
	titleLab = new QLabel(i18n("Title        :"),mainFrame);
	titleLab->setGeometry(10,50,100,20);
	titleLab->setFont(f);
	
	titleLine = new QLineEdit(mainFrame);
	titleLine->setGeometry(110,50,300,20);
	titleLine->setMaxLength(30);

	artistLab = new QLabel(i18n("Artist      :"),mainFrame);
	artistLab->setGeometry(10,80,100,20);
	artistLab->setFont(f);
	
	artistLine = new QLineEdit(mainFrame);
	artistLine->setGeometry(110,80,300,20);
	artistLine->setMaxLength(30);

	albumLab = new QLabel(i18n("Album     :"),mainFrame);
	albumLab->setGeometry(10,110,100,20);
	albumLab->setFont(f);
	
	albumLine = new QLineEdit(mainFrame);
	albumLine->setGeometry(110,110,300,20);
	albumLine->setMaxLength(30);

	jahrLab = new QLabel(i18n("Year        :"),mainFrame);
	jahrLab->setGeometry(10,140,100,20);
	jahrLab->setFont(f);
	
	jahrLine = new QLineEdit(mainFrame);
	jahrLine->setGeometry(110,140,100,20);
	jahrLine->setMaxLength(4);

	commentLab = new QLabel(i18n("Comment :"),mainFrame);
	commentLab->setGeometry(10,170,100,20);
	commentLab->setFont(f);
	
	commentLine = new QLineEdit(mainFrame);
	commentLine->setGeometry(110,170,300,20);
	commentLine->setMaxLength(30);

 	fileLine->setEnabled(false);
	titleLine->setEnabled(false);
	artistLine->setEnabled(false);
	albumLine->setEnabled(false);
	jahrLine->setEnabled(false);
	commentLine->setEnabled(false);
}

void KMP3Info::openFile()
{
	openFile(0);
}

void KMP3Info::saveFile()
{
	saveFile(0);
}

void KMP3Info::playFile()
{
	playFile(0);
}

void KMP3Info::openFile(int)
{
// -- Hier wird der FileDialog geffnet, um die MP3-Datei einzuladen
	if ( fileToOpen.isEmpty() ) {
		fileToOpen=KFileDialog::getOpenFileName(QDir::homeDirPath(), "", this, i18n("Open File..."));
		}
	else {
		fileToOpen=KFileDialog::getOpenFileName(fileToOpen, "", this, i18n("Open File..."));
		}
	fileName = fileToOpen;
	if ( !(fp = fopen(fileToOpen,"rb+")) ) {
			   QMessageBox::warning (this, i18n("Error..."),
					i18n("The file doesnt exist,\nor is not readable !"));
		        return;
	}
	if(fileToOpen.isEmpty()){
		return ;
	} else {
// Die Funktion , die die Tags aus der geladenen MP3-Datei holt
		fread(sig,sizeof(sig),1,fp);
		sig[0] &= 0xff;                                                          
    	sig[1] &= 0xf0;                                                          
		if(!((sig[0] == 0xff) && (sig[1] == 0xf0))) {
			   QMessageBox::warning (this, i18n("Error..."),
					i18n("This doesnt seem to be a MP3-File"));
		        return ;
		}
	int slashPos = fileToOpen.findRev("/");
	fileToOpen.remove(0, slashPos+1);
    fileLine->setText((const char *)fileToOpen);
	if ( fseek(fp, -128, SEEK_END )) {
		 return;
	 }
		fread(fbuf,1,3,fp); fbuf[3] = '\0';
	if (!strcmp("TAG",fbuf)) {
		fseek(fp, -125, SEEK_END);
		fread(titel,1,30,fp);
			unpad (titel);
		fread(artist,1,30,fp);
			unpad (artist);
		fread(album,1,30,fp);
			unpad (album);
		fread(jahr,1,4,fp);
			unpad (jahr);
		fread(comment,1,29,fp);
			unpad (comment);
		fseek(fp, -128, SEEK_END);
	} else {
		fseek(fp, 0, SEEK_END);
    }
  }
 	fileLine->setEnabled(true);
	titleLine->setEnabled(true);
	artistLine->setEnabled(true);
	albumLine->setEnabled(true);
	jahrLine->setEnabled(true);
	commentLine->setEnabled(true);
	titleLine->setText(titel);
	artistLine->setText(artist);
	albumLine->setText(album);
	jahrLine->setText(jahr);
	commentLine->setText(comment);
  toolBar()->setItemEnabled(ID_TFILE_SAVE, true);
  menuBar()->setItemEnabled(ID_FILE_SAVE, true);
  toolBar()->setItemEnabled(ID_EDIT_CUT, true);
  menuBar()->setItemEnabled(ID_EDIT_CUT, true);
} // Funktion-ENDE

void KMP3Info::saveFile(int)
{
   	char tmp[31];
   	strcpy(fulltag,"TAG");
   	strcpy(tmp,titleLine->text());
   	strcat(fulltag,gpad(tmp,30));
   	strcpy(tmp,artistLine->text());
   	strcat(fulltag,gpad(tmp,30));
   	strcpy(tmp,albumLine->text());
   	strcat(fulltag,gpad(tmp,30));
   	strcpy(tmp,jahrLine->text());
   	strcat(fulltag,gpad(tmp,4));
   	strcpy(tmp,commentLine->text());
   	strcat(fulltag,gpad(tmp,29));
   	strcat(fulltag,"");
   	
   	fwrite(fulltag,1,128,fp);
   	fflush(fp);
}

char *KMP3Info::gpad (char *string, int length) {
	while( strlen(string) < length) {
		strcat(string," ");
	}
	return string;
}

void KMP3Info::unpad (char *string) {
	int x;
	for (x=(strlen(string)-1); x>=0; x--) {
		if (string[x]!=' ') {
			return;
		} else {
			string[x]='\0';
		}
	}
}

void KMP3Info::playFile(int)
{
	if ( mp3player.isEmpty() ) {
			   QMessageBox::warning (this, i18n("Error..."),
					i18n("You have not enterd the path to a MP3-Player"));
		        return;
	} else if ( fileName.isEmpty() ) {
			   QMessageBox::warning (this, i18n("Error..."),
					i18n("You first have to load a valid\nMP3-File, to play it."));
		        return;
	} else {
		KShellProcess *playit = new KShellProcess();
		QString fp;
		fp.sprintf("'%s'",(const char *)fileName);
		(*playit) << mp3player << fp;
		connect(playit, SIGNAL(receivedStderr(KProcess*, char *, int)),
						this, SLOT(playError(KProcess*, char *, int)));
		playit->start ( KShellProcess::DontCare, KProcess::Stderr);
	}
}

void KMP3Info::playError(KProcess *proc, char *err, int i)
{
	QString output;
	output.sprintf(i18n("An error occured, while trying to play the file !\nThe error was :\n%s"),err);
			   QMessageBox::warning (this, i18n("Error..."),(const char *)output);
		        return;
}

void KMP3Info::prefMenu()
{
	QFont f ("Helvetica", 12, QFont::Bold);

	prefWidg = new QWidget();
  prefWidg->setGeometry(((this->pos().x())+100), ((this->pos().y())+90),200,80);
  prefWidg->setFixedSize(350,145);

	QLabel *mainLab = new QLabel(i18n("Preferences-Menu"), prefWidg);
	mainLab->setFont(f);
	mainLab->setGeometry(80,5,120,20);

	QLabel *infoLab = new QLabel(i18n("Please give the path to your favorite mp3-Player\nor if it is in your path just enter its name :"), prefWidg);
	infoLab->setGeometry(10,30,330,45);

	QPushButton *openPath = new QPushButton(prefWidg); //,"Load");
	openPath->setPixmap(Icon("fileopen.xpm"));
	openPath->setGeometry(10,85,22,22);
	connect(openPath, SIGNAL(clicked()), this , SLOT(slotLoadPlayer()));
	
	pathLine = new QLineEdit(prefWidg);
	pathLine->setGeometry(35,85,255,22);
	
	QPushButton *prefOk = new QPushButton(prefWidg,i18n("Save"));
	prefOk->setText(i18n("Save"));
	prefOk->setGeometry(200,120,65,20);
	connect(prefOk, SIGNAL(clicked()), this, SLOT(slotPrefSave()));
	
	QPushButton *prefCancel = new QPushButton(prefWidg,i18n("Cancel"));
	prefCancel->setText(i18n("Cancel"));
	prefCancel->setGeometry(275,120,70,20);
	connect(prefCancel, SIGNAL(clicked()), this, SLOT(slotPrefKill()));
	
	prefWidg->show();
}

void KMP3Info::slotLoadPlayer()
{
		QString playerPath;
		playerPath = KFileDialog::getOpenFileName(fileToOpen, "", this, i18n("Open File..."));
		pathLine->setText(playerPath);		
}

void KMP3Info::slotPrefKill()
{
	prefWidg->close();
}

void KMP3Info::slotPrefSave()
{
	mp3player = pathLine->text();
  kapp->getConfig()->setGroup("KMP3Info");
	kapp->getConfig()->writeEntry("MP3Player", mp3player);
	prefWidg->close();
}

void KMP3Info::argvFile()
{
	fileName = fileToOpen;
	if ( !(fp = fopen(fileToOpen,"rb+")) ) {
			   QMessageBox::warning (this, i18n("Error..."),
					i18n("The file doesnt exist,\nor is not readable !"));
		        return;
	}
	if(fileToOpen.isEmpty()){
		return ;
	} else {
// Die Funktion , die die Tags aus der geladenen MP3-Datei holt
		fread(sig,sizeof(sig),1,fp);
		sig[0] &= 0xff;
    	sig[1] &= 0xf0;
		if(!((sig[0] == 0xff) && (sig[1] == 0xf0))) {
			   QMessageBox::warning (this, i18n("Error..."),
					i18n("This doesnt seem to be a MP3-File"));
		        return ;
		}
	int slashPos = fileToOpen.findRev("/");
	fileToOpen.remove(0, slashPos+1);
    fileLine->setText((const char *)fileToOpen);
	if ( fseek(fp, -128, SEEK_END )) {
		 return;
	 }
		fread(fbuf,1,3,fp); fbuf[3] = '\0';
	if (!strcmp("TAG",fbuf)) {
		fseek(fp, -125, SEEK_END);
		fread(titel,1,30,fp);
			unpad (titel);
		fread(artist,1,30,fp);
			unpad (artist);
		fread(album,1,30,fp);
			unpad (album);
		fread(jahr,1,4,fp);
			unpad (jahr);
		fread(comment,1,29,fp);
			unpad (comment);
		fseek(fp, -128, SEEK_END);
	} else {
		fseek(fp, 0, SEEK_END);
    }
  }
 	fileLine->setEnabled(true);
	titleLine->setEnabled(true);
	artistLine->setEnabled(true);
	albumLine->setEnabled(true);
	jahrLine->setEnabled(true);
	commentLine->setEnabled(true);
	titleLine->setText(titel);
	artistLine->setText(artist);
	albumLine->setText(album);
	jahrLine->setText(jahr);
	commentLine->setText(comment);
  toolBar()->setItemEnabled(ID_TFILE_SAVE, true);
  menuBar()->setItemEnabled(ID_FILE_SAVE, true);
  toolBar()->setItemEnabled(ID_EDIT_CUT, true);
  menuBar()->setItemEnabled(ID_EDIT_CUT, true);
}