/*
  Configuration for the esdDevice
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <esdDeviceConfig.h>


ESDDeviceConfig::ESDDeviceConfig(const char* configGroup,
				 QWidget * parent=0, const char * name=0 ) 
  : PrefConfig(parent,name) {

  config = kapp->getConfig();
  this->configGroup=configGroup;
  load();
  lCompiledIn=false;

  QVBoxLayout *vbox2 = new QVBoxLayout(this, 5);
  vbox2->addSpacing( fontMetrics().height() );

  autoCloseBox = new QCheckBox(i18n("close after 2 seconds"),
			    this,"autoCloseBox");
  autoCloseBox->setChecked(lAutoClose_cfg);
  autoCloseBox->setFixedSize(autoCloseBox->sizeHint());


  overrideBox = new QCheckBox(i18n("automatic initialisation"),
			    this,"overrideBox");
  overrideBox->setFixedSize(overrideBox->sizeHint());
  overrideBox->setChecked(lAutoInit_cfg);

  compiledLabel = new QLabel(this);
  setCompiledIn(lCompiledIn);

  vbox2->addWidget(autoCloseBox,0,AlignLeft);
  vbox2->addWidget(compiledLabel,0,AlignLeft);
  vbox2->addWidget(overrideBox,0,AlignLeft);

  
  sssBox=new SSSBox(this);
  vbox2->addSpacing(20);
  vbox2->addWidget(sssBox,0,AlignLeft);
  
  connect(overrideBox,SIGNAL(toggled(bool)),this,SLOT(autoInitToggle()));
  autoInitToggle();

}

ESDDeviceConfig::~ESDDeviceConfig() {
}


const char* ESDDeviceConfig::getGroupName() {
  return "ESD";
}


void ESDDeviceConfig::setCompiledIn(int lCompiledIn) {
  this->lCompiledIn=lCompiledIn;
  compiledLabel->setGeometry( 20, 105, 300, 20 );
  if (lCompiledIn) {
    compiledLabel->setText(i18n("ESD was succesfully compiled"));
  } else {
    compiledLabel->setText(i18n("ESD was NOT compiled"));
  }
  compiledLabel->setFixedSize(compiledLabel->sizeHint());
 
}


void ESDDeviceConfig::load() {
  config->setGroup(configGroup);
  lAutoClose_cfg=config->readBoolEntry( "autoClose", true);
  lAutoInit_cfg=true;
}


void ESDDeviceConfig::save() {
  lAutoClose_cfg=autoCloseBox->isChecked();

  config->setGroup(configGroup);
  config->writeEntry("autoClose",lAutoClose_cfg);
}


void ESDDeviceConfig::apply() {
  save();
  emit(applyEvent());
}


int ESDDeviceConfig::getAutoClose() {
  return (int)autoCloseBox->isChecked();
}

int ESDDeviceConfig::getAutoInit() {
  return (int)overrideBox->isChecked();
}


int ESDDeviceConfig::getSampleSize() {
  return sssBox->getSampleSize();
}


int ESDDeviceConfig::getSampleFreq() {
  return sssBox->getSampleFreq();
}

int ESDDeviceConfig::getStereo() {
  return sssBox->getStereo();
}
 

void ESDDeviceConfig::autoInitToggle() {
  int check=overrideBox->isChecked();
  if (check) {
    sssBox->setEnabled(false);
  } else {
    sssBox->setEnabled(true);
  }
}
