/*
  sends/receive commandline
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#ifndef __IPCCOM_H
#define __IPCCOM_H


#include <ipc/commandLineCreator.h>
#include <ipc/ipcElement.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <iostream.h>
#include <qsocketnotifier.h>

class IPCCom : public QObject {
 Q_OBJECT

  int ipcSocket;
  int lReadLoop;
  CommandLineCreator* commandLineCreator;
  struct sockaddr_un sockad;
  unsigned int addrlen;
  QSocketNotifier* socketNotifier;


 public:
  IPCCom(char* ipcFile,int lReadLoop);
  ~IPCCom();

  void send(int nargs,char** args);

 signals:
   void processCommandLine(CommandLineCreator* cmdLine);

 private slots:
   void dataReceived(int socket);
};


#endif
