/*
  whole ipc stuff in one class
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <ipc/ipcModule.h>


IPCModule::IPCModule(char* application) {

  ipcCom=NULL;

  // create data directory if necessary
  QString appName(application);
  QString p = getenv( "HOME" );
  QString rcDir = p + "/.kde/share/apps/"+appName;
  if ( access( rcDir, F_OK )<0) {
    cout << rcDir<<" not present"<<endl;
    // create it step by step
    rcDir=p+"/.kde";
    mkdir( rcDir, 0740 );
    rcDir=rcDir+"/share";
    mkdir( rcDir, 0740 );
    rcDir=rcDir+"/apps";
    mkdir( rcDir, 0740 );
    rcDir=rcDir+"/"+appName;
    mkdir( rcDir, 0740 );
    
    
    
  }
  QString id;
  id.setNum(getuid());

  QString ipcFile = "/tmp/"+appName+"_"+id+".ipc";

  QString lockFile = p + "/.kde/share/apps/"+appName+"/"+appName+".lck";
  lockfd=fopen(lockFile.data(),"w+");
  if (lockfd == NULL) {
    cout << lockFile<<endl;
    perror("open");exit(1);
  }
  if (chmod(lockFile.data(),S_IRUSR|S_IWUSR) < 0) {
     perror("chmod");exit(1);
  }


  int fdlockno=fileno(lockfd);
  struct flock lock;
  lock.l_type = F_WRLCK;
  lock.l_whence = 0;
  lock.l_start=0;
  lock.l_len=0;
  lock.l_pid=getpid();
  
  
  if (fcntl(fdlockno,F_SETLK,&lock) < 0) {
    cout << "First is false"<<endl;
    lFirst=false;
  } else {
    cout << "First is true"<<endl;
    unlink(ipcFile.data());
    int fd=fileno(lockfd);
    if (fcntl(fd,F_SETFD,true) < 0) {
      perror("lockFile");exit(1);
    }
 
    lFirst=true;
  } 
  ipcCom=new IPCCom(ipcFile.data(),lFirst);
  connect(ipcCom,SIGNAL(processCommandLine(CommandLineCreator*)),
	  this,SIGNAL(processCommandLine(CommandLineCreator*)));
  
}


IPCModule::~IPCModule() {
  closeIPC();
  ::close(sd);
}


int IPCModule::isFirst() {
  return lFirst;
}


void IPCModule::send(int nargs,char** args) {
  if (ipcCom != NULL) {
    ipcCom->send(nargs,args);
  }
}


void IPCModule::closeIPC() {
  if (ipcCom != NULL) {
    delete ipcCom;
    ipcCom=NULL;
    fclose(lockfd);
  }
}


  
