/*
  root window for kmpg (menu and all this stuff)
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#ifndef __KMPGMAINWINDOW_H
#define __KMPGMAINWINDOW_H

// KDE include files
#include <kmenubar.h>
#include <ktmainwindow.h> 

// QT include files
#include <qpopmenu.h>
#include <qaccel.h>

// Player include files:
#include <kmpgPlayer.h>
#include <kmpgCommandLine.h>


#include <playlistView2.h>
#include <id/playlistView3.h>
#include <playlistOperation.h>
#include <preferences.h>
#include <mixerConfig.h>
#include <ipc/ipcConfig.h>
#include <iostream.h>
#include <skinConfig.h>
#include <decoderStarter.h>
#include <openURLDialog.h>
#include <startUpConfig.h>
#include <selectInputDialog.h>
#include "shellWidget.h"


class KmpgMainWindow : public KTMainWindow {
  Q_OBJECT
 public:
  KmpgMainWindow();
  ~KmpgMainWindow();

  Playlist* getPlaylist();
  Preferences* getPreferences();

  NodeDevice* getOutputNode();

  void setInputNode(DecoderStarter* ourInput);
  DecoderStarter* getInputNode();
  void removeInputNode();

 public slots:
  void openFileSelector();
  void onDrop(KDNDDropZone*);
  void applySkin();
  void closeEvent ( QCloseEvent *);

 signals:
  void removeDecoder(KmpgMainWindow*);
  void newPlayerEvent();
  void outputConfig();
  void inputConfig();
  void closeIPCHandleForever();
  void outputSelectEvent();
  void inputSelectEvent();

 private slots:
  void closeWindow();
  void quit();
  void insertURL();
  void configGuiPlugin();
  void playlistView2Show(int);
  void playlistView2DoShow();
  void playlistView2DoHide();
  void menuBarMoved();

 private:
  void load();
  void save();
  void apply();

  void buildMenuBar();

  KConfig* config;

  int menuPos_cfg;

  DecoderStarter* ourInput;
  StandardGraph* standardGraph;
  KmpgPlayer* kmpgPlayer;
  GuiPlugin* guiPlugin;

  Playlist* playlist;
  KDNDDropZone* dropZone;
  PlaylistView2* playlistView2;
  Preferences* preferences;
  MixerConfig* mixerConfig;
  IPCConfig* ipcConfig;
  PlaylistView3* playlistView3;
  SkinConfig* skinConfig;
  ShellWidget* mainWidget;
  OpenURLDialog* openURLDialog;
  StartUpConfig* startUpConfig;
  SelectInputDialog* selectInputDialog;

};
#endif
