/*
  this class manages all instances of the players
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#ifndef __KMPGSERVER_H
#define __KMPGSERVER_H

#include <qobject.h>
#include <kmpgMainWindow.h>
#include <kmpgCommandLine.h>
#include <devices/mixerDevice.h>
#include <devices/audioDevice.h>
#include <devices/wavFileDevice.h>
#include <devices/esdDevice.h>
#include <devices/nasDevice.h>
#include <deviceConfig/mem/garbageCollector.h>
#include <preferences.h>
#include <startUpConfig.h>
#include <audioDeviceConfig.h>
#include <wavFileDeviceConfig.h>
#include <nasDeviceConfig.h>
#include <esdDeviceConfig.h>
#include <selectOutputDialog.h>

#include <qtimer.h>

class KmpgServer : public QObject {
 Q_OBJECT

  MixerDevice* mixerDevice;
  AudioDevice* audioDevice;
  NASDevice* nasDevice;
  ESDDevice* esdDevice;

  WavFileDevice* wavFileDevice;
  Preferences* preferences;
  AudioDeviceConfig* audioDeviceConfig;
  WavFileDeviceConfig* wavFileDeviceConfig;
  NASDeviceConfig* nasDeviceConfig;
  ESDDeviceConfig* esdDeviceConfig;
  SelectOutputDialog* selectOutputDialog;

  QTimer* openTimer;
  QTimer* stopTimer;
  int lStopRequest;
  int lOpenRequest;

 public:
   KmpgServer();
   ~KmpgServer();

 signals:
   void stopAllDecoders();
   void closeIPCHandleForever();


 public slots:
   void newPlayer();
   void processCommandLine(CommandLineCreator* cmdLine);
   void quit();
   int openOutputs();
   void configure();


 private slots:
   void deleteDecoder(KmpgMainWindow* win);
   void processAudioDeviceEvent(char msg);
   void applyAudioDevice();
   void applyWavFileDevice();
   void applyNASDevice();
   void stopOutputs();
   void processWavFileDeviceEvent(char);
   void updateWavWriter();
   void outputError(QString* deviceName);
   void disableAllOutputs();
   void outputEnable();
   
   
};
#endif
