/*
  dialog for skin selection
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <kmpgSkin.h>
#include <waSkin.h>

#include <skinConfig.h>



SkinConfig::SkinConfig(const char* configGroup,
		       QWidget * parent=0, const char * name=0 )
  : PrefConfig(parent,name) {
  this->configGroup=configGroup;
  config = kapp->getConfig();
  this->configGroup="Skin";
  load();


  QButtonGroup *bg = new QButtonGroup(i18n("select skin"),this);

  QVBoxLayout *vbox = new QVBoxLayout(bg, 5);
  vbox->addSpacing( bg->fontMetrics().height() );

  QRadioButton* rb1 = new QRadioButton(bg);
  rb1->setText(i18n("KDE"));
  rb1->setFixedSize( rb1->sizeHint() );
  
  QRadioButton* rb2 = new QRadioButton(bg);
  rb2->setText(i18n("winamp"));
  rb2->setFixedSize( rb2->sizeHint() );

  QRadioButton* rb3 = new QRadioButton(bg);
  rb3->setText(i18n("example"));
  rb3->setFixedSize( rb3->sizeHint() );

  bg->insert(rb1,__SKINID_KMPG);
  bg->insert(rb2,__SKINID_WINAMP);
  bg->insert(rb3,__SKINID_EXAMPLE);
  
  bg->setButton(skinId_cfg);
  bg->setFixedSize( bg->childrenRect().size() );

  vbox->addWidget(rb1,0,AlignLeft);
  vbox->addWidget(rb2,0,AlignLeft);
  vbox->addWidget(rb3,0,AlignLeft);

  QLabel* lineLable1 = new QLabel(this);
  lineLable1->setText(i18n("Note"));
  lineLable1->setFixedSize(lineLable1->sizeHint());

 
  QLabel* lineLable2 = new QLabel(this);
  lineLable2->setText(i18n("loading of new skins "));
  lineLable2->setFixedSize(lineLable2->sizeHint());
  
  QLabel* lineLable3= new QLabel(this);
  lineLable3->setText(i18n("can take a few seconds."));
  lineLable3->setFixedSize(lineLable3->sizeHint());

  QPushButton* button=new QPushButton(i18n("Configure skin"),this);
  button->setFixedSize(button->sizeHint());


  connect(bg,SIGNAL(pressed (int)),SLOT(setSkinId(int)));
  connect(button,SIGNAL(pressed()),SLOT(configSkin()));

  QVBoxLayout* vLayout=new QVBoxLayout(this,20);
  
  vLayout->addStretch();
  vLayout->addWidget(bg,0,AlignLeft);
  vLayout->addStretch();

  vLayout->addWidget(lineLable1,0,AlignLeft);
  vLayout->addWidget(lineLable2,0,AlignLeft);
  vLayout->addWidget(lineLable3,0,AlignLeft);
  vLayout->addWidget(button,0,AlignLeft);
  vLayout->addStretch();

 
 
}


SkinConfig::~SkinConfig() {
}


const char* SkinConfig::getGroupName() {
  return i18n("Skin");
}


void SkinConfig::load() {
  config->setGroup(configGroup);
  skinId_cfg=config->readNumEntry("skinId_cfg",__SKINID_WINAMP);
  (const char*)dirname_cfg=(const char*)config->readEntry("dirname_cfg", (const char*)"/opt/kde");
}


void SkinConfig::save() {
  config->setGroup(configGroup);
  config->writeEntry("skinId_cfg", skinId_cfg);
  config->readEntry("dirname_cfg", dirname_cfg);
}


void SkinConfig::apply() {
  save();
  emit(applyEvent());
}


void SkinConfig::setDirName(char*) {
}


char* SkinConfig::getDirName() {
  return "";
}


void SkinConfig::setSkinId(int skinId) {
  skinId_cfg=skinId;
}


int SkinConfig::getSkinId() {
  return skinId_cfg;
}


GuiPlugin* SkinConfig::createGuiPlugin(QWidget* parent) {
  GuiPlugin* guiPlugin=NULL;
  load();
  switch (skinId_cfg) {
  case __SKINID_KMPG: {
    guiPlugin=new KmpgSkin(parent);
    break;
  }
  case __SKINID_WINAMP: {
    guiPlugin=new WaSkin(parent);
    break;
  }
  case __SKINID_EXAMPLE: {
    guiPlugin=new KmpgSkin(parent);
    break;
  }
  default:
    cout << "unknown skin selected"<<endl;
    exit(0);
  }
  return guiPlugin;
}



void SkinConfig::configSkin() {
  apply();
  emit(configSkinEvent());
}

