/*
  abstract description of a decoder
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#ifndef __DECODERPLUGIN_H
#define __DECODERPLUGIN_H

#include <song.h>
#include <amplifier/amplifier.h>
#include <devices/genericPlayer.h>


#define _DECODER_UNKNOWN     0
#define _DECODER_MP3         1
#define _DECODER_WAV         2
#define _DECODER_MOD         3

#define _DECODER_MAX         4


/**
   This class encapsulates different decoder types.
   Derived classes should register the extension.
   This class is mainly used to find a match from a song
   to a valid decoder.The decoderID is not a startID for
   the amplifier class, its only a numeric represetation
   of the decoder name. Eg: MP3_DECODER whereas there may
   be many startModi for the decoder itsself.
*/


class DecoderPlugin : public QObject,public NodeDevice{

  GenericPlayer* player;

 public:
  DecoderPlugin();
  ~DecoderPlugin();

  int getDecoderID();

  // true if executable is found
  int isAvaiable();
  int canHandle(Song* song);

  void launch();
  void kill();

 private:

  // internal publics
  bool eventFilter( QObject* object, QEvent *e );

  

};
#endif
