/*
  configuration for startup behaviour
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <startUpConfig.h>




StartUpConfig::StartUpConfig(const char* configGroup,
			     QWidget * parent=0, const char * name=0 )
  : PrefConfig(parent,name) {
  this->configGroup=configGroup;
  config = kapp->getConfig();
  this->configGroup="StartUp";
  load();


  startUpBox= new QGroupBox(i18n("Start behaviour"),this, "startUpBox" );
  startUpBox->setGeometry(20, 40, 300, 120 );

  QVBoxLayout *vbox = new QVBoxLayout(startUpBox, 5);
  vbox->addSpacing( startUpBox->fontMetrics().height() );

  cb1 = new QCheckBox(i18n("insert song in playlist") ,startUpBox );
  cb1->setFixedSize(cb1->sizeHint());
  cb1->setChecked((bool)lInsertLast_cfg);

 
  cb2 = new QCheckBox(i18n("autoplay"),startUpBox );
  cb2->setFixedSize(cb1->sizeHint());
  cb2->setChecked((bool)lAutoplay_cfg);
 
  vbox->addWidget(cb1,0,AlignLeft);
  vbox->addWidget(cb2,0,AlignLeft);
 
  connect(cb1,SIGNAL(clicked()),SLOT(pressedInsertLast()));
  connect(cb2,SIGNAL(clicked()),SLOT(pressedAutoplay()));
}


StartUpConfig::~StartUpConfig() {
}


const char* StartUpConfig::getGroupName() {
  return i18n("Start");
}


void StartUpConfig::pressedInsertLast() {
  setInsertLast((int)cb1->isChecked());
}


void StartUpConfig::pressedAutoplay() {
  setAutoplay((int)cb2->isChecked());
}


void StartUpConfig::load() {
  config->setGroup(configGroup);
  lInsertLast_cfg=config->readBoolEntry("lInsertLast_cfg",true);
  lAutoplay_cfg=config->readBoolEntry("lAutoplay_cfg",true);
  lastSong_cfg=config->readEntry("lastSong_cfg","");
}


void StartUpConfig::save() {
  config->setGroup(configGroup);
  config->writeEntry("lInsertLast_cfg",lInsertLast_cfg);
  config->writeEntry("lAutoplay_cfg",lAutoplay_cfg);
}


void StartUpConfig::apply() {
  save();
  emit(applyEvent());
}


void StartUpConfig::setInsertLast(int lInsertLast) {
  lInsertLast_cfg=lInsertLast;
}


int StartUpConfig::getInsertLast() {
  return lInsertLast_cfg;
}



int StartUpConfig::getAutoplay() {
  return lAutoplay_cfg;
}


void StartUpConfig::setAutoplay(int lAutoplay) {
  lAutoplay_cfg=lAutoplay;
}


char* StartUpConfig::getLastSong() {
  return (lastSong_cfg.data());
}


void StartUpConfig::setLastSong(char* lastSong) {
  KConfig* config=kapp->getConfig();

  config->setGroup("StartUp");
  config->writeEntry("lastSong_cfg",lastSong);
}

