/*
  swiches in intervalls between decoders
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#ifndef __SWITCHER_H
#define __SWITCHER_H


#include <util/ptrArray.h>
#include <devices/genericPlayer.h>
#include <devices/audioDevice.h>


#include <qobject.h>            // belongs to QT
#include <qtimer.h>

class Switcher : public QObject {
  Q_OBJECT
  
  public:

  Switcher();
  ~Switcher();


  void add(GenericPlayer* decoder);
  void start(int sec);

 private slots:
    void timeEvent();

 private:
  
  int current;
  PtrArray* decoders;
  QTimer* timer;
  int msec;  
  AudioDevice* audioDevice;
};


#endif




    
