/*
  device stores the current video Info
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#include <videoDevice.h>



VideoDevice::VideoDevice():OutputDevice("VideoDevice") {
  current=NULL;
}


VideoDevice::~VideoDevice() {
}


char* VideoDevice::getNodeName() {
  return "VideoDevice";
}



int VideoDevice::requestLock() {
  MemChunk* memChunk;

  if (current != NULL) {
    memChunk=current->getMemChunk();
    memChunk->addLock();
  }
  return true;
}


void VideoDevice::releaseLock() {
  MemChunk* memChunk;

  if (current != NULL) {
    memChunk=current->getMemChunk();
    memChunk->removeLock();
  } 
}


QPixmap* VideoDevice::getCurrentPixmap() {
  if (current != NULL) {
    return current->getPixmap();
  } 
  return NULL;
}


void VideoDevice::writeIn(NodeDevice* source,DeviceConfig* config) {
  StatusInfo* statusInfo=config->getStatusInfo();
  
  if (statusInfo->getChange() == true) {
    cout << "StatusMessage ignored by videoDevice!"<<endl;
    return;
  }
  VideoStream* videoStream=config->getVideoStream();
  current=videoStream->getVideoInfo();
  getEventQueue()->sendEvent(_OUTPUT_GENERAL_EVENT);

  deliverToListener(config);


}


