/*
  what do you thing this class does? hm. If its name "volumefilter"
  Copyright (C) 1999 Rainer Maximini, Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include "bpmFilter.h"


BPMFilter::BPMFilter() {
  // must be big enough to store the biggest length possible
  maxLen=16*1024;
  workChunk=new MemChunk(maxLen);
  bpm=_BPM_NORMAL;

}


BPMFilter::~BPMFilter() {
  delete workChunk;
}

void BPMFilter::setBPM(int bpm) {
  this->bpm=bpm;
}


int BPMFilter::getBPM() {
  return bpm;
}


void BPMFilter::transform(DeviceConfig* config) {
  AudioInfo* audioInfo;
  AudioBuffer* audioBuffer;
  MemChunk* pcmChunk;
  AudioStream* audioStream=config->getAudioStream();


  audioInfo=audioStream->getAudioInfo();
  if (audioInfo->getStereo() == false) {
    cout << "device does not work with mono data!"<<endl;
    return;
  }
  if (audioInfo->getSampleSize() != 16) {
    cout << "device does not work with samples != 16 Bit"<<endl;
    return;
  }


  audioBuffer=audioStream->getAudioBuffer();
  pcmChunk=audioBuffer->getMemChunk();
  workChunk->setLen(0);
  if (pcmChunk == NULL) {
    cout << "pcmChunk is NULL"<<endl;
    return;
  }
  // pcmChunk: This is the raw pcm data.

  
  int i=0;
  int len=pcmChunk->getLen();       // div 2 because short = 16 Bit!
  if (len >= maxLen) {
    cout << "sorry too big input, cannot bpm it"<<endl;
    return;
  }
  char* pcmData=pcmChunk->getPtr();  // start pointer of data
  // now we change the data on the working memory
  // this is the filter.

  int workMemLen=0;
  char* workMemory=workChunk->getPtr();


  // my bmp algo:
  if (bpm == _BPM_NORMAL) {
    while(i<len) {
      workMemory[i]=pcmData[i];
      i=i+1;
    }
    workMemLen=len;
  } 
  if (bpm == _BPM_HALF) {
    while(i<(len-1)) {
      workMemory[i]=pcmData[i];
      workMemory[i+1]=pcmData[i+1];
      i=i+4;
      workMemLen+=2;
    }
  }
  if (bpm ==_BPM_DOUBLE) {
    while(i<(len-2)) {
      workMemory[i]=pcmData[i];
      workMemory[i+1]=pcmData[i+1];
      workMemory[i+2]=pcmData[i];
      workMemory[i+3]=pcmData[i+1];
      i=i+2;
      workMemLen+=4;
    }   
  }
  workChunk->setLen(workMemLen);


}


MemChunk* BPMFilter::getMemChunk() {
  return workChunk;
}
 
char* BPMFilter::getPtr() {
  return workChunk->getPtr();
}


int BPMFilter::getLen() {
  return workChunk->getLen();
}


int BPMFilter::getMaxLen() {
  return maxLen;
}
