/*
  show the bits per second in the stream
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#include <guiBPSDevice.h>




GuiBPSDevice::GuiBPSDevice(QWidget *parent=0, 
			       const char *name=0):GuiDevice( parent, name ) {

  currentSong=new Song("");
}


GuiBPSDevice::~GuiBPSDevice() {
  delete currentSong;
}


void GuiBPSDevice::setSong(Song* aSong) {
  aSong->copyTo(currentSong);
  emit(setSongEvent());
}


Song* GuiBPSDevice::getSong() {
  return currentSong;
}



void GuiBPSDevice::processEvent(char eventId) {
}


int GuiBPSDevice::getBPS() {
  if (currentSong->getDecoderType()==_EXTENSION_MP3) {
    Layer* layer=currentSong->getMP3LayerInfo();
    int back=(int)layer->bitrate();
    return back;
  }
  return 0;
}


QSize GuiBPSDevice::sizeHint () const {
  return QSize(20,10);
}


void GuiBPSDevice::paintEvent ( QPaintEvent * paintEvent ) {
  int bps;
  QPainter paint;
  char txt[10];

  txt[9]=0;

  erase(0,0,width(),height());
  bps=getBPS();
  snprintf((char*)&txt,8,"%d",bps);
  paint.begin( this );
  paint.drawText(0,10,(char*)txt);
  paint.end();  

}
