/*
  a basic control widget
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#include <guiControl.h>





GuiControl::GuiControl( QWidget *parent=0, 
			      const char *name=0 ): QWidget (parent,name) {
  
  genericPlayer=NULL;
}


GuiControl::~GuiControl() {
}



QSize GuiControl::sizeHint() const {
  QSize size(100,20);
  return size;
}


void GuiControl::buildGui() {
  layout = new QBoxLayout( this, QBoxLayout::LeftToRight, 1 );

  pauseButton = new QPushButton(i18n("Pause"), this ); 
  pauseButton->setMinimumSize( pauseButton->sizeHint() ); 
  connect(pauseButton , SIGNAL(clicked()), this, SLOT(pause()));
  layout->addWidget(pauseButton);

  playButton = new QPushButton(i18n("Play"), this ); 
  playButton->setMinimumSize( playButton->sizeHint() ); 
  connect(playButton , SIGNAL(clicked()), this, SLOT(play()));
  layout->addWidget(playButton);

  stopButton = new QPushButton(i18n("Stop"), this ); 
  stopButton->setMinimumSize( stopButton->sizeHint() ); 
  connect(stopButton , SIGNAL(clicked()), this, SLOT(close()));
  layout->addWidget(stopButton);

}



int GuiControl::close() {
  int back=0;
  if (genericPlayer != NULL) {
    back=genericPlayer->close();
  }
  return back;
}


int GuiControl::pause() {
  int back=0;
  if (genericPlayer != NULL) {
    back=genericPlayer->pause();
  }
  return back;
}


int GuiControl::play() {
  int back=0;
  if (genericPlayer != NULL) {
    back=genericPlayer->play();
  }
  return back;
}



void GuiControl::attachTo(GenericPlayer* genericPlayer) {
  if (this->genericPlayer != NULL) {
    cout << "GuiControl already attached. call ignored!"<<endl;
    return;
  }
  this->genericPlayer=genericPlayer;
}


void GuiControl::detach() {
  genericPlayer=NULL;
}



